/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.matrix;

import com.aliasi.matrix.DenseVector;
import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.matrix.Vector;
import com.aliasi.test.unit.Asserts;
import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Test;

public class SparseFloatVectorTest {
    @Test
    public void testAdd1() {
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 3;
        SparseFloatVector v1 = new SparseFloatVector(nArray, new float[]{0.0f, 4.0f, 9.0f}, 5);
        SparseFloatVector v2 = new SparseFloatVector(new int[]{1, 2, 4}, new float[]{-1.0f, -1.0f, -1.0f}, 5);
        Vector v3 = v1.add(v2);
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf((float)v3.value(0)));
        Assert.assertEquals((Object)Float.valueOf(-1.0f), (Object)Float.valueOf((float)v3.value(1)));
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf((float)v3.value(2)));
        Assert.assertEquals((Object)Float.valueOf(9.0f), (Object)Float.valueOf((float)v3.value(3)));
        Assert.assertEquals((Object)Float.valueOf(-1.0f), (Object)Float.valueOf((float)v3.value(4)));
        Vector v4 = v2.add(v1);
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf((float)v4.value(0)));
        Assert.assertEquals((Object)Float.valueOf(-1.0f), (Object)Float.valueOf((float)v4.value(1)));
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf((float)v4.value(2)));
        Assert.assertEquals((Object)Float.valueOf(9.0f), (Object)Float.valueOf((float)v4.value(3)));
        Assert.assertEquals((Object)Float.valueOf(-1.0f), (Object)Float.valueOf((float)v4.value(4)));
    }

    @Test
    public void testAdd2() {
        int[] nArray = new int[2];
        nArray[1] = 2;
        SparseFloatVector v1 = new SparseFloatVector(nArray, new float[]{0.0f, 1.0f}, 5);
        SparseFloatVector v2 = new SparseFloatVector(new int[0], new float[0], 5);
        Vector v3 = v1.add(v2);
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf((float)v3.value(0)));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf((float)v3.value(1)));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf((float)v3.value(2)));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf((float)v3.value(3)));
        Vector v4 = v2.add(v1);
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf((float)v4.value(0)));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf((float)v4.value(1)));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf((float)v4.value(2)));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf((float)v4.value(3)));
    }

    @Test
    public void testIncrementZeros() {
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 4;
        SparseFloatVector v1 = new SparseFloatVector(nArray, new float[]{5.0f, 6.0f, 7.0f}, 5);
        Assert.assertEquals((int)3, (int)v1.nonZeroDimensions().length);
        Assert.assertEquals((double)5.0, (double)v1.value(0), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)v1.value(1), (double)1.0E-4);
        Assert.assertEquals((double)6.0, (double)v1.value(2), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)v1.value(3), (double)1.0E-4);
        Assert.assertEquals((double)7.0, (double)v1.value(4), (double)1.0E-4);
    }

    @Test
    public void testExplicitCons() {
        SparseFloatVector v = new SparseFloatVector(new int[]{1, 2, 5}, new float[]{3.0f, 6.0f, 15.0f}, 10);
        Assert.assertEquals((int)10, (int)v.numDimensions());
        Assert.assertEquals((double)0.0, (double)v.value(0), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)v.value(4), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)v.value(1), (double)1.0E-4);
        Assert.assertEquals((double)6.0, (double)v.value(2), (double)1.0E-4);
        Assert.assertEquals((double)15.0, (double)v.value(5), (double)1.0E-4);
        try {
            new SparseFloatVector(new int[]{3, 2, 5}, new float[]{1.0f, 2.0f, 3.0f}, 10);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            new SparseFloatVector(new int[]{1, 2, 5}, new float[]{0.0f, 0.0f, 0.0f}, 5);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            new SparseFloatVector(new int[]{1, 2}, new float[]{0.0f, 0.0f, 0.0f}, 5);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }

    @Test
    public void testSerialization() {
        HashMap<Integer, Float> map = new HashMap<Integer, Float>();
        Asserts.assertFullSerialization(new SparseFloatVector(map));
        map.put(0, Float.valueOf(1.0f));
        Asserts.assertFullSerialization(new SparseFloatVector(map));
        map.put(17, Float.valueOf(2.0f));
        Asserts.assertFullSerialization(new SparseFloatVector(map));
        map.put(0x7FFFFFFE, Float.valueOf(3.0f));
        Asserts.assertFullSerialization(new SparseFloatVector(map));
    }

    @Test
    public void testZero() {
        HashMap map = new HashMap();
        SparseFloatVector vec0 = new SparseFloatVector(map);
        Assert.assertEquals((int)0, (int)vec0.numDimensions());
        Assert.assertEquals((double)0.0, (double)vec0.length(), (double)0.001);
        Assert.assertEquals((Object)0.0, (Object)vec0.dotProduct(vec0));
        try {
            vec0.setValue(2, 5.0);
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Asserts.succeed();
        }
        try {
            vec0.value(3);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            Asserts.succeed();
        }
        Asserts.assertFullEquals(vec0, vec0);
    }

    @Test
    public void testOne() {
        HashMap<Integer, Float> map1 = new HashMap<Integer, Float>();
        map1.put(3, new Float(5.0f));
        SparseFloatVector vec1 = new SparseFloatVector(map1);
        Asserts.assertFullEquals(vec1, vec1);
        Assert.assertEquals((int)4, (int)vec1.numDimensions());
        Assert.assertEquals((double)5.0, (double)vec1.length(), (double)0.001);
        Assert.assertEquals((Object)25.0, (Object)vec1.dotProduct(vec1));
        Assert.assertEquals((Object)1.0, (Object)vec1.cosine(vec1));
        HashMap<Integer, Float> map2 = new HashMap<Integer, Float>();
        map2.put(3, new Float(7.0f));
        map2.put(1, new Float(9.0f));
        SparseFloatVector vec2 = new SparseFloatVector(map2);
        Asserts.assertFullEquals(vec2, vec2);
        Assert.assertFalse((boolean)vec1.equals(vec2));
        Assert.assertEquals((int)4, (int)vec2.numDimensions());
        Assert.assertEquals((Object)1.0, (Object)vec2.cosine(vec2));
        Assert.assertEquals((double)Math.sqrt(130.0), (double)vec2.length(), (double)1.0E-4);
        Assert.assertEquals((double)35.0, (double)vec1.dotProduct(vec2), (double)1.0E-4);
    }

    @Test
    public void testTwo() {
        HashMap<Integer, Float> map1 = new HashMap<Integer, Float>();
        map1.put(0, new Float(3.0f));
        map1.put(1, new Float(5.0f));
        map1.put(5, new Float(7.0f));
        SparseFloatVector vec1 = new SparseFloatVector(map1);
        HashMap<Integer, Float> map2 = new HashMap<Integer, Float>();
        map2.put(0, new Float(11.0f));
        map2.put(1, new Float(13.0f));
        map2.put(3, new Float(17.0f));
        SparseFloatVector vec2 = new SparseFloatVector(map2, 6);
        double len1 = Math.sqrt(83.0);
        double len2 = Math.sqrt(579.0);
        double product = 98.0;
        double cos = product / (len1 * len2);
        Assert.assertEquals((double)product, (double)vec1.dotProduct(vec2), (double)1.0E-4);
        Assert.assertEquals((double)cos, (double)vec1.cosine(vec2), (double)1.0E-4);
    }

    @Test
    public void testMixed() {
        HashMap<Integer, Float> map1 = new HashMap<Integer, Float>();
        map1.put(0, new Float(3.0f));
        map1.put(1, new Float(5.0f));
        map1.put(5, new Float(7.0f));
        SparseFloatVector vec1 = new SparseFloatVector(map1);
        DenseVector vec3 = new DenseVector(new double[]{3.0, 5.0, 0.0, 0.0, 0.0, 7.0});
        Asserts.assertFullEquals(vec1, vec3);
    }

    @Test
    public void testNumber() {
        HashMap<Integer, Number> map1 = new HashMap<Integer, Number>();
        map1.put(0, 1);
        map1.put(2, 3.0);
        SparseFloatVector vec = new SparseFloatVector(map1);
        Assert.assertEquals((double)1.0, (double)vec.value(0), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)vec.value(1), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)vec.value(2), (double)1.0E-4);
    }
}

