/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.matrix;

import com.aliasi.matrix.DenseVector;
import com.aliasi.matrix.EuclideanDistance;
import com.aliasi.matrix.MinkowskiDistance;
import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.matrix.TaxicabDistance;
import com.aliasi.matrix.Vector;
import com.aliasi.test.unit.Asserts;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Distance;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class MinkowskiDistanceTest {
    @Test
    public void testOne() throws IOException, ClassNotFoundException {
        DenseVector v1 = new DenseVector(new double[]{1.0, 2.0});
        DenseVector v2 = new DenseVector(new double[]{3.0, 1.0});
        HashMap<Integer, Double> map1 = new HashMap<Integer, Double>();
        map1.put(0, 1.0);
        map1.put(1, 2.0);
        HashMap<Integer, Double> map2 = new HashMap<Integer, Double>();
        map2.put(0, 3.0);
        map2.put(1, 1.0);
        SparseFloatVector sv1 = new SparseFloatVector(map1);
        SparseFloatVector sv2 = new SparseFloatVector(map2);
        MinkowskiDistance d1 = new MinkowskiDistance(3);
        Assert.assertEquals((double)Math.pow(9.0, 0.3333333333333333), (double)d1.distance(v1, v2), (double)1.0E-4);
        Assert.assertEquals((double)Math.pow(9.0, 0.3333333333333333), (double)d1.distance(sv1, sv2), (double)1.0E-4);
        Assert.assertEquals((double)Math.pow(9.0, 0.3333333333333333), (double)d1.distance(v1, sv2), (double)1.0E-4);
        Assert.assertEquals((double)Math.pow(9.0, 0.3333333333333333), (double)d1.distance(sv1, v2), (double)1.0E-4);
        MinkowskiDistance d2 = (MinkowskiDistance)AbstractExternalizable.serializeDeserialize(d1);
        Assert.assertEquals((double)Math.pow(9.0, 0.3333333333333333), (double)d2.distance(v1, v2), (double)1.0E-4);
        Assert.assertEquals((double)Math.pow(9.0, 0.3333333333333333), (double)d2.distance(v1, sv2), (double)1.0E-4);
        Assert.assertEquals((double)Math.pow(9.0, 0.3333333333333333), (double)d2.distance(sv1, v2), (double)1.0E-4);
        Assert.assertEquals((double)Math.pow(9.0, 0.3333333333333333), (double)d2.distance(sv1, sv2), (double)1.0E-4);
        HashMap<Integer, Double> map3 = new HashMap<Integer, Double>();
        map3.put(1, -1.0);
        SparseFloatVector vA = new SparseFloatVector(map3, 5);
        HashMap<Integer, Double> map4 = new HashMap<Integer, Double>();
        map4.put(2, 1.0);
        SparseFloatVector vB = new SparseFloatVector(map4, 5);
        Assert.assertEquals((double)Math.pow(2.0, 0.3333333333333333), (double)d2.distance(vA, vB), (double)1.0E-4);
        Assert.assertEquals((double)Math.pow(2.0, 0.3333333333333333), (double)d2.distance(vB, vA), (double)1.0E-4);
        DenseVector vC = new DenseVector(new double[]{0.0, 1.0, 0.0, 0.0, 0.0});
        DenseVector vD = new DenseVector(new double[]{0.0, 0.0, 1.0, 0.0, 0.0});
        Assert.assertEquals((double)Math.pow(2.0, 0.3333333333333333), (double)d2.distance(vA, vD), (double)1.0E-4);
        Assert.assertEquals((double)Math.pow(2.0, 0.3333333333333333), (double)d2.distance(vD, vA), (double)1.0E-4);
        Assert.assertEquals((double)Math.pow(2.0, 0.3333333333333333), (double)d2.distance(vC, vB), (double)1.0E-4);
        Assert.assertEquals((double)Math.pow(2.0, 0.3333333333333333), (double)d2.distance(vB, vC), (double)1.0E-4);
    }

    public void randomTest() {
        MinkowskiDistance L1 = new MinkowskiDistance(1);
        MinkowskiDistance L2 = new MinkowskiDistance(2);
        Random random = new Random();
        int numDimensions = random.nextInt(20) + 5;
        double[] xs = new double[numDimensions];
        int i = 0;
        while (i < xs.length) {
            xs[i] = random.nextDouble();
            ++i;
        }
        DenseVector v0 = new DenseVector(xs);
        Vector sv1 = this.randomSparseVector(random, numDimensions);
        Vector sv2 = this.randomSparseVector(random, numDimensions);
        this.assertSame(v0, sv1);
        this.assertSame(v0, sv2);
        this.assertSame(sv1, sv2);
    }

    void assertSame(Vector v1, Vector v2) {
        this.assertSame(v1, v2, new MinkowskiDistance(1), TaxicabDistance.DISTANCE);
        this.assertSame(v1, v2, new MinkowskiDistance(2), EuclideanDistance.DISTANCE);
    }

    void assertSame(Vector v1, Vector v2, Distance<Vector> d1, Distance<Vector> d2) {
        Assert.assertEquals((double)d1.distance(v1, v2), (double)d2.distance(v1, v2), (double)1.0E-4);
        Assert.assertEquals((double)d1.distance(v1, v2), (double)d2.distance(v2, v1), (double)1.0E-4);
        Assert.assertEquals((double)d1.distance(v2, v1), (double)d2.distance(v2, v1), (double)1.0E-4);
    }

    Vector randomSparseVector(Random random, int numDimensions) {
        HashMap<Integer, Double> map1 = new HashMap<Integer, Double>();
        int numEntries = random.nextInt(numDimensions + 1);
        int i = 0;
        while (i < numEntries) {
            map1.put(random.nextInt(numDimensions), random.nextDouble());
            ++i;
        }
        return new SparseFloatVector(map1, numDimensions);
    }

    @Test
    public void testExs() {
        DenseVector v1 = new DenseVector(new double[]{0.0, 1.0});
        DenseVector v2 = new DenseVector(new double[]{2.0});
        try {
            new MinkowskiDistance(3).distance(v1, v2);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }
}

