/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.matrix;

import com.aliasi.matrix.DenseMatrix;
import com.aliasi.matrix.DenseVector;
import com.aliasi.matrix.Vector;
import com.aliasi.test.unit.Asserts;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class DenseMatrixTest {
    @Test
    public void testRowVectors() {
        DenseMatrix m = new DenseMatrix(new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}});
        Vector v = m.rowVector(0);
        Assert.assertEquals((int)3, (int)v.numDimensions());
        Assert.assertEquals((double)2.0, (double)v.value(1), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)v.value(2), (double)1.0E-4);
        v.setValue(1, 42.0);
        Assert.assertEquals((double)42.0, (double)m.value(0, 1), (double)1.0E-4);
        v.setValue(1, 2.0);
        Assert.assertEquals((double)Math.sqrt(14.0), (double)v.length(), (double)1.0E-4);
        Vector v2 = m.rowVector(1);
        Assert.assertEquals((double)32.0, (double)v.dotProduct(v2), (double)1.0E-4);
        Assert.assertEquals((double)(v.dotProduct(v2) / (Math.sqrt(14.0) * Math.sqrt(77.0))), (double)v.cosine(v2), (double)1.0E-4);
        new DenseVector(new double[]{1.0, 2.0, 3.0, 4.0});
        Asserts.succeed();
    }

    @Test
    public void testColVectors() {
        DenseMatrix m = new DenseMatrix(new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}});
        Vector v = m.columnVector(1);
        Assert.assertEquals((int)2, (int)v.numDimensions());
        Assert.assertEquals((double)2.0, (double)v.value(0), (double)1.0E-4);
        Assert.assertEquals((double)5.0, (double)v.value(1), (double)1.0E-4);
        v.setValue(1, 42.0);
        Assert.assertEquals((double)42.0, (double)m.value(1, 1), (double)1.0E-4);
    }

    @Test
    public void testSized() {
        DenseMatrix m = new DenseMatrix(2, 3);
        Assert.assertEquals((int)2, (int)m.numRows());
        Assert.assertEquals((int)3, (int)m.numColumns());
        Assert.assertEquals((double)0.0, (double)m.value(1, 2), (double)0.001);
        Assert.assertEquals((double)0.0, (double)m.value(0, 1), (double)0.001);
        m.setValue(0, 1, 5.0);
        Assert.assertEquals((double)5.0, (double)m.value(0, 1), (double)0.001);
    }

    @Test
    public void testHashCode() {
        DenseMatrix m = new DenseMatrix(new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}});
        List<Double> list = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0);
        Assert.assertEquals((int)list.hashCode(), (int)m.hashCode());
    }

    @Test
    public void testEquals() {
        DenseMatrix m1 = new DenseMatrix(new double[][]{{1.0, 2.0}, {3.0, 4.0}});
        DenseMatrix m2 = new DenseMatrix(new double[][]{{1.0, 2.0}, {3.0, 4.0}});
        Asserts.assertFullEquals(m1, m2);
    }

    @Test
    public void testAllocated() {
        DenseMatrix m = new DenseMatrix(new double[][]{{1.0, 2.0, 3.0}, {3.0, 4.0, 5.0}});
        Assert.assertEquals((int)2, (int)m.numRows());
        Assert.assertEquals((int)3, (int)m.numColumns());
        Assert.assertEquals((double)1.0, (double)m.value(0, 0), (double)1.0E-4);
        DenseMatrix m2 = new DenseMatrix(new double[][]{{1.0, 2.0, 3.0}, {3.0, 4.0, 5.0}});
        Assert.assertEquals((int)2, (int)m2.numRows());
        Assert.assertEquals((int)3, (int)m2.numColumns());
        Assert.assertEquals((double)1.0, (double)m2.value(0, 0), (double)1.0E-4);
    }

    @Test
    public void testConstructorExs() {
        try {
            new DenseMatrix(new double[0][0]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new DenseMatrix(new double[2][0]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new DenseMatrix(new double[0][2]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new DenseMatrix(0, 2);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new DenseMatrix(3, 0);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

