/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.lm;

import com.aliasi.lm.UniformProcessLM;
import com.aliasi.test.unit.lm.UniformBoundaryLMTest;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class UniformProcessLMTest {
    @Test
    public void testProcess() {
        UniformProcessLM lm = new UniformProcessLM(32);
        Assert.assertEquals((double)0.0, (double)lm.log2Estimate(new char[0], 0, 0), (double)0.005);
        Assert.assertEquals((double)0.0, (double)lm.log2Estimate(new char[]{'a'}, 0, 0), (double)0.005);
        Assert.assertEquals((double)-5.0, (double)lm.log2Estimate(new char[]{'a'}, 0, 1), (double)0.005);
        lm.train("foo");
        Assert.assertEquals((double)-5.0, (double)lm.log2Estimate(new char[]{'a'}, 0, 1), (double)0.005);
        Assert.assertEquals((double)-10.0, (double)lm.log2Estimate(new char[]{'a', 'b'}, 0, 2), (double)0.005);
    }

    @Test
    public void testSerializable() throws ClassNotFoundException, IOException {
        UniformProcessLM lm = new UniformProcessLM(32);
        Object serDeser = UniformBoundaryLMTest.compileRead(lm);
        UniformProcessLM lmIO = (UniformProcessLM)serDeser;
        Assert.assertEquals((double)-0.0, (double)lmIO.log2Estimate(new char[0], 0, 0), (double)0.005);
        Assert.assertEquals((double)-5.0, (double)lmIO.log2Estimate(new char[]{'a'}, 0, 1), (double)0.005);
        Assert.assertEquals((double)-10.0, (double)lmIO.log2Estimate(new char[]{'a', 'b'}, 0, 2), (double)0.005);
    }

    @Test
    public void testExs() {
        try {
            new UniformProcessLM(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new UniformProcessLM(Integer.MAX_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new UniformProcessLM(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new UniformProcessLM(Integer.MAX_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

