/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.lm;

import com.aliasi.lm.TrieIntSeqCounter;
import com.aliasi.util.ObjectToCounterMap;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class TrieIntSeqCounterTest {
    public int A = 97;
    public int B = 98;
    public int C = 99;
    public int D = 100;
    public int R = 114;
    public int[] ABRACADABRA = new int[]{this.A, this.B, this.R, this.A, this.C, this.A, this.D, this.A, this.B, this.R, this.A};

    @Test
    public void testZero() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(3);
        int[] is_12 = new int[]{1, 2};
        int[] is_13 = new int[]{1, 3};
        counter.incrementSequence(is_12, 0, 2, 12);
        junit.framework.Assert.assertEquals((int)12, (int)counter.count(is_12, 0, 2));
        junit.framework.Assert.assertEquals((long)12L, (long)counter.extensionCount(is_12, 0, 1));
        counter.incrementSequence(is_13, 0, 2, 10);
        junit.framework.Assert.assertEquals((int)10, (int)counter.count(is_13, 0, 2));
        junit.framework.Assert.assertEquals((long)22L, (long)counter.extensionCount(is_13, 0, 1));
        counter.incrementSequence(is_13, 0, 2, 44);
        junit.framework.Assert.assertEquals((int)54, (int)counter.count(is_13, 0, 2));
        junit.framework.Assert.assertEquals((long)66L, (long)counter.extensionCount(is_13, 0, 1));
        counter.incrementSequence(is_13, 0, 0, 111);
        junit.framework.Assert.assertEquals((int)111, (int)counter.count(is_13, 0, 0));
        counter.incrementSequence(is_13, 0, 1, 444);
        junit.framework.Assert.assertEquals((int)444, (int)counter.count(is_13, 0, 1));
        junit.framework.Assert.assertEquals((long)444L, (long)counter.extensionCount(is_13, 0, 0));
        counter.incrementSequence(is_13, 0, 0, 111);
        junit.framework.Assert.assertEquals((int)222, (int)counter.count(is_13, 0, 0));
        counter.incrementSequence(is_13, 0, 1, 444);
        junit.framework.Assert.assertEquals((int)888, (int)counter.count(is_13, 0, 1));
        junit.framework.Assert.assertEquals((long)888L, (long)counter.extensionCount(is_13, 0, 0));
        int[] is_2 = new int[]{2};
        int[] is_3 = new int[]{3};
        int[] is_4 = new int[]{4};
        counter.incrementSequence(is_2, 0, 1, 10);
        counter.incrementSequence(is_3, 0, 1, 100);
        counter.incrementSequence(is_4, 0, 1, 1000);
        junit.framework.Assert.assertEquals((int)10, (int)counter.count(is_2, 0, 1));
        junit.framework.Assert.assertEquals((int)100, (int)counter.count(is_3, 0, 1));
        junit.framework.Assert.assertEquals((int)1000, (int)counter.count(is_4, 0, 1));
        junit.framework.Assert.assertEquals((long)1998L, (long)counter.extensionCount(is_4, 0, 0));
    }

    @Test
    public void testSequence() {
        int[] is_1 = new int[]{1};
        TrieIntSeqCounter counter = new TrieIntSeqCounter(3);
        counter.incrementSequence(is_1, 0, 1, 3);
        junit.framework.Assert.assertEquals((long)3L, (long)counter.extensionCount(is_1, 0, 0));
        junit.framework.Assert.assertEquals((int)3, (int)counter.count(is_1, 0, 1));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.extensionCount(is_1, 0, 1));
        int[] is_123 = new int[]{1, 2, 3};
        counter.incrementSequence(is_123, 0, 3, 5);
        junit.framework.Assert.assertEquals((long)3L, (long)counter.extensionCount(is_1, 0, 0));
        junit.framework.Assert.assertEquals((int)3, (int)counter.count(is_1, 0, 1));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.extensionCount(is_1, 0, 1));
        junit.framework.Assert.assertEquals((int)5, (int)counter.count(is_123, 0, 3));
        junit.framework.Assert.assertEquals((long)5L, (long)counter.extensionCount(is_123, 0, 2));
        int[] is_12345 = new int[]{1, 2, 3, 4, 5};
        int[] is_345 = new int[]{3, 4, 5};
        int[] is_34 = new int[]{3, 4};
        counter.incrementSequence(is_12345, 0, 5, 109);
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(is_12345, 0, 5));
        junit.framework.Assert.assertEquals((long)109L, (long)counter.extensionCount(is_34, 0, 2));
        junit.framework.Assert.assertEquals((int)109, (int)counter.count(is_345, 0, 3));
        junit.framework.Assert.assertEquals((int)109, (int)counter.count(is_12345, 2, 5));
        int[] is_134 = new int[]{1, 3, 4};
        int[] is_135 = new int[]{1, 3, 5};
        int[] is_136 = new int[]{1, 3, 6};
        int[] is_137 = new int[]{1, 3, 7};
        counter.incrementSequence(is_134, 0, 3, 12);
        junit.framework.Assert.assertEquals((int)12, (int)counter.count(is_134, 0, 3));
        counter.incrementSequence(is_134, 0, 3, 10);
        junit.framework.Assert.assertEquals((int)22, (int)counter.count(is_134, 0, 3));
        counter.incrementSequence(is_135, 0, 3, 44);
        junit.framework.Assert.assertEquals((int)22, (int)counter.count(is_134, 0, 3));
        junit.framework.Assert.assertEquals((int)44, (int)counter.count(is_135, 0, 3));
        counter.incrementSequence(is_136, 0, 3, 55);
        junit.framework.Assert.assertEquals((int)22, (int)counter.count(is_134, 0, 3));
        junit.framework.Assert.assertEquals((int)44, (int)counter.count(is_135, 0, 3));
        junit.framework.Assert.assertEquals((int)55, (int)counter.count(is_136, 0, 3));
        counter.incrementSequence(is_137, 0, 3, 81);
        junit.framework.Assert.assertEquals((int)22, (int)counter.count(is_134, 0, 3));
        junit.framework.Assert.assertEquals((int)44, (int)counter.count(is_135, 0, 3));
        junit.framework.Assert.assertEquals((int)55, (int)counter.count(is_136, 0, 3));
        junit.framework.Assert.assertEquals((int)81, (int)counter.count(is_137, 0, 3));
        counter.incrementSequence(is_136, 0, 3, 1000);
        junit.framework.Assert.assertEquals((int)22, (int)counter.count(is_134, 0, 3));
        junit.framework.Assert.assertEquals((int)44, (int)counter.count(is_135, 0, 3));
        junit.framework.Assert.assertEquals((int)1055, (int)counter.count(is_136, 0, 3));
        junit.framework.Assert.assertEquals((int)81, (int)counter.count(is_137, 0, 3));
    }

    @Test
    public void testSize() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(4);
        junit.framework.Assert.assertEquals((int)1, (int)counter.trieSize());
        counter.incrementSubsequences(new int[]{1}, 0, 1);
        junit.framework.Assert.assertEquals((int)2, (int)counter.trieSize());
        counter.incrementSubsequences(new int[]{2}, 0, 1);
        junit.framework.Assert.assertEquals((int)3, (int)counter.trieSize());
        counter.incrementSubsequences(new int[]{3}, 0, 1);
        junit.framework.Assert.assertEquals((int)4, (int)counter.trieSize());
        counter.incrementSubsequences(new int[]{4}, 0, 1);
        junit.framework.Assert.assertEquals((int)5, (int)counter.trieSize());
        counter.incrementSubsequences(new int[]{1, 2}, 0, 2);
        junit.framework.Assert.assertEquals((int)6, (int)counter.trieSize());
        counter.incrementSubsequences(new int[]{1, 3}, 0, 2);
        junit.framework.Assert.assertEquals((int)7, (int)counter.trieSize());
        counter.incrementSubsequences(new int[]{1, 4}, 0, 2);
        junit.framework.Assert.assertEquals((int)8, (int)counter.trieSize());
        counter.incrementSubsequences(new int[]{2, 3}, 0, 2);
        junit.framework.Assert.assertEquals((int)9, (int)counter.trieSize());
        counter.incrementSubsequences(new int[]{1, 2, 3}, 0, 3);
        junit.framework.Assert.assertEquals((int)10, (int)counter.trieSize());
        counter.incrementSubsequences(new int[]{1, 2, 3, 4}, 0, 4);
        junit.framework.Assert.assertEquals((int)13, (int)counter.trieSize());
    }

    @Test
    public void testScaling1() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(4);
        counter.incrementSubsequences(new int[]{1, 2}, 0, 2);
        counter.incrementSubsequences(new int[]{1, 3}, 0, 2);
        counter.incrementSubsequences(new int[]{1, 3}, 0, 2);
        counter.rescale(0.5);
        junit.framework.Assert.assertEquals((int)3, (int)counter.count(new int[0], 0, 0));
        junit.framework.Assert.assertEquals((int)1, (int)counter.count(new int[]{1}, 0, 1));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 2}, 0, 2));
        junit.framework.Assert.assertEquals((int)1, (int)counter.count(new int[]{1, 3}, 0, 2));
    }

    @Test
    public void testScaling2() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(4);
        counter.incrementSubsequences(new int[]{1, 2}, 0, 2);
        counter.incrementSubsequences(new int[]{1, 3}, 0, 2);
        counter.incrementSubsequences(new int[]{1, 3}, 0, 2);
        counter.incrementSubsequences(new int[]{1, 4}, 0, 2);
        counter.rescale(0.5);
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[0], 0, 0));
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{1}, 0, 1));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 2}, 0, 2));
        junit.framework.Assert.assertEquals((int)1, (int)counter.count(new int[]{1, 3}, 0, 2));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 4}, 0, 2));
    }

    @Test
    public void testScaling3() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(4);
        counter.incrementSubsequences(new int[]{1, 2, 3, 4}, 0, 4);
        counter.incrementSubsequences(new int[]{1, 2, 3, 4}, 0, 4);
        counter.incrementSubsequences(new int[]{1, 2, 3, 4}, 0, 4);
        counter.incrementSubsequences(new int[]{1, 2, 3, 5}, 0, 4);
        counter.incrementSubsequences(new int[]{1, 2, 3, 6}, 0, 4);
        counter.incrementSubsequences(new int[]{1, 7, 8, 9}, 0, 4);
        counter.rescale(0.5);
        junit.framework.Assert.assertEquals((int)12, (int)counter.count(new int[0], 0, 0));
        junit.framework.Assert.assertEquals((int)3, (int)counter.count(new int[]{1}, 0, 1));
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{1, 2}, 0, 2));
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{1, 2}, 0, 2));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 7}, 0, 2));
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{1, 2, 3}, 0, 3));
        junit.framework.Assert.assertEquals((int)1, (int)counter.count(new int[]{1, 2, 3, 4}, 0, 4));
    }

    @Test
    public void testPruning1() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(4);
        counter.incrementSubsequences(new int[]{1, 2, 3, 4}, 0, 4);
        counter.incrementSubsequences(new int[]{1, 2, 3, 4}, 0, 4);
        counter.incrementSubsequences(new int[]{1, 2, 3}, 0, 3);
        counter.prune(3);
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 2, 3, 4}, 0, 4));
    }

    @Test
    public void testPruning2() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(4);
        counter.incrementSubsequences(new int[]{1, 2, 3, 4}, 0, 4);
        counter.incrementSubsequences(new int[]{1, 2, 3, 4}, 0, 4);
        counter.incrementSubsequences(new int[]{1, 2, 3}, 0, 3);
        counter.incrementSubsequences(new int[]{1, 2}, 0, 2);
        counter.incrementSubsequences(new int[]{1}, 0, 1);
        counter.incrementSubsequences(new int[]{2, 3}, 0, 2);
        counter.incrementSubsequences(new int[]{2, 4}, 0, 2);
        counter.incrementSubsequences(new int[]{2, 4}, 0, 2);
        counter.incrementSubsequences(new int[]{2, 5}, 0, 2);
        counter.incrementSubsequences(new int[]{2, 5}, 0, 2);
        counter.incrementSubsequences(new int[]{2, 5}, 0, 2);
        counter.incrementSubsequences(new int[]{2}, 0, 1);
        counter.incrementSubsequences(new int[]{3, 5}, 0, 2);
        counter.incrementSubsequences(new int[]{3, 6}, 0, 2);
        counter.incrementSubsequences(new int[]{3, 6}, 0, 2);
        counter.incrementSubsequences(new int[]{4, 5}, 0, 2);
        counter.incrementSubsequences(new int[]{4, 5}, 0, 2);
        counter.incrementSubsequences(new int[]{4, 5}, 0, 2);
        counter.incrementSubsequences(new int[]{7}, 0, 1);
        junit.framework.Assert.assertEquals((int)1, (int)counter.count(new int[]{7}, 0, 1));
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{1, 2, 3, 4}, 0, 4));
        junit.framework.Assert.assertEquals((int)3, (int)counter.count(new int[]{1, 2, 3}, 0, 3));
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[]{1, 2}, 0, 2));
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[]{2, 3}, 0, 2));
        junit.framework.Assert.assertEquals((int)11, (int)counter.count(new int[]{2}, 0, 1));
        counter.prune(1);
        junit.framework.Assert.assertEquals((int)1, (int)counter.count(new int[]{7}, 0, 1));
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{1, 2, 3, 4}, 0, 4));
        junit.framework.Assert.assertEquals((int)3, (int)counter.count(new int[]{1, 2, 3}, 0, 3));
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[]{1, 2}, 0, 2));
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[]{2, 3}, 0, 2));
        junit.framework.Assert.assertEquals((int)11, (int)counter.count(new int[]{2}, 0, 1));
        counter.prune(2);
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{7}, 0, 1));
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{1, 2, 3, 4}, 0, 4));
        junit.framework.Assert.assertEquals((int)3, (int)counter.count(new int[]{1, 2, 3}, 0, 3));
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[]{1, 2}, 0, 2));
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[]{2, 3}, 0, 2));
        junit.framework.Assert.assertEquals((int)11, (int)counter.count(new int[]{2}, 0, 1));
        counter.prune(3);
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{7}, 0, 1));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 2, 3, 4}, 0, 4));
        junit.framework.Assert.assertEquals((int)3, (int)counter.count(new int[]{1, 2, 3}, 0, 3));
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[]{1, 2}, 0, 2));
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[]{2, 3}, 0, 2));
        junit.framework.Assert.assertEquals((int)11, (int)counter.count(new int[]{2}, 0, 1));
        counter.prune(4);
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{7}, 0, 1));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 2, 3, 4}, 0, 4));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 2, 3}, 0, 3));
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[]{1, 2}, 0, 2));
        junit.framework.Assert.assertEquals((int)4, (int)counter.count(new int[]{2, 3}, 0, 2));
        junit.framework.Assert.assertEquals((int)11, (int)counter.count(new int[]{2}, 0, 1));
        counter.prune(5);
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{7}, 0, 1));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 2, 3, 4}, 0, 4));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 2, 3}, 0, 3));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1, 2}, 0, 2));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{2, 3}, 0, 2));
        junit.framework.Assert.assertEquals((int)11, (int)counter.count(new int[]{2}, 0, 1));
        counter.prune(100);
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{2}, 0, 1));
    }

    @Test
    public void testOutcomeHistograms() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(4);
        counter.incrementSubsequences(new int[]{1, 2, 3}, 0, 3);
        counter.incrementSubsequences(new int[]{1, 2, 4}, 0, 3);
        counter.incrementSubsequences(new int[]{1, 2, 4}, 0, 3);
        counter.incrementSubsequences(new int[]{1, 2, 5}, 0, 3);
        counter.incrementSubsequences(new int[]{1, 3, 6}, 0, 3);
        counter.incrementSubsequences(new int[]{7, 1, 2}, 0, 3);
        counter.incrementSubsequences(new int[]{7, 1, 3}, 0, 3);
        counter.incrementSubsequences(new int[]{1, 3}, 0, 2);
        counter.incrementSubsequences(new int[]{7, 1}, 0, 2);
        ObjectToCounterMap<int[]> trigramCounter = counter.nGramCounts(3, 2);
        List<int[]> keysOrderedByCount = trigramCounter.keysOrderedByCountList();
        junit.framework.Assert.assertEquals((int)1, (int)keysOrderedByCount.size());
        Assert.assertArrayEquals((int[])new int[]{1, 2, 4}, (int[])keysOrderedByCount.get(0));
        trigramCounter = counter.nGramCounts(2, 2);
        keysOrderedByCount = trigramCounter.keysOrderedByCountList();
        junit.framework.Assert.assertEquals((int)4, (int)keysOrderedByCount.size());
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])keysOrderedByCount.get(0));
        junit.framework.Assert.assertEquals((int)5, (int)trigramCounter.getCount(keysOrderedByCount.get(0)));
        Assert.assertArrayEquals((int[])new int[]{2, 4}, (int[])keysOrderedByCount.get(3));
        try {
            counter.nGramCounts(0, 4);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testExs() {
        try {
            new TrieIntSeqCounter(-1);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        TrieIntSeqCounter counter = new TrieIntSeqCounter(3);
        try {
            counter.incrementSubsequences(new int[4], -1, 2);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.incrementSubsequences(new int[4], 2, 1);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.incrementSubsequences(new int[4], 2, 5);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.incrementSubsequences(new int[4], 5, 7);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.count(new int[3], 5, 7);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.extensionCount(new int[3], 5, 7);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.numExtensions(new int[3], 5, 7);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testMaxLength() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(3);
        junit.framework.Assert.assertEquals((int)3, (int)counter.maxLength());
    }

    @Test
    public void testCount() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(3);
        counter.incrementSubsequences(new int[0], 0, 0);
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[0], 0, 0));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{1}, 0, 1));
        counter.incrementSubsequences(new int[]{1}, 0, 1);
        junit.framework.Assert.assertEquals((int)1, (int)counter.count(new int[]{1}, 0, 1));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{17}, 0, 1));
        counter.incrementSubsequences(new int[]{1}, 0, 1);
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{1}, 0, 1));
    }

    @Test
    public void testAbracadbra() {
        TrieIntSeqCounter counter = new TrieIntSeqCounter(3);
        counter.incrementSubsequences(this.ABRACADABRA, 0, this.ABRACADABRA.length);
        junit.framework.Assert.assertEquals((int)11, (int)counter.count(new int[0], 0, 0));
        junit.framework.Assert.assertEquals((int)5, (int)counter.count(new int[]{this.A}, 0, 1));
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{this.B}, 0, 1));
        junit.framework.Assert.assertEquals((int)1, (int)counter.count(new int[]{this.C}, 0, 1));
        junit.framework.Assert.assertEquals((int)5, (int)counter.count(new int[]{this.B, this.A}, 1, 2));
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{this.A, this.B}, 0, 2));
        junit.framework.Assert.assertEquals((int)2, (int)counter.count(new int[]{this.A, this.B, this.R}, 0, 3));
        junit.framework.Assert.assertEquals((int)1, (int)counter.count(new int[]{this.A, this.D, this.A}, 0, 3));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{this.A, this.D, this.A, this.A}, 0, 4));
        junit.framework.Assert.assertEquals((int)0, (int)counter.count(new int[]{this.A, this.B, this.R, this.A}, 0, 4));
        junit.framework.Assert.assertEquals((long)11L, (long)counter.extensionCount(new int[0], 0, 0));
        junit.framework.Assert.assertEquals((long)4L, (long)counter.extensionCount(new int[]{this.A}, 0, 1));
        junit.framework.Assert.assertEquals((long)4L, (long)counter.extensionCount(new int[]{this.B, this.A}, 1, 2));
        junit.framework.Assert.assertEquals((long)4L, (long)counter.extensionCount(new int[]{this.A, this.B}, 0, 1));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.extensionCount(new int[]{this.A, this.B, this.R}, 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.extensionCount(new int[]{this.D, this.A}, 0, 2));
        junit.framework.Assert.assertEquals((int)5, (int)counter.numExtensions(new int[0], 0, 0));
        junit.framework.Assert.assertEquals((int)3, (int)counter.numExtensions(new int[]{this.A}, 0, 1));
        junit.framework.Assert.assertEquals((int)3, (int)counter.numExtensions(new int[]{this.B, this.A}, 1, 2));
        junit.framework.Assert.assertEquals((int)3, (int)counter.numExtensions(new int[]{this.A, this.B}, 0, 1));
        junit.framework.Assert.assertEquals((int)0, (int)counter.numExtensions(new int[]{this.A, this.B, this.R}, 0, 3));
        junit.framework.Assert.assertEquals((int)1, (int)counter.numExtensions(new int[]{this.D, this.A}, 0, 2));
        counter.incrementSubsequences(new int[]{this.A, this.D, this.B}, 0, 3);
        junit.framework.Assert.assertEquals((long)2L, (long)counter.extensionCount(new int[]{this.A, this.D, this.B}, 0, 2));
        junit.framework.Assert.assertEquals((int)2, (int)counter.numExtensions(new int[]{this.A, this.D, this.B}, 0, 2));
        counter.incrementSubsequences(new int[]{this.A, this.D, this.B}, 0, 3);
        junit.framework.Assert.assertEquals((long)3L, (long)counter.extensionCount(new int[]{this.A, this.D, this.B}, 0, 2));
        counter.incrementSubsequences(new int[]{this.A, this.D, this.A}, 0, 3);
        junit.framework.Assert.assertEquals((long)4L, (long)counter.extensionCount(new int[]{this.A, this.D}, 0, 2));
        junit.framework.Assert.assertEquals((int)2, (int)counter.numExtensions(new int[]{this.A, this.D}, 0, 2));
        Assert.assertArrayEquals((int[])new int[]{this.A, this.B, this.C, this.D, this.R}, (int[])counter.observedIntegers());
        Assert.assertArrayEquals((int[])new int[]{this.R}, (int[])counter.integersFollowing(new int[]{this.B}, 0, 1));
        Assert.assertArrayEquals((int[])new int[]{this.A, this.B, this.C, this.D, this.R}, (int[])counter.integersFollowing(new int[0], 0, 0));
        Assert.assertArrayEquals((int[])new int[]{this.B, this.C, this.D}, (int[])counter.integersFollowing(new int[]{this.A}, 0, 1));
    }

    @Test
    public void testMultipleIncrements() {
        Random random = new Random();
        TrieIntSeqCounter counter1 = new TrieIntSeqCounter(3);
        TrieIntSeqCounter counter2 = new TrieIntSeqCounter(3);
        int[] xs = new int[5];
        int i = 0;
        while (i < 100) {
            int k = 0;
            while (k < xs.length) {
                xs[k] = random.nextInt(16);
                ++k;
            }
            int trainingCount = random.nextInt(10);
            this.incrementAssertSynched(counter1, counter2, xs, trainingCount);
            ++i;
        }
    }

    void incrementAssertSynched(TrieIntSeqCounter counter1, TrieIntSeqCounter counter2, int[] seq, int count) {
        int i = 0;
        while (i < count) {
            counter1.incrementSubsequences(seq, 0, seq.length);
            ++i;
        }
        counter2.incrementSubsequences(seq, 0, seq.length, count);
        this.assertSynched(counter1, counter2);
        this.assertSynched(counter2, counter1);
    }

    void assertSynched(TrieIntSeqCounter counter1, TrieIntSeqCounter counter2) {
        int[] seq = new int[counter1.maxLength()];
        int n = 0;
        while (n < counter1.maxLength()) {
            int[] followers = counter1.integersFollowing(seq, 0, n);
            int k = 0;
            while (k < followers.length) {
                seq[n] = followers[k];
                this.assertCount(counter1, counter2, seq, n + 1);
                ++k;
            }
            ++n;
        }
    }

    void assertCount(TrieIntSeqCounter counter1, TrieIntSeqCounter counter2, int[] seq, int length) {
        junit.framework.Assert.assertEquals((int)counter1.count(seq, 0, length), (int)counter2.count(seq, 0, length));
        junit.framework.Assert.assertEquals((long)counter1.extensionCount(seq, 0, length), (long)counter2.extensionCount(seq, 0, length));
    }
}

