/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.lm;

import com.aliasi.io.BitInput;
import com.aliasi.io.BitOutput;
import com.aliasi.lm.BitTrieReader;
import com.aliasi.lm.BitTrieWriter;
import com.aliasi.lm.TrieCharSeqCounter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class TrieCharSeqCounterTest {
    @Test
    public void testDecrementSubstrings() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(5);
        char[] cs = "abcdef".toCharArray();
        counter.incrementSubstrings(cs, 0, cs.length);
        counter.decrementSubstrings(cs, 0, 3);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("abc".toCharArray(), 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abcd".toCharArray(), 0, 4));
    }

    @Test
    public void testDecrementSubstrings2() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(5);
        char[] cs = "abcdef".toCharArray();
        counter.incrementSubstrings(cs, 0, cs.length);
        counter.incrementSubstrings(cs, 0, cs.length);
        counter.decrementSubstrings(cs, 0, 3);
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abc".toCharArray(), 0, 3));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("abcd".toCharArray(), 0, 4));
    }

    @Test
    public void testDecrementSubstrings3() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(5);
        char[] cs = "abcdef".toCharArray();
        counter.incrementSubstrings(cs, 0, cs.length);
        char[] cs2 = "abxyz".toCharArray();
        counter.incrementSubstrings(cs2, 0, cs2.length);
        counter.decrementSubstrings(cs, 0, 3);
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("ab".toCharArray(), 0, 2));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("abc".toCharArray(), 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abx".toCharArray(), 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abcd".toCharArray(), 0, 4));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abxy".toCharArray(), 0, 4));
    }

    @Test
    public void testDecrementSubstrings4() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(5);
        char[] cs = "abcdef".toCharArray();
        counter.incrementSubstrings(cs, 0, cs.length);
        char[] cs2 = "abxyz".toCharArray();
        counter.incrementSubstrings(cs2, 0, cs2.length);
        char[] cs3 = "abmnl".toCharArray();
        counter.incrementSubstrings(cs3, 0, cs3.length);
        counter.decrementSubstrings(cs, 0, 3);
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ab".toCharArray(), 0, 2));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("abc".toCharArray(), 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abx".toCharArray(), 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abm".toCharArray(), 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abcd".toCharArray(), 0, 4));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abxy".toCharArray(), 0, 4));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("bmnl".toCharArray(), 0, 4));
    }

    @Test
    public void testDecrementSubstrings5() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(5);
        char[] cs = "abcdef".toCharArray();
        counter.incrementSubstrings(cs, 0, cs.length);
        char[] cs2 = "abxyz".toCharArray();
        counter.incrementSubstrings(cs2, 0, cs2.length);
        char[] cs3 = "abmnl".toCharArray();
        counter.incrementSubstrings(cs3, 0, cs3.length);
        char[] cs4 = "ab123".toCharArray();
        counter.incrementSubstrings(cs4, 0, cs4.length);
        counter.decrementSubstrings(cs, 0, 3);
        junit.framework.Assert.assertEquals((long)3L, (long)counter.count("ab".toCharArray(), 0, 2));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("abc".toCharArray(), 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abx".toCharArray(), 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abm".toCharArray(), 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abcd".toCharArray(), 0, 4));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("abxy".toCharArray(), 0, 4));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("bmnl".toCharArray(), 0, 4));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("123".toCharArray(), 0, 3));
    }

    @Test
    public void testUniqueTotals() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(3);
        char[] cs = "abcde".toCharArray();
        counter.incrementSubstrings(cs, 0, cs.length);
        long[][] uniqueTotals = counter.uniqueTotalNGramCount();
        junit.framework.Assert.assertEquals((long)1L, (long)counter.uniqueSequenceCount(0));
        junit.framework.Assert.assertEquals((long)5L, (long)counter.totalSequenceCount(0));
        junit.framework.Assert.assertEquals((long)1L, (long)uniqueTotals[0][0]);
        junit.framework.Assert.assertEquals((long)5L, (long)uniqueTotals[0][1]);
        junit.framework.Assert.assertEquals((long)5L, (long)counter.uniqueSequenceCount(1));
        junit.framework.Assert.assertEquals((long)5L, (long)counter.totalSequenceCount(1));
        junit.framework.Assert.assertEquals((long)5L, (long)uniqueTotals[1][0]);
        junit.framework.Assert.assertEquals((long)5L, (long)uniqueTotals[1][1]);
        junit.framework.Assert.assertEquals((long)4L, (long)counter.uniqueSequenceCount(2));
        junit.framework.Assert.assertEquals((long)4L, (long)counter.totalSequenceCount(2));
        junit.framework.Assert.assertEquals((long)4L, (long)uniqueTotals[2][0]);
        junit.framework.Assert.assertEquals((long)4L, (long)uniqueTotals[2][1]);
        junit.framework.Assert.assertEquals((long)3L, (long)counter.uniqueSequenceCount(3));
        junit.framework.Assert.assertEquals((long)3L, (long)counter.totalSequenceCount(3));
        junit.framework.Assert.assertEquals((long)3L, (long)uniqueTotals[3][0]);
        junit.framework.Assert.assertEquals((long)3L, (long)uniqueTotals[3][1]);
    }

    @Test
    public void testExs() {
        try {
            new TrieCharSeqCounter(-1);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        TrieCharSeqCounter counter = new TrieCharSeqCounter(5);
        try {
            counter.count(new char[4], -1, 3);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.count(new char[4], 3, 2);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.count(new char[4], 2, 5);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.extensionCount(new char[4], 2, 5);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.charactersFollowing(new char[4], 2, 5);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
        try {
            counter.numCharactersFollowing(new char[4], 2, 5);
            junit.framework.Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            junit.framework.Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testAbracadabra() {
        String abracadabra = "abracadabra";
        TrieCharSeqCounter counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings(abracadabra);
        junit.framework.Assert.assertEquals((long)5L, (long)counter.uniqueSequenceCount(1));
        junit.framework.Assert.assertEquals((long)7L, (long)counter.uniqueSequenceCount(2));
        junit.framework.Assert.assertEquals((long)7L, (long)counter.uniqueSequenceCount(3));
        junit.framework.Assert.assertEquals((long)7L, (long)counter.uniqueSequenceCount(4));
        junit.framework.Assert.assertEquals((long)11L, (long)counter.totalSequenceCount(1));
        junit.framework.Assert.assertEquals((long)10L, (long)counter.totalSequenceCount(2));
        junit.framework.Assert.assertEquals((long)9L, (long)counter.totalSequenceCount(3));
        junit.framework.Assert.assertEquals((long)8L, (long)counter.totalSequenceCount(4));
        Assert.assertArrayEquals((int[])new int[]{5, 2, 2, 1, 1}, (int[])counter.nGramFrequencies(1));
    }

    @Test
    public void testPruneCount() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(4);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("a"));
        counter.incrementSubstrings("a");
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count(""));
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count(""));
        counter.incrementSubstrings("a");
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count(""));
        counter.incrementSubstrings("ab");
        junit.framework.Assert.assertEquals((long)3L, (long)counter.extensionCount(""));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("ab"));
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ac");
        junit.framework.Assert.assertEquals((long)4L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ac"));
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)4L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ac"));
    }

    @Test
    public void testPruneCount2() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("abc");
        counter.incrementSubstrings("ab");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("abc"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("a"));
        counter.prune(3);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
    }

    @Test
    public void testPruneCount3() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("abc");
        counter.incrementSubstrings("ab");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("abc"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("a"));
    }

    @Test
    public void testPruneCount4() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ab"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ac");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ac"));
    }

    @Test
    public void testPruneCount5() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ad"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ad");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ac"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ad");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ac"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ad");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ad"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ad"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ad"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ad"));
    }

    @Test
    public void testPruneCount6() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ae");
        counter.incrementSubstrings("ae");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ad"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ae"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ae");
        counter.incrementSubstrings("ae");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ad"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ae"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ae");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ad"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ae"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ae");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ad"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ae"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("ac");
        counter.incrementSubstrings("ad");
        counter.incrementSubstrings("ae");
        counter.incrementSubstrings("ae");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ac"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ad"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ae"));
    }

    @Test
    public void testPruneCount7() {
        TrieCharSeqCounter counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("ab");
        counter.incrementSubstrings("cd");
        counter.incrementSubstrings("cd");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("ab"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("cd"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("c"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("abc");
        counter.incrementSubstrings("def");
        counter.incrementSubstrings("def");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("abc"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("def"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("de"));
        counter = new TrieCharSeqCounter(4);
        counter.incrementSubstrings("abcd");
        counter.incrementSubstrings("efgh");
        counter.incrementSubstrings("efgh");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("abcd"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("efgh"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("efg"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ef"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("e"));
        counter = new TrieCharSeqCounter(6);
        counter.incrementSubstrings("abcde");
        counter.incrementSubstrings("fghij");
        counter.incrementSubstrings("fghij");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("abcde"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("fghij"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("fghi"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("fgh"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("fg"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("f"));
        counter = new TrieCharSeqCounter(7);
        counter.incrementSubstrings("abcdef");
        counter.incrementSubstrings("ghijkl");
        counter.incrementSubstrings("ghijkl");
        counter.prune(2);
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("abcdef"));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count("a"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ghijkl"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ghijk"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ghij"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("ghi"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("gh"));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("g"));
    }

    @Test
    public void testReadWrite() throws IOException {
        TrieCharSeqCounter c1 = new TrieCharSeqCounter(3);
        c1.incrementSubstrings("abcd");
        this.assertEqualCounts(c1, new String[]{"a", "b", "c", "x", "ab", "bc", "xy", "ax", "xa", "abc", "bxa"}, 3);
        c1.incrementSubstrings("aef");
        c1.incrementSubstrings("bef");
        c1.incrementSubstrings("cde");
        this.assertEqualCounts(c1, new String[]{"a", "b", "c", "x", "ab", "bc", "xy", "ax", "xa", "abc", "bxa"}, 3);
        c1.incrementSubstrings("abracadabra");
        this.assertEqualCounts(c1, new String[]{"abr", "br", "cad", "db"}, 3);
    }

    public void assertEqualCounts(TrieCharSeqCounter c, String[] ss, int maxNGram) throws IOException {
        this.assertCopy(c);
        TrieCharSeqCounter cId = this.writeRead(c);
        junit.framework.Assert.assertEquals((long)c.uniqueSequenceCount(), (long)cId.uniqueSequenceCount());
        junit.framework.Assert.assertEquals((long)c.totalSequenceCount(), (long)cId.totalSequenceCount());
        TrieCharSeqCounter c2 = this.writeRead(c);
        int i = 0;
        while (i < ss.length) {
            String s = ss[i];
            if (s.length() <= maxNGram) {
                junit.framework.Assert.assertEquals((String)s, (long)c.count(s), (long)c2.count(s));
                if (s.length() < maxNGram) {
                    junit.framework.Assert.assertEquals((String)("ngram=" + maxNGram + " extensionCount(" + s + ")"), (long)c.extensionCount(s), (long)c2.extensionCount(s));
                }
            } else {
                junit.framework.Assert.assertEquals((long)0L, (long)c2.count(s));
                junit.framework.Assert.assertEquals((long)0L, (long)c2.extensionCount(s));
            }
            ++i;
        }
    }

    public TrieCharSeqCounter writeRead(TrieCharSeqCounter counter) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        counter.writeTo(bytesOut);
        byte[] bytes = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        TrieCharSeqCounter counter2 = TrieCharSeqCounter.readFrom(bytesIn);
        return counter2;
    }

    public void assertCopy(TrieCharSeqCounter counter) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        BitOutput bitsOut = new BitOutput(bytesOut);
        BitTrieWriter writer = new BitTrieWriter(bitsOut);
        TrieCharSeqCounter.writeCounter(counter, writer, 128);
        bitsOut.flush();
        byte[] bytes = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        BitInput bitsIn = new BitInput(bytesIn);
        BitTrieReader reader = new BitTrieReader(bitsIn);
        ByteArrayOutputStream bytesOut2 = new ByteArrayOutputStream();
        BitOutput bitsOut2 = new BitOutput(bytesOut2);
        BitTrieWriter writer2 = new BitTrieWriter(bitsOut2);
        BitTrieWriter.copy(reader, writer2);
        bitsOut2.flush();
        byte[] bytes2 = bytesOut2.toByteArray();
        ByteArrayInputStream bytesIn3 = new ByteArrayInputStream(bytes);
        BitInput bitsIn3 = new BitInput(bytesIn3);
        BitTrieReader reader3 = new BitTrieReader(bitsIn3);
        ByteArrayOutputStream bytesOut3 = new ByteArrayOutputStream();
        BitOutput bitsOut3 = new BitOutput(bytesOut3);
        BitTrieWriter writer3 = new BitTrieWriter(bitsOut3);
        BitTrieWriter.copy(reader3, writer3);
        bitsOut3.flush();
        byte[] bytes3 = bytesOut3.toByteArray();
        this.assertEqualsBytes(bytes, bytes3);
        this.assertEqualsBytes(bytes, bytes2);
    }

    void assertEqualsBytes(byte[] bytes, byte[] bytes2) {
        junit.framework.Assert.assertEquals((String)"length", (int)bytes.length, (int)bytes2.length);
        int i = 0;
        while (i < bytes2.length) {
            junit.framework.Assert.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            ++i;
        }
    }
}

