/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.lm;

import com.aliasi.io.BitInput;
import com.aliasi.io.BitOutput;
import com.aliasi.lm.BitTrieReader;
import com.aliasi.lm.BitTrieWriter;
import com.aliasi.lm.PruneTrieReader;
import com.aliasi.lm.TrieCharSeqCounter;
import com.aliasi.test.unit.Asserts;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class PruneTrieReaderTest {
    @Test
    public void testOne() throws IOException {
        int nGram = 3;
        TrieCharSeqCounter c = new TrieCharSeqCounter(nGram);
        c.incrementSubstrings("abc");
        c.incrementSubstrings("bcd");
        c.incrementSubstrings("cde");
        c.incrementSubstrings("cde");
        c.incrementSubstrings("e");
        c.incrementSubstrings("e");
        c.incrementSubstrings("e");
        c.incrementSubstrings("e");
        c.incrementSubstrings("e");
        c.incrementSubstrings("e");
        String[] tests = new String[]{"abc", "bcd", "cd", "ab", "bc", "e", "de", "a", "b", "c"};
        this.assertPruning(c, 1, nGram, tests);
        this.assertPruning(c, 3, nGram, tests);
        this.assertPruning(c, 5, nGram, tests);
        try {
            this.assertPruning(c, -1, nGram, tests);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }

    void assertPruning(TrieCharSeqCounter counter, int min, int maxNGram, String[] tests) throws IOException {
        TrieCharSeqCounter pruned = PruneTrieReaderTest.prune(counter, min, maxNGram);
        int i = 0;
        while (i < tests.length) {
            this.assertPruned(counter, pruned, min, tests[i]);
            ++i;
        }
    }

    void assertPruned(TrieCharSeqCounter counter, TrieCharSeqCounter pruned, int min, String s) {
        long expected;
        long count = counter.count(s);
        long l = expected = count >= (long)min ? count : 0L;
        if (expected < (long)min) {
            expected = 0L;
        }
        long found = pruned.count(s);
        Assert.assertEquals((String)(String.valueOf(s) + " min=" + min + " count=" + count + " expected=" + expected + " found=" + found), (long)expected, (long)found);
    }

    static TrieCharSeqCounter prune(TrieCharSeqCounter counter, int min, int maxNGram) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        BitOutput bitsOut = new BitOutput(bytesOut);
        BitTrieWriter writer = new BitTrieWriter(bitsOut);
        TrieCharSeqCounter.writeCounter(counter, writer, 128);
        bitsOut.flush();
        byte[] bytes = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        BitInput bitsIn = new BitInput(bytesIn);
        BitTrieReader reader = new BitTrieReader(bitsIn);
        PruneTrieReader prunedReader = new PruneTrieReader(reader, min);
        return TrieCharSeqCounter.readCounter(prunedReader, maxNGram);
    }
}

