/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.features;

import com.aliasi.features.LengthNormFeatureExtractor;
import com.aliasi.test.unit.features.MockFeatureExtractor;
import com.aliasi.test.unit.features.SerializableMockFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.NotSerializableException;
import org.junit.Test;

public class LengthNormFeatureExtractorTest {
    @Test
    public void testCache() {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        mfe.put(1, new String[]{"A", "B"}, new double[]{3.0, 4.0});
        mfe.put(2, new String[]{"C"}, new double[]{-50.0});
        mfe.put(3, new String[0], new double[0]);
        LengthNormFeatureExtractor<Integer> lnfe = new LengthNormFeatureExtractor<Integer>(mfe);
        MockFeatureExtractor.assertFeats(lnfe, 1, new String[]{"A", "B"}, new double[]{0.6, 0.8});
        MockFeatureExtractor.assertFeats(lnfe, 2, new String[]{"C"}, new double[]{-1.0});
        MockFeatureExtractor.assertFeats(lnfe, 3, new String[0], new double[0]);
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        SerializableMockFeatureExtractor mfe = new SerializableMockFeatureExtractor();
        mfe.put(1, new String[]{"A", "B"}, new double[]{3.0, 4.0});
        mfe.put(2, new String[]{"C"}, new double[]{-50.0});
        mfe.put(3, new String[0], new double[0]);
        LengthNormFeatureExtractor<Integer> lnfe = new LengthNormFeatureExtractor<Integer>(mfe);
        FeatureExtractor lnfe2 = (FeatureExtractor)AbstractExternalizable.serializeDeserialize(lnfe);
        MockFeatureExtractor.assertFeats(lnfe2, 1, new String[]{"A", "B"}, new double[]{0.6, 0.8});
        MockFeatureExtractor.assertFeats(lnfe2, 2, new String[]{"C"}, new double[]{-1.0});
        MockFeatureExtractor.assertFeats(lnfe2, 3, new String[0], new double[0]);
    }

    @Test(expected=NotSerializableException.class)
    public void testUnSerialize() throws IOException, ClassNotFoundException {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        LengthNormFeatureExtractor<Integer> lnfe = new LengthNormFeatureExtractor<Integer>(mfe);
        AbstractExternalizable.serializeDeserialize(lnfe);
    }
}

