/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.crf;

import com.aliasi.chunk.BioTagChunkCodec;
import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.chunk.TagChunkCodec;
import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.crf.ChainCrf;
import com.aliasi.crf.ChainCrfChunker;
import com.aliasi.io.LogLevel;
import com.aliasi.io.Reporter;
import com.aliasi.io.Reporters;
import com.aliasi.stats.AnnealingSchedule;
import com.aliasi.stats.RegressionPrior;
import com.aliasi.test.unit.crf.ChainCrfTest;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class ChainCrfChunkerTest {
    static final TagChunkCodec TAG_CHUNK_CODEC = new BioTagChunkCodec(IndoEuropeanTokenizerFactory.INSTANCE, true);

    @Test
    public void test1() throws IOException {
        boolean addIntercept = false;
        int minFeatureCount = 1;
        boolean cacheFeatureVectors = false;
        double minImprovement = 1.0E-8;
        int minEpochs = 10;
        int maxEpochs = 10000;
        int priorBlockSize = 3;
        Reporter reporter = Reporters.stdOut();
        reporter.setLevel(LogLevel.WARN);
        ChainCrfChunker chunker = ChainCrfChunker.estimate(TrainCorpus1.INSTANCE, TAG_CHUNK_CODEC, IndoEuropeanTokenizerFactory.INSTANCE, ChainCrfTest.FEATURE_EXTRACTOR, addIntercept, minFeatureCount, cacheFeatureVectors, RegressionPrior.noninformative(), priorBlockSize, AnnealingSchedule.exponential(0.005, 0.9999), minImprovement, minEpochs, maxEpochs, reporter);
        Assert.assertNotNull((Object)chunker);
        ChainCrf<String> crf = chunker.crf();
        String test = "John likes New York City.";
        Chunking chunking = chunker.chunk(test);
        Assert.assertEquals((Object)ChainCrfChunkerTest.chunking("John likes New York City.", ChainCrfChunkerTest.chunk(0, 4, "PER"), ChainCrfChunkerTest.chunk(11, 24, "LOC")), (Object)chunking);
    }

    static Chunking chunking(String s, Chunk ... chunks) {
        ChunkingImpl chunking = new ChunkingImpl(s);
        Chunk[] chunkArray = chunks;
        int n = chunks.length;
        int n2 = 0;
        while (n2 < n) {
            Chunk chunk = chunkArray[n2];
            chunking.add(chunk);
            ++n2;
        }
        return chunking;
    }

    static Chunk chunk(int start, int end, String type) {
        return ChunkFactory.createChunk(start, end, type);
    }

    static class TrainCorpus1
    extends Corpus<ObjectHandler<Chunking>> {
        static final Corpus<ObjectHandler<Chunking>> INSTANCE = new TrainCorpus1();
        static final Chunking[] TRAIN_CHUNKINGS = new Chunking[]{ChainCrfChunkerTest.chunking("", new Chunk[0]), ChainCrfChunkerTest.chunking("The", new Chunk[0]), ChainCrfChunkerTest.chunking("John ran.", ChainCrfChunkerTest.chunk(0, 4, "PER")), ChainCrfChunkerTest.chunking("Mary ran.", ChainCrfChunkerTest.chunk(0, 4, "PER")), ChainCrfChunkerTest.chunking("The kid ran.", new Chunk[0]), ChainCrfChunkerTest.chunking("John likes Mary.", ChainCrfChunkerTest.chunk(0, 4, "PER"), ChainCrfChunkerTest.chunk(11, 15, "PER")), ChainCrfChunkerTest.chunking("Tim lives in Washington", ChainCrfChunkerTest.chunk(0, 3, "PER"), ChainCrfChunkerTest.chunk(13, 23, "LOC")), ChainCrfChunkerTest.chunking("Mary Smith is in New York City", ChainCrfChunkerTest.chunk(0, 10, "PER"), ChainCrfChunkerTest.chunk(17, 30, "LOC")), ChainCrfChunkerTest.chunking("New York City is fun", ChainCrfChunkerTest.chunk(0, 13, "LOC")), ChainCrfChunkerTest.chunking("Chicago is not like Washington", ChainCrfChunkerTest.chunk(0, 7, "LOC"), ChainCrfChunkerTest.chunk(20, 30, "LOC"))};

        TrainCorpus1() {
        }

        @Override
        public void visitTrain(ObjectHandler<Chunking> handler) {
            Chunking[] chunkingArray = TRAIN_CHUNKINGS;
            int n = TRAIN_CHUNKINGS.length;
            int n2 = 0;
            while (n2 < n) {
                Chunking chunking = chunkingArray[n2];
                handler.handle(chunking);
                ++n2;
            }
        }

        @Override
        public void visitTest(ObjectHandler<Chunking> handler) {
        }
    }
}

