/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.BinaryLMClassifier;
import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.PerceptronClassifier;
import com.aliasi.classify.ScoredClassification;
import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.matrix.PolynomialKernel;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.TokenFeatureExtractor;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToDoubleMap;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class PerceptronClassifierTest {
    static final String ACC = BinaryLMClassifier.DEFAULT_ACCEPT_CATEGORY;
    static final String REJ = BinaryLMClassifier.DEFAULT_REJECT_CATEGORY;
    static final String[] INSTANCES1 = new String[]{"a a b", "a b b", "b b b"};
    static final String[] CATS1 = new String[]{ACC, REJ, REJ};
    static double[] SCORES1 = new double[]{91.0, 30.0, 149.0};
    static final String[] INSTANCES2 = new String[]{"a a b", "b b b", "a a a", "a b a", "b b a", "b a a", "b b a"};
    static final String[] CATS2 = new String[]{ACC, REJ, ACC, ACC, REJ, ACC, REJ};

    @Test
    public void testOne() throws ClassNotFoundException, IOException {
        PerceptronClassifier<CharSequence> pc = PerceptronClassifierTest.create(INSTANCES1, CATS1, 2, 2);
        PerceptronClassifier pc2 = (PerceptronClassifier)AbstractExternalizable.serializeDeserialize(pc);
        int i = 0;
        while (i < INSTANCES1.length) {
            Classification c1 = pc.classify((Object)INSTANCES1[i]);
            Classification c2 = pc2.classify(INSTANCES1[i]);
            Assert.assertEquals((String)CATS1[i], (String)c1.bestCategory());
            Assert.assertEquals((String)CATS1[i], (String)c2.bestCategory());
            Assert.assertEquals((double)SCORES1[i], (double)((ScoredClassification)c1).score(0), (double)1.0E-4);
            Assert.assertEquals((double)(-SCORES1[i]), (double)((ScoredClassification)c1).score(1), (double)1.0E-4);
            Assert.assertEquals((double)SCORES1[i], (double)((ScoredClassification)c2).score(0), (double)1.0E-4);
            Assert.assertEquals((double)(-SCORES1[i]), (double)((ScoredClassification)c2).score(1), (double)1.0E-4);
            ++i;
        }
    }

    static PerceptronClassifier<CharSequence> create(String[] instances, String[] cats, int degree, int numIterations) throws IOException {
        return new PerceptronClassifier<CharSequence>(new TestCorpus(instances, cats), new TokenFeatureExtractor(IndoEuropeanTokenizerFactory.INSTANCE), new PolynomialKernel(degree), ACC, numIterations, ACC, REJ);
    }

    static class TestCorpus
    extends Corpus<ObjectHandler<Classified<CharSequence>>> {
        final String[] mInstances;
        final String[] mCats;

        TestCorpus(String[] instances, String[] cats) {
            if (instances.length != cats.length) {
                throw new IllegalStateException("length diff");
            }
            this.mInstances = instances;
            this.mCats = cats;
        }

        @Override
        public void visitTrain(ObjectHandler<Classified<CharSequence>> handler) {
            int i = 0;
            while (i < this.mInstances.length) {
                Classification c = new Classification(this.mCats[i]);
                Classified<String> classified = new Classified<String>(this.mInstances[i], c);
                handler.handle(classified);
                ++i;
            }
        }
    }

    static class TestFeatureExtractor
    implements FeatureExtractor<CharSequence>,
    Serializable {
        TestFeatureExtractor() {
        }

        @Override
        public Map<String, Double> features(CharSequence in) {
            ObjectToDoubleMap<String> map = new ObjectToDoubleMap<String>();
            char[] cs = Strings.toCharArray(in);
            Tokenizer tokenizer = IndoEuropeanTokenizerFactory.INSTANCE.tokenizer(cs, 0, cs.length);
            for (String token : tokenizer) {
                map.increment(token, 1.0);
            }
            return map;
        }
    }
}

