/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.MultivariateDistribution;
import com.aliasi.util.Math;

public class MultinomialDistribution {
    private final MultivariateDistribution mBasisDistribution;

    public MultinomialDistribution(MultivariateDistribution distribution) {
        this.mBasisDistribution = distribution;
    }

    public double log2Probability(int[] sampleCounts) {
        this.checkNumSamples(sampleCounts);
        double sum = MultinomialDistribution.log2MultinomialCoefficient(sampleCounts);
        int i = 0;
        while (i < sampleCounts.length) {
            sum += (double)sampleCounts[i] * this.mBasisDistribution.log2Probability(i);
            ++i;
        }
        return sum;
    }

    public double chiSquared(int[] sampleCounts) {
        this.checkNumSamples(sampleCounts);
        int totalCount = Math.sum(sampleCounts);
        double sum = 0.0;
        int i = 0;
        while (i < sampleCounts.length) {
            sum += MultinomialDistribution.normSquareDiff(sampleCounts[i], this.mBasisDistribution.probability(i), totalCount);
            ++i;
        }
        return sum;
    }

    public int numDimensions() {
        return this.mBasisDistribution.numDimensions();
    }

    public MultivariateDistribution basisDistribution() {
        return this.mBasisDistribution;
    }

    void checkNumSamples(int[] samples) {
        if (samples.length != this.numDimensions()) {
            String msg = "Require same number of samples as dimensions. Number of dimensions=" + this.numDimensions() + "  Found #samples=" + samples.length;
            throw new IllegalArgumentException(msg);
        }
    }

    public static double log2MultinomialCoefficient(int[] sampleCounts) {
        MultinomialDistribution.checkNonNegative(sampleCounts);
        long totalCount = Math.sum(sampleCounts);
        double coeff = Math.log2Factorial(totalCount);
        int i = 0;
        while (i < sampleCounts.length) {
            coeff -= Math.log2Factorial(sampleCounts[i]);
            ++i;
        }
        return coeff;
    }

    static double normSquareDiff(double count, double probability, double totalCount) {
        double expectedCount = totalCount * probability;
        double diff = count - expectedCount;
        return diff * diff / expectedCount;
    }

    static void checkNonNegative(int[] sampleCounts) {
        int i = 0;
        while (i < sampleCounts.length) {
            if (sampleCounts[i] < 0) {
                String msg = "Sample Counts must be non-negative. Found sampleCounts[" + i + "]=" + sampleCounts[i];
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
    }
}

