/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.util.Distance;
import com.aliasi.util.Proximity;
import java.util.Arrays;

public class JaroWinklerDistance
implements Distance<CharSequence>,
Proximity<CharSequence> {
    private final double mWeightThreshold;
    private final int mNumChars;
    public static final JaroWinklerDistance JARO_DISTANCE = new JaroWinklerDistance();
    public static final JaroWinklerDistance JARO_WINKLER_DISTANCE = new JaroWinklerDistance(0.7, 4);

    public JaroWinklerDistance() {
        this(Double.POSITIVE_INFINITY, 0);
    }

    public JaroWinklerDistance(double weightThreshold, int numChars) {
        this.mNumChars = numChars;
        this.mWeightThreshold = weightThreshold;
    }

    @Override
    public double distance(CharSequence cSeq1, CharSequence cSeq2) {
        return 1.0 - this.proximity(cSeq1, cSeq2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double proximity(CharSequence cSeq1, CharSequence cSeq2) {
        len1 = cSeq1.length();
        len2 = cSeq2.length();
        if (len1 == 0) {
            return len2 == 0 ? 1.0 : 0.0;
        }
        searchRange = Math.max(0, Math.max(len1, len2) / 2 - 1);
        matched1 = new boolean[len1];
        Arrays.fill(matched1, false);
        matched2 = new boolean[len2];
        Arrays.fill(matched2, false);
        numCommon = 0;
        i = 0;
        while (i < len1) {
            start = Math.max(0, i - searchRange);
            end = Math.min(i + searchRange + 1, len2);
            j = start;
            while (j < end) {
                if (!matched2[j] && cSeq1.charAt(i) == cSeq2.charAt(j)) {
                    matched1[i] = true;
                    matched2[j] = true;
                    ++numCommon;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (numCommon == 0) {
            return 0.0;
        }
        numHalfTransposed = 0;
        j = 0;
        i = 0;
        while (i < len1) {
            block11: {
                if (matched1[i]) ** GOTO lbl35
                break block11;
lbl-1000:
                // 1 sources

                {
                    ++j;
lbl35:
                    // 2 sources

                    ** while (!matched2[j])
                }
lbl36:
                // 1 sources

                if (cSeq1.charAt(i) != cSeq2.charAt(j)) {
                    ++numHalfTransposed;
                }
                ++j;
            }
            ++i;
        }
        numCommonD = numCommon;
        numTransposed = numHalfTransposed / 2;
        weight = (numCommonD / (double)len1 + numCommonD / (double)len2 + (double)(numCommon - numTransposed) / numCommonD) / 3.0;
        if (weight <= this.mWeightThreshold) {
            return weight;
        }
        max = Math.min(this.mNumChars, Math.min(cSeq1.length(), cSeq2.length()));
        pos = 0;
        while (pos < max && cSeq1.charAt(pos) == cSeq2.charAt(pos)) {
            ++pos;
        }
        if (pos == 0) {
            return weight;
        }
        return weight + 0.1 * (double)pos * (1.0 - weight);
    }
}

