/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.util.Distance;
import com.aliasi.util.Proximity;

public class EditDistance
implements Distance<CharSequence>,
Proximity<CharSequence> {
    private final boolean mAllowTransposition;
    public static final Distance<CharSequence> TRANSPOSING = new EditDistance(true);
    public static final Distance<CharSequence> NON_TRANSPOSING = new EditDistance(false);

    public EditDistance(boolean allowTransposition) {
        this.mAllowTransposition = allowTransposition;
    }

    @Override
    public double distance(CharSequence cSeq1, CharSequence cSeq2) {
        return EditDistance.editDistance(cSeq1, cSeq2, this.mAllowTransposition);
    }

    @Override
    public double proximity(CharSequence cSeq1, CharSequence cSeq2) {
        return -this.distance(cSeq1, cSeq2);
    }

    public String toString() {
        return "EditDistance(" + this.mAllowTransposition + ")";
    }

    public static int editDistance(CharSequence cSeq1, CharSequence cSeq2, boolean allowTransposition) {
        if (cSeq1.length() < cSeq2.length()) {
            CharSequence temp = cSeq1;
            cSeq1 = cSeq2;
            cSeq2 = temp;
        }
        if (cSeq2.length() == 0) {
            return cSeq1.length();
        }
        if (cSeq2.length() == 1) {
            char c = cSeq2.charAt(0);
            int i = 0;
            while (i < cSeq1.length()) {
                if (cSeq1.charAt(i) == c) {
                    return cSeq1.length() - 1;
                }
                ++i;
            }
            return cSeq1.length();
        }
        if (allowTransposition) {
            return EditDistance.editDistanceTranspose(cSeq1, cSeq2);
        }
        return EditDistance.editDistanceNonTranspose(cSeq1, cSeq2);
    }

    private static int editDistanceNonTranspose(CharSequence cSeq1, CharSequence cSeq2) {
        int xsLength = cSeq1.length() + 1;
        int ysLength = cSeq2.length() + 1;
        int[] lastSlice = new int[ysLength];
        int[] currentSlice = new int[ysLength];
        int y = 0;
        while (y < ysLength) {
            currentSlice[y] = y;
            ++y;
        }
        int x = 1;
        while (x < xsLength) {
            char cX = cSeq1.charAt(x - 1);
            int[] lastSliceTmp = lastSlice;
            lastSlice = currentSlice;
            currentSlice = lastSliceTmp;
            currentSlice[0] = x;
            int y2 = 1;
            while (y2 < ysLength) {
                int yMinus1 = y2 - 1;
                currentSlice[y2] = Math.min(cX == cSeq2.charAt(yMinus1) ? lastSlice[yMinus1] : 1 + lastSlice[yMinus1], 1 + Math.min(lastSlice[y2], currentSlice[yMinus1]));
                ++y2;
            }
            ++x;
        }
        return currentSlice[currentSlice.length - 1];
    }

    private static int editDistanceTranspose(CharSequence cSeq1, CharSequence cSeq2) {
        int xsLength = cSeq1.length() + 1;
        int ysLength = cSeq2.length() + 1;
        int[] twoLastSlice = new int[ysLength];
        int[] lastSlice = new int[ysLength];
        int[] currentSlice = new int[ysLength];
        int y = 0;
        while (y < ysLength) {
            lastSlice[y] = y;
            ++y;
        }
        currentSlice[0] = 1;
        char cX = cSeq1.charAt(0);
        int y2 = 1;
        while (y2 < ysLength) {
            int yMinus1 = y2 - 1;
            currentSlice[y2] = Math.min(cX == cSeq2.charAt(yMinus1) ? lastSlice[yMinus1] : 1 + lastSlice[yMinus1], 1 + Math.min(lastSlice[y2], currentSlice[yMinus1]));
            ++y2;
        }
        char cYZero = cSeq2.charAt(0);
        int x = 2;
        while (x < xsLength) {
            char cXMinus1 = cX;
            cX = cSeq1.charAt(x - 1);
            int[] tmpSlice = twoLastSlice;
            twoLastSlice = lastSlice;
            lastSlice = currentSlice;
            currentSlice = tmpSlice;
            currentSlice[0] = x;
            currentSlice[1] = Math.min(cX == cYZero ? lastSlice[0] : 1 + lastSlice[0], 1 + Math.min(lastSlice[1], currentSlice[0]));
            char cY = cYZero;
            int y3 = 2;
            while (y3 < ysLength) {
                int yMinus1 = y3 - 1;
                char cYMinus1 = cY;
                cY = cSeq2.charAt(yMinus1);
                currentSlice[y3] = Math.min(cX == cY ? lastSlice[yMinus1] : 1 + lastSlice[yMinus1], 1 + Math.min(lastSlice[y3], currentSlice[yMinus1]));
                if (cX == cYMinus1 && cY == cXMinus1) {
                    currentSlice[y3] = Math.min(currentSlice[y3], 1 + twoLastSlice[y3 - 2]);
                }
                ++y3;
            }
            ++x;
        }
        return currentSlice[currentSlice.length - 1];
    }
}

