/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.io.BitInput;
import com.aliasi.io.BitOutput;
import com.aliasi.lm.CompiledNGramBoundaryLM;
import com.aliasi.lm.LanguageModel;
import com.aliasi.lm.NGramProcessLM;
import com.aliasi.lm.TrieCharSeqCounter;
import com.aliasi.stats.Model;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;

public class NGramBoundaryLM
implements LanguageModel.Sequence,
LanguageModel.Conditional,
LanguageModel.Dynamic,
Model<CharSequence>,
Compilable,
Serializable {
    static final long serialVersionUID = 2917786830470130748L;
    private final NGramProcessLM mProcessLM;
    private final char mBoundaryChar;
    private final char[] mBoundaryArray;

    public NGramBoundaryLM(int maxNGram) {
        this(maxNGram, 65534);
    }

    public NGramBoundaryLM(int maxNGram, int numChars) {
        this(maxNGram, numChars, maxNGram, '\uffff');
    }

    public NGramBoundaryLM(int maxNGram, int numChars, double lambdaFactor, char boundaryChar) {
        this(new NGramProcessLM(maxNGram, numChars + 1, lambdaFactor), boundaryChar);
    }

    public NGramBoundaryLM(NGramProcessLM processLm, char boundaryChar) {
        this.mBoundaryChar = boundaryChar;
        this.mBoundaryArray = new char[]{boundaryChar};
        this.mProcessLM = processLm;
    }

    public void writeTo(OutputStream out) throws IOException {
        BitOutput bitOut = new BitOutput(out);
        bitOut.writeDelta(this.mBoundaryChar + '\u0001');
        this.mProcessLM.writeTo(bitOut);
        bitOut.flush();
    }

    public static NGramBoundaryLM readFrom(InputStream in) throws IOException {
        BitInput bitIn = new BitInput(in);
        char boundaryChar = (char)(bitIn.readDelta() - 1L);
        NGramProcessLM processLM = NGramProcessLM.readFrom(bitIn);
        return new NGramBoundaryLM(processLM, boundaryChar);
    }

    public NGramProcessLM getProcessLM() {
        return this.mProcessLM;
    }

    @Override
    public char[] observedCharacters() {
        return this.mProcessLM.observedCharacters();
    }

    public TrieCharSeqCounter substringCounter() {
        return this.mProcessLM.substringCounter();
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    @Override
    public void handle(CharSequence cSeq) {
        this.train(cSeq);
    }

    @Override
    public void train(CharSequence cs, int count) {
        char[] csBounded = NGramBoundaryLM.addBoundaries(cs, this.mBoundaryChar);
        this.mProcessLM.train(csBounded, 0, csBounded.length, count);
        this.mProcessLM.decrementUnigram(this.mBoundaryChar, count);
    }

    @Override
    public void train(CharSequence cs) {
        this.train(cs, 1);
    }

    @Override
    public void train(char[] cs, int start, int end) {
        this.train(cs, start, end, 1);
    }

    @Override
    public void train(char[] cs, int start, int end, int count) {
        char[] csBounded = NGramBoundaryLM.addBoundaries(cs, start, end, this.mBoundaryChar);
        this.mProcessLM.train(csBounded, 0, csBounded.length, count);
        this.mProcessLM.decrementUnigram(this.mBoundaryChar, count);
    }

    @Override
    public double log2ConditionalEstimate(CharSequence cs) {
        if (cs.length() < 1) {
            String msg = "Conditional estimate must be at least one character.";
            throw new IllegalArgumentException(msg);
        }
        char[] csBounded = NGramBoundaryLM.addBoundaries(cs, this.mBoundaryChar);
        return this.mProcessLM.log2ConditionalEstimate(csBounded, 0, csBounded.length - 1);
    }

    @Override
    public double log2ConditionalEstimate(char[] cs, int start, int end) {
        if (end <= start) {
            String msg = "Conditional estimate must be at least one character.";
            throw new IllegalArgumentException(msg);
        }
        char[] csBounded = NGramBoundaryLM.addBoundaries(cs, start, end, this.mBoundaryChar);
        return this.mProcessLM.log2ConditionalEstimate(csBounded, 0, csBounded.length - 1);
    }

    @Override
    public double log2Estimate(CharSequence cs) {
        char[] csBounded = NGramBoundaryLM.addBoundaries(cs, this.mBoundaryChar);
        return this.mProcessLM.log2Estimate(csBounded, 0, csBounded.length) - this.mProcessLM.log2Estimate(this.mBoundaryArray, 0, 1);
    }

    @Override
    public double log2Estimate(char[] cs, int start, int end) {
        char[] csBounded = NGramBoundaryLM.addBoundaries(cs, start, end, this.mBoundaryChar);
        return this.mProcessLM.log2Estimate(csBounded, 0, csBounded.length) - this.mProcessLM.log2Estimate(this.mBoundaryArray, 0, 1);
    }

    @Override
    public double log2Prob(CharSequence cSeq) {
        return this.log2Estimate(cSeq);
    }

    @Override
    public double prob(CharSequence cSeq) {
        return Math.pow(2.0, this.log2Estimate(cSeq));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Boundary char=" + this.mBoundaryChar);
        sb.append('\n');
        this.mProcessLM.toStringBuilder(sb);
        return sb.toString();
    }

    static char[] addBoundaries(CharSequence cs, char boundaryChar) {
        char[] cs2 = new char[cs.length() + 2];
        int i = 0;
        while (i < cs.length()) {
            char c = cs.charAt(i);
            if (c == boundaryChar) {
                String msg = "Estimated string cannot contain boundary char. Found boundary char=" + c + " at index=" + i;
                throw new IllegalArgumentException(msg);
            }
            cs2[i + 1] = cs.charAt(i);
            ++i;
        }
        NGramBoundaryLM.addBoundaryChars(cs2, boundaryChar);
        return cs2;
    }

    static char[] addBoundaries(char[] cs, int start, int end, char boundaryChar) {
        char[] cs2 = new char[cs.length + 1];
        int len = end - start;
        int i = 0;
        while (i < len) {
            char c = cs[i + start];
            if (c == boundaryChar) {
                String msg = "Estimated string cannot contain boundary char. Found boundary char=" + c + " at index=" + (i + start);
                throw new IllegalArgumentException(msg);
            }
            cs2[i + 1] = c;
            ++i;
        }
        NGramBoundaryLM.addBoundaryChars(cs2, boundaryChar);
        return cs2;
    }

    static void addBoundaryChars(char[] cs, char boundaryChar) {
        cs[0] = boundaryChar;
        cs[cs.length - 1] = boundaryChar;
    }

    static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = -7945082563035787530L;
        final NGramBoundaryLM mLM;

        public Externalizer() {
            this(null);
        }

        public Externalizer(NGramBoundaryLM lm) {
            this.mLM = lm;
        }

        @Override
        public Object read(ObjectInput objIn) throws IOException {
            return new CompiledNGramBoundaryLM(objIn);
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeChar(this.mLM.mBoundaryChar);
            this.mLM.mProcessLM.compileTo(objOut);
        }
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = -251292379784295407L;
        final NGramBoundaryLM mLM;

        public Serializer() {
            this(null);
        }

        public Serializer(NGramBoundaryLM lm) {
            this.mLM = lm;
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeChar(this.mLM.mBoundaryChar);
            objOut.writeObject(this.mLM.mProcessLM);
        }

        @Override
        public Object read(ObjectInput objIn) throws IOException, ClassNotFoundException {
            char boundaryChar = objIn.readChar();
            NGramProcessLM lm = (NGramProcessLM)objIn.readObject();
            return new NGramBoundaryLM(lm, boundaryChar);
        }
    }
}

