/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.LanguageModel;
import com.aliasi.stats.Model;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.Arrays;

public class CompiledNGramProcessLM
implements LanguageModel.Process,
LanguageModel.Conditional,
Model<CharSequence> {
    private final int mMaxNGram;
    private final float mLogUniformEstimate;
    private final char[] mChars;
    private final float[] mLogProbs;
    private final float[] mLogOneMinusLambdas;
    private final int[] mFirstChild;
    private final int[] mSuffix;
    private final int mLastContextIndex;
    public static final int ROOT_NODE_INDEX = 0;
    private static final int CACHE_NOT_COMPUTED_VALUE = -1;

    CompiledNGramProcessLM(ObjectInput dataIn) throws IOException {
        int lastInternalNodeIndex;
        this.mMaxNGram = dataIn.readInt();
        this.mLogUniformEstimate = dataIn.readFloat();
        int numTotalNodes = dataIn.readInt();
        this.mLastContextIndex = lastInternalNodeIndex = dataIn.readInt();
        this.mChars = new char[numTotalNodes];
        this.mLogProbs = new float[numTotalNodes];
        this.mSuffix = new int[numTotalNodes];
        Arrays.fill(this.mSuffix, -1);
        this.mLogOneMinusLambdas = new float[lastInternalNodeIndex + 1];
        this.mFirstChild = new int[lastInternalNodeIndex + 2];
        this.mFirstChild[lastInternalNodeIndex + 1] = numTotalNodes;
        int i = 0;
        while (i <= lastInternalNodeIndex) {
            this.mChars[i] = dataIn.readChar();
            this.mLogProbs[i] = dataIn.readFloat();
            this.mLogOneMinusLambdas[i] = dataIn.readFloat();
            this.mFirstChild[i] = dataIn.readInt();
            ++i;
        }
        i = lastInternalNodeIndex + 1;
        while (i < numTotalNodes) {
            this.mChars[i] = dataIn.readChar();
            this.mLogProbs[i] = dataIn.readFloat();
            ++i;
        }
        this.compileSuffixes("", 0);
    }

    @Override
    public char[] observedCharacters() {
        if (this.mFirstChild.length < 2) {
            return new char[0];
        }
        char[] result = new char[this.mFirstChild[1] - 1];
        int i = 0;
        while (i < result.length) {
            result[i] = this.mChars[i + 1];
            ++i;
        }
        return result;
    }

    public int maxNGram() {
        return this.mMaxNGram;
    }

    public int numNodes() {
        return this.mChars.length;
    }

    public int longestContextIndex(String context) {
        char[] cs = context.toCharArray();
        int length = cs.length;
        int i = 0;
        while (i < length) {
            int k = this.getIndex(cs, i, length);
            if (k >= 0) {
                while (k >= this.mLogOneMinusLambdas.length) {
                    k = this.mSuffix[k];
                }
                return k;
            }
            ++i;
        }
        return 0;
    }

    int numInternalNodes() {
        return this.mFirstChild.length;
    }

    private void compileSuffixes(String context, int index) {
        this.mSuffix[index] = this.suffixIndex(context);
        if (index >= this.mFirstChild.length) {
            return;
        }
        int firstChildIndex = this.mFirstChild[index];
        int lastChildIndex = index + 1 < this.mFirstChild.length ? this.mFirstChild[index + 1] : this.mChars.length;
        int i = firstChildIndex;
        while (i < lastChildIndex) {
            this.compileSuffixes(String.valueOf(context) + this.mChars[i], i);
            ++i;
        }
    }

    private int suffixIndex(String context) {
        int suffixLength = context.length() - 1;
        if (suffixLength < 0) {
            return -1;
        }
        char[] cs = new char[suffixLength];
        int i = 0;
        while (i < suffixLength) {
            cs[i] = context.charAt(i + 1);
            ++i;
        }
        return this.getIndex(cs, 0, suffixLength);
    }

    @Override
    public double log2Prob(CharSequence cSeq) {
        return this.log2Estimate(cSeq);
    }

    @Override
    public double prob(CharSequence cSeq) {
        return Math.pow(2.0, this.log2Estimate(cSeq));
    }

    @Override
    public final double log2Estimate(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.log2Estimate(cs, 0, cs.length);
    }

    public final double log2Estimate(int contextIndex, char nextChar) {
        int outcomeIndex;
        double sum = 0.0;
        int currentContextIndex = contextIndex;
        while ((outcomeIndex = this.getIndex(currentContextIndex, nextChar)) < 0) {
            if (currentContextIndex < this.mLogOneMinusLambdas.length) {
                sum += (double)this.mLogOneMinusLambdas[currentContextIndex];
            }
            if (currentContextIndex == 0) {
                return sum + (double)this.mLogUniformEstimate;
            }
            currentContextIndex = this.mSuffix[currentContextIndex];
        }
        return sum + (double)this.mLogProbs[outcomeIndex];
    }

    public int nextContext(int contextIndex, char nextChar) {
        if (contextIndex < 0 || contextIndex > this.mLastContextIndex) {
            String msg = "Context must be greater than zero. Context must be less than last index=" + this.mLastContextIndex + " Context=" + contextIndex;
            throw new IllegalArgumentException(msg);
        }
        int currentContextIndex = contextIndex;
        int outcomeIndex;
        while ((outcomeIndex = this.getIndex(currentContextIndex, nextChar)) >= this.mLogOneMinusLambdas.length || outcomeIndex < 0) {
            if (currentContextIndex == 0) {
                return 0;
            }
            currentContextIndex = this.mSuffix[currentContextIndex];
        }
        return outcomeIndex;
    }

    @Override
    public final double log2Estimate(char[] cs, int start, int end) {
        int len = this.mLogOneMinusLambdas.length;
        Strings.checkArgsStartEnd(cs, start, end);
        double sum = 0.0;
        int contextIndex = 0;
        int i = start;
        while (i < end) {
            block4: {
                int outcomeIndex;
                char nextChar = cs[i];
                while ((outcomeIndex = this.getIndex(contextIndex, nextChar)) < 0) {
                    if (contextIndex < len) {
                        sum += (double)this.mLogOneMinusLambdas[contextIndex];
                    }
                    if (contextIndex == 0) {
                        sum += (double)this.mLogUniformEstimate;
                        contextIndex = 0;
                        break block4;
                    }
                    contextIndex = this.mSuffix[contextIndex];
                }
                sum += (double)this.mLogProbs[outcomeIndex];
                contextIndex = outcomeIndex < len ? outcomeIndex : this.mSuffix[outcomeIndex];
            }
            ++i;
        }
        return sum;
    }

    @Override
    public double log2ConditionalEstimate(CharSequence cSeq) {
        char[] cs = cSeq.toString().toCharArray();
        return this.log2ConditionalEstimate(cs, 0, cs.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double log2ConditionalEstimate(char[] cs, int start, int end) {
        Strings.checkArgsStartEnd(cs, start, end);
        total = 0.0;
        contextEnd = end - 1;
        c = cs[contextEnd];
        contextLength = maxContextLength = Math.min(contextEnd - start, this.mMaxNGram - 1);
        while (contextLength >= 0) {
            block3: {
                contextStart = contextEnd - contextLength;
                contextIndex = this.getIndex(cs, contextStart, contextEnd);
                if (contextIndex != -1) ** GOTO lbl12
                break block3;
lbl-1000:
                // 1 sources

                {
                    contextIndex = this.mSuffix[contextIndex];
lbl12:
                    // 2 sources

                    ** while (contextIndex > this.mLastContextIndex)
                }
lbl13:
                // 1 sources

                outcomeIndex = this.getIndex(contextIndex, c);
                if (outcomeIndex != -1) {
                    return total + (double)this.mLogProbs[outcomeIndex];
                }
                total += (double)this.mLogOneMinusLambdas[contextIndex];
            }
            --contextLength;
        }
        return total + (double)this.mLogUniformEstimate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Max NGram=" + this.mMaxNGram);
        sb.append('\n');
        sb.append("Log2 Uniform Estimate=" + this.mLogUniformEstimate);
        sb.append('\n');
        sb.append("i c suff prob 1-lambda firstChild");
        sb.append('\n');
        int i = 0;
        while (i < this.mChars.length) {
            sb.append(i);
            sb.append(" ");
            sb.append(this.mChars[i]);
            sb.append(" ");
            sb.append(this.mSuffix[i]);
            sb.append(" ");
            sb.append(this.mLogProbs[i]);
            if (i < this.mLogOneMinusLambdas.length) {
                sb.append(" ");
                sb.append(this.mFirstChild[i]);
                sb.append(" ");
                sb.append(this.mLogOneMinusLambdas[i]);
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    private int getIndex(int fromIndex, char c) {
        if (fromIndex + 1 >= this.mFirstChild.length) {
            return -1;
        }
        int low = this.mFirstChild[fromIndex];
        int high = this.mFirstChild[fromIndex + 1] - 1;
        while (low <= high) {
            int mid = (high + low) / 2;
            if (this.mChars[mid] == c) {
                return mid;
            }
            if (this.mChars[mid] < c) {
                low = low == mid ? mid + 1 : mid;
                continue;
            }
            int n = high = high == mid ? mid - 1 : mid;
        }
        return -1;
    }

    private int getIndex(char[] cs, int start, int end) {
        int index = 0;
        int currentStart = start;
        while (currentStart < end) {
            if ((index = this.getIndex(index, cs[currentStart])) == -1) {
                return -1;
            }
            ++currentStart;
        }
        return index;
    }
}

