/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;

public class FileExtensionFilter
implements FileFilter {
    private final String[] mExtensions;
    private final boolean mAcceptDirectories;

    @Deprecated
    public FileExtensionFilter(String[] extensions, boolean acceptDirectories) {
        this(acceptDirectories, extensions);
    }

    public FileExtensionFilter(boolean acceptDirectories, String ... extensions) {
        this.mAcceptDirectories = acceptDirectories;
        this.mExtensions = new String[extensions.length];
        int i = 0;
        while (i < extensions.length) {
            this.mExtensions[i] = extensions[i];
            ++i;
        }
    }

    public FileExtensionFilter(String extension, boolean acceptDirectories) {
        this(new String[]{extension}, acceptDirectories);
    }

    public FileExtensionFilter(String extension) {
        this(extension, true);
    }

    public FileExtensionFilter(String ... extensions) {
        this(extensions, true);
    }

    protected final boolean accept(String fileName) {
        int i = 0;
        while (i < this.mExtensions.length) {
            if (fileName.endsWith(this.mExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean accept(File pathName) {
        return this.mAcceptDirectories && pathName.isDirectory() || this.accept(pathName.getName());
    }

    public FilenameFilter fileNameFilter() {
        final FileExtensionFilter fef = this;
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return fef.accept(new File(dir, name));
            }
        };
    }
}

