/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus;

import com.aliasi.corpus.Handler;
import com.aliasi.util.Strings;
import java.io.File;
import java.io.IOException;
import org.xml.sax.InputSource;

public abstract class Parser<H extends Handler> {
    private H mHandler;

    public Parser() {
        this(null);
    }

    public Parser(H handler) {
        this.mHandler = handler;
    }

    public void setHandler(H handler) {
        this.mHandler = handler;
    }

    public H getHandler() {
        return this.mHandler;
    }

    public void parse(String sysId) throws IOException {
        InputSource in = new InputSource(sysId);
        this.parse(in);
    }

    public void parse(String sysId, String charEncoding) throws IOException {
        InputSource in = new InputSource(sysId);
        in.setEncoding(charEncoding);
        this.parse(in);
    }

    public void parse(File file) throws IOException {
        this.parse(file.toURI().toURL().toString());
    }

    public void parse(File file, String charEncoding) throws IOException {
        String urlName = file.toURI().toURL().toString();
        InputSource in = new InputSource(urlName);
        in.setEncoding(charEncoding);
        this.parse(in);
    }

    public void parseString(CharSequence cSeq) throws IOException {
        char[] cs = Strings.toCharArray(cSeq);
        this.parseString(cs, 0, cs.length);
    }

    public abstract void parse(InputSource var1) throws IOException;

    public abstract void parseString(char[] var1, int var2, int var3) throws IOException;
}

