/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.coref.matchers;

import com.aliasi.coref.BooleanMatcherAdapter;
import com.aliasi.coref.Mention;
import com.aliasi.coref.MentionChain;

public final class SequenceSubstringMatch
extends BooleanMatcherAdapter {
    public SequenceSubstringMatch(int score) {
        super(score);
    }

    @Override
    public boolean matchBoolean(Mention mention, MentionChain chain) {
        if (mention.isPronominal()) {
            return false;
        }
        String[] mentionTokens = mention.normalTokens();
        for (Mention chainMention : chain.mentions()) {
            String[] chainMentionTokens = chainMention.normalTokens();
            if (!this.withinEditDistance(mentionTokens, chainMentionTokens)) continue;
            return true;
        }
        return false;
    }

    private static int threshold(String[] tokens1, String[] tokens2) {
        int max = Math.max(tokens1.length, tokens2.length);
        switch (max) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
        }
        return (max + 1) / 3;
    }

    public boolean withinEditDistance(String[] tokens1, String[] tokens2) {
        return this.withinEditDistance(tokens1, tokens2, SequenceSubstringMatch.threshold(tokens1, tokens2));
    }

    public boolean withinEditDistance(String[] tokens1, String[] tokens2, int maximumDistance) {
        int[][] distances = new int[tokens2.length + 1][tokens1.length + 1];
        distances[0][0] = 0;
        int i = 1;
        while (i <= tokens1.length) {
            distances[0][i] = distances[0][i - 1] + this.deleteCost(tokens1[i - 1]);
            ++i;
        }
        int j = 1;
        while (j <= tokens2.length) {
            distances[j][0] = distances[j - 1][0] + this.deleteCost(tokens2[j - 1]);
            boolean keep = distances[j][0] <= maximumDistance;
            int i2 = 1;
            while (i2 <= tokens1.length) {
                distances[j][i2] = Math.min(distances[j - 1][i2 - 1] + this.substituteCost(tokens1[i2 - 1], tokens2[j - 1]), Math.min(distances[j - 1][i2] + this.deleteCost(tokens2[j - 1]), distances[j][i2 - 1] + this.deleteCost(tokens1[i2 - 1])));
                if (!keep && distances[j][i2] <= maximumDistance) {
                    keep = true;
                }
                ++i2;
            }
            if (!keep) {
                return false;
            }
            ++j;
        }
        return distances[tokens2.length][tokens1.length] <= maximumDistance;
    }

    protected int deleteCost(String token) {
        return 1;
    }

    protected int insertCost(String token) {
        return 1;
    }

    protected int substituteCost(String originalToken, String newToken) {
        return originalToken.equalsIgnoreCase(newToken) ? 0 : 2;
    }
}

