/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.PrecisionRecallEvaluation;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ScoredPrecisionRecallEvaluation {
    private final List<Case> mCases = new ArrayList<Case>();
    private int mNegativeRef = 0;
    private int mPositiveRef = 0;
    static final double[][] EMPTY_DOUBLE_2D_ARRAY = new double[0][];

    public void addCase(boolean correct, double score) {
        this.mCases.add(new Case(correct, score));
        if (correct) {
            ++this.mPositiveRef;
        } else {
            ++this.mNegativeRef;
        }
    }

    public void addMisses(int count) {
        if (count < 0) {
            String msg = "Miss count must be non-negative. Found count=" + count;
            throw new IllegalArgumentException(msg);
        }
        this.mPositiveRef += count;
    }

    public void addNegativeMisses(int count) {
        if (count < 0) {
            String msg = "Miss count must be non-negative. Found count=" + count;
            throw new IllegalArgumentException(msg);
        }
        this.mNegativeRef += count;
    }

    public int numCases() {
        return this.mPositiveRef + this.mNegativeRef;
    }

    public int numPositiveRef() {
        return this.mPositiveRef;
    }

    public int numNegativeRef() {
        return this.mNegativeRef;
    }

    public double rPrecision() {
        if (this.mPositiveRef == 0) {
            return 1.0;
        }
        double[][] rps = this.prCurve(false);
        return this.mPositiveRef < rps.length ? rps[this.mPositiveRef - 1][1] : rps[rps.length - 1][1] * (double)(rps.length - 1) / (double)this.mPositiveRef;
    }

    public double[] elevenPtInterpPrecision() {
        double[] xs = new double[11];
        double[][] rps = this.prCurve(true);
        double sum = 0.0;
        int i = 0;
        while (i <= 10) {
            xs[i] = ScoredPrecisionRecallEvaluation.precisionAtRecall(0.1 * (double)i, rps);
            ++i;
        }
        return xs;
    }

    static double precisionAtRecall(double recall, double[][] rps) {
        int i = 0;
        while (i < rps.length) {
            if (rps[i][0] + 1.0E-13 >= recall) {
                return rps[i][1];
            }
            ++i;
        }
        return 0.0;
    }

    public double averagePrecision() {
        double recall = 0.0;
        double[][] rps = this.prCurve(false);
        double sum = 0.0;
        double[][] dArray = rps;
        int n = rps.length;
        int n2 = 0;
        while (n2 < n) {
            double[] rp = dArray[n2];
            if (rp[0] > recall) {
                sum += rp[1];
                recall = rp[0];
            }
            ++n2;
        }
        return sum / (double)this.mPositiveRef;
    }

    public double[][] prCurve(boolean interpolate) {
        PrecisionRecallEvaluation eval = new PrecisionRecallEvaluation();
        ArrayList<double[]> prList = new ArrayList<double[]>();
        prList.add(new double[]{0.0, 1.0});
        for (Case cse : this.sortedCases()) {
            boolean correct = cse.mCorrect;
            eval.addCase(correct, true);
            double r = ScoredPrecisionRecallEvaluation.div(eval.truePositive(), this.mPositiveRef);
            double p = eval.precision();
            if (r == 0.0 && p == 0.0) continue;
            prList.add(new double[]{r, p});
        }
        prList.add(new double[]{1.0, 0.0});
        return ScoredPrecisionRecallEvaluation.interpolate(prList, interpolate);
    }

    public double[][] prScoreCurve(boolean interpolate) {
        PrecisionRecallEvaluation eval = new PrecisionRecallEvaluation();
        ArrayList<double[]> prList = new ArrayList<double[]>();
        for (Case cse : this.sortedCases()) {
            boolean correct = cse.mCorrect;
            eval.addCase(correct, true);
            double r = ScoredPrecisionRecallEvaluation.div(eval.truePositive(), this.mPositiveRef);
            double p = eval.precision();
            double s = cse.score();
            prList.add(new double[]{r, p, s});
        }
        return ScoredPrecisionRecallEvaluation.interpolate(prList, interpolate);
    }

    public double[][] rocCurve(boolean interpolate) {
        PrecisionRecallEvaluation eval = new PrecisionRecallEvaluation();
        List<double[]> ssList = new ArrayList<double[]>();
        int trueNegs = this.mNegativeRef;
        ssList.add(new double[]{0.0, 0.0});
        for (Case cse : this.sortedCases()) {
            boolean correct = cse.mCorrect;
            eval.addCase(correct, true);
            if (!correct) {
                --trueNegs;
            }
            double r = ScoredPrecisionRecallEvaluation.div(eval.truePositive(), this.mPositiveRef);
            double rr = ScoredPrecisionRecallEvaluation.div(trueNegs, this.mNegativeRef);
            ssList.add(new double[]{1.0 - rr, r});
        }
        ssList.add(new double[]{1.0, 1.0});
        if (interpolate) {
            ssList = ScoredPrecisionRecallEvaluation.interpolateRoc(ssList);
        }
        return (double[][])ssList.toArray((T[])EMPTY_DOUBLE_2D_ARRAY);
    }

    static List<double[]> interpolateRoc(List<double[]> ssList) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        int i = 0;
        while (i + 1 < ssList.size()) {
            if (ssList.get(i)[0] != ssList.get(i + 1)[0]) {
                result.add(ssList.get(i));
            }
            ++i;
        }
        result.add(ssList.get(ssList.size() - 1));
        return result;
    }

    public double maximumFMeasure() {
        return this.maximumFMeasure(1.0);
    }

    public double maximumFMeasure(double beta) {
        double maxF = 0.0;
        double[][] pr = this.prCurve(false);
        int i = 0;
        while (i < pr.length) {
            double f = PrecisionRecallEvaluation.fMeasure(beta, pr[i][0], pr[i][1]);
            maxF = Math.max(maxF, f);
            ++i;
        }
        return maxF;
    }

    public double precisionAt(int rank) {
        if (rank < 0) {
            String msg = "Rank must be positive. Found rank=" + rank;
            throw new IllegalArgumentException(msg);
        }
        if (rank == 0) {
            return 1.0;
        }
        int correctCount = 0;
        Iterator<Case> it = this.sortedCases().iterator();
        int i = 0;
        while (i < rank && i < this.mCases.size()) {
            if (it.next().mCorrect) {
                ++correctCount;
            }
            ++i;
        }
        return (double)correctCount / (double)rank;
    }

    public double prBreakevenPoint() {
        return this.rPrecision();
    }

    public double reciprocalRank() {
        Iterator<Case> it = this.sortedCases().iterator();
        int i = 0;
        while (it.hasNext()) {
            Case cse = it.next();
            boolean correct = cse.mCorrect;
            if (correct) {
                return 1.0 / (double)(i + 1);
            }
            ++i;
        }
        return 0.0;
    }

    public double areaUnderPrCurve(boolean interpolate) {
        return ScoredPrecisionRecallEvaluation.areaUnder(this.prCurve(interpolate));
    }

    public double areaUnderRocCurve(boolean interpolate) {
        return ScoredPrecisionRecallEvaluation.areaUnder(this.rocCurve(interpolate));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  Area Under PR Curve (interpolated)=" + this.areaUnderPrCurve(true));
        sb.append("\n  Area Under PR Curve (uninterpolated)=" + this.areaUnderPrCurve(false));
        sb.append("\n  Area Under ROC Curve (interpolated)=" + this.areaUnderRocCurve(true));
        sb.append("\n  Area Under ROC Curve (uninterpolated)=" + this.areaUnderRocCurve(false));
        sb.append("\n  Average Precision=" + this.averagePrecision());
        sb.append("\n  Maximum F(1) Measure=" + this.maximumFMeasure());
        sb.append("\n  BEP (Precision-Recall break even point)=" + this.prBreakevenPoint());
        sb.append("\n  Reciprocal Rank=" + this.reciprocalRank());
        int[] ranks = new int[]{5, 10, 25, 100, 500};
        int i = 0;
        while (i < ranks.length && this.mCases.size() < ranks[i]) {
            sb.append("\n  Precision at " + ranks[i] + "=" + this.precisionAt(ranks[i]));
            ++i;
        }
        return sb.toString();
    }

    public static void printPrecisionRecallCurve(double[][] prCurve, PrintWriter pw) {
        pw.printf("%8s %8s %8s\n", "PRECI.", "RECALL", "F");
        double[][] dArray = prCurve;
        int n = prCurve.length;
        int n2 = 0;
        while (n2 < n) {
            double[] pr = dArray[n2];
            pw.printf("%8.6f %8.6f %8.6f\n", pr[1], pr[0], PrecisionRecallEvaluation.fMeasure(1.0, pr[0], pr[1]));
            ++n2;
        }
        pw.flush();
    }

    public static void printScorePrecisionRecallCurve(double[][] prScoreCurve, PrintWriter pw) {
        pw.printf("%8s %8s %8s\n", "PRECI.", "RECALL", "SCORE");
        double[][] dArray = prScoreCurve;
        int n = prScoreCurve.length;
        int n2 = 0;
        while (n2 < n) {
            double[] pr = dArray[n2];
            pw.printf("%8.6f %8.6f %8.6f\n", pr[1], pr[0], pr[2]);
            ++n2;
        }
        pw.flush();
    }

    private List<Case> sortedCases() {
        Collections.sort(this.mCases, ScoredObject.reverseComparator());
        return this.mCases;
    }

    static double div(double x, double y) {
        return x / y;
    }

    private static double[][] interpolate(List<double[]> prList, boolean interpolate) {
        if (!interpolate) {
            return (double[][])prList.toArray((T[])EMPTY_DOUBLE_2D_ARRAY);
        }
        Collections.reverse(prList);
        LinkedList<double[]> resultList = new LinkedList<double[]>();
        double minP = 0.0;
        for (double[] rp : prList) {
            double p = rp[1];
            if (p > minP) {
                minP = p;
            } else {
                rp[1] = minP;
            }
            resultList.addFirst(rp);
        }
        LinkedList<double[]> trimmedResultList = new LinkedList<double[]>();
        double[] rp = new double[]{0.0, 1.0};
        for (double[] rp2 : resultList) {
            if (rp2[0] == rp[0]) continue;
            trimmedResultList.add(rp);
            rp = rp2;
        }
        trimmedResultList.add(rp);
        return (double[][])trimmedResultList.toArray((T[])EMPTY_DOUBLE_2D_ARRAY);
    }

    private static double areaUnder(double[][] f) {
        double area = 0.0;
        int i = 1;
        while (i < f.length) {
            area += ScoredPrecisionRecallEvaluation.area(f[i - 1][0], f[i - 1][1], f[i][0], f[i][1]);
            ++i;
        }
        return area;
    }

    private static double area(double x1, double y1, double x2, double y2) {
        return (y1 + y2) * (x2 - x1) / 2.0;
    }

    static class Case
    implements Scored {
        private final boolean mCorrect;
        private final double mScore;

        Case(boolean correct, double score) {
            this.mCorrect = correct;
            this.mScore = score;
        }

        @Override
        public double score() {
            return this.mScore;
        }

        public String toString() {
            return String.valueOf(this.mCorrect) + " : " + this.mScore;
        }
    }
}

