/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.RankedClassification;
import com.aliasi.util.ScoredObject;
import java.util.Arrays;
import java.util.List;

public class ScoredClassification
extends RankedClassification {
    private final double[] mScores;

    public ScoredClassification(String[] categories, double[] scores) {
        super(categories);
        if (categories.length != scores.length) {
            String msg = "Categories and scores must be of same length. Categories length=" + categories.length + " Scores length=" + scores.length;
            throw new IllegalArgumentException(msg);
        }
        int i = 1;
        while (i < scores.length) {
            if (scores[i - 1] < scores[i]) {
                String msg = "Array of scores must be in order. scores[" + (i - 1) + "]=" + scores[i - 1] + " < scores[" + i + "]=" + scores[i];
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
        this.mScores = scores;
    }

    @Deprecated
    public static ScoredClassification create(ScoredObject<String>[] categoryScores) {
        Arrays.sort(categoryScores, ScoredObject.reverseComparator());
        String[] categories = new String[categoryScores.length];
        double[] scores = new double[categoryScores.length];
        int i = 0;
        while (i < categoryScores.length) {
            categories[i] = categoryScores[i].getObject();
            scores[i] = categoryScores[i].score();
            ++i;
        }
        return new ScoredClassification(categories, scores);
    }

    public static ScoredClassification create(List<ScoredObject<String>> categoryScores) {
        ScoredObject[] sos = new ScoredObject[categoryScores.size()];
        categoryScores.toArray(sos);
        return ScoredClassification.create(sos);
    }

    public double score(int rank) {
        this.checkRange(rank);
        return this.mScores[rank];
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rank  Category  Score\n");
        int i = 0;
        while (i < this.size()) {
            sb.append(String.valueOf(i) + "=" + this.category(i) + " " + this.score(i) + '\n');
            ++i;
        }
        return sb.toString();
    }
}

