/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.ScoredClassification;
import com.aliasi.classify.ScoredClassifier;
import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.features.Features;
import com.aliasi.matrix.KernelFunction;
import com.aliasi.matrix.Vector;
import com.aliasi.symbol.MapSymbolTable;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Arrays;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerceptronClassifier<E>
implements ScoredClassifier<E>,
Serializable {
    static final long serialVersionUID = 8752291174601085455L;
    final FeatureExtractor<? super E> mFeatureExtractor;
    final MapSymbolTable mSymbolTable;
    final KernelFunction mKernelFunction;
    final Vector[] mBasisVectors;
    final int[] mBasisWeights;
    final String mAcceptCategory;
    final String mRejectCategory;
    static final Vector[] EMPTY_SPARSE_FLOAT_VECTOR_ARRAY = new Vector[0];
    static final int INITIAL_BASIS_SIZE = 32768;

    PerceptronClassifier(FeatureExtractor<? super E> featureExtractor, KernelFunction kernelFunction, MapSymbolTable symbolTable, Vector[] basisVectors, int[] basisWeights, String acceptCategory, String rejectCategory) {
        this.mFeatureExtractor = featureExtractor;
        this.mKernelFunction = kernelFunction;
        this.mBasisVectors = basisVectors;
        this.mBasisWeights = basisWeights;
        this.mAcceptCategory = acceptCategory;
        this.mRejectCategory = rejectCategory;
        this.mSymbolTable = symbolTable;
    }

    public PerceptronClassifier(Corpus<ObjectHandler<Classified<E>>> corpus, FeatureExtractor<? super E> featureExtractor, KernelFunction kernelFunction, String corpusAcceptCategory, int numIterations, String outputAcceptCategory, String outputRejectCategory) throws IOException {
        this.mFeatureExtractor = featureExtractor;
        this.mKernelFunction = kernelFunction;
        this.mAcceptCategory = outputAcceptCategory;
        this.mRejectCategory = outputRejectCategory;
        this.mSymbolTable = new MapSymbolTable();
        CorpusCollector collector = new CorpusCollector();
        corpus.visitCorpus(collector);
        Vector[] featureVectors = collector.featureVectors();
        boolean[] polarities = collector.polarities();
        corpus = null;
        int currentPerceptronIndex = -1;
        int[] weights = new int[32768];
        int[] basisIndexes = new int[32768];
        int iteration = 0;
        while (iteration < numIterations) {
            int i = 0;
            while (i < featureVectors.length) {
                boolean accept;
                double yHat = this.prediction(featureVectors[i], featureVectors, polarities, weights, basisIndexes, currentPerceptronIndex);
                boolean bl = accept = yHat > 0.0;
                if (accept == polarities[i]) {
                    if (currentPerceptronIndex >= 0) {
                        int n = currentPerceptronIndex;
                        weights[n] = weights[n] + 1;
                    }
                } else {
                    if (++currentPerceptronIndex >= weights.length) {
                        weights = Arrays.reallocate(weights);
                        basisIndexes = Arrays.reallocate(basisIndexes);
                    }
                    basisIndexes[currentPerceptronIndex] = i;
                    weights[currentPerceptronIndex] = 1;
                }
                ++i;
            }
            ++iteration;
        }
        HashMap<Integer, Integer> renumbering = new HashMap<Integer, Integer>();
        int next = 0;
        int i = 0;
        while (i <= currentPerceptronIndex) {
            if (!renumbering.containsKey(basisIndexes[i])) {
                renumbering.put(basisIndexes[i], next++);
            }
            ++i;
        }
        this.mBasisVectors = new Vector[renumbering.size()];
        this.mBasisWeights = new int[renumbering.size()];
        int weightSum = 0;
        int i2 = currentPerceptronIndex + 1;
        while (--i2 >= 0) {
            int oldIndex = basisIndexes[i2];
            int newIndex = (Integer)renumbering.get(oldIndex);
            this.mBasisVectors[newIndex] = featureVectors[oldIndex];
            weightSum += weights[i2];
            if (polarities[i2]) {
                int n = newIndex;
                this.mBasisWeights[n] = this.mBasisWeights[n] + weightSum;
                continue;
            }
            int n = newIndex;
            this.mBasisWeights[n] = this.mBasisWeights[n] - weightSum;
        }
    }

    public KernelFunction kernelFunction() {
        return this.mKernelFunction;
    }

    public FeatureExtractor<? super E> featureExtractor() {
        return this.mFeatureExtractor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Averaged Perceptron");
        sb.append("  Kernel Function=" + this.mKernelFunction + "\n");
        int i = 0;
        while (i < this.mBasisVectors.length) {
            sb.append("  idx=" + i + " " + "vec=" + this.mBasisVectors[i] + " wgt=" + this.mBasisWeights[i] + "\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public ScoredClassification classify(E in) {
        Map<String, Number> featureVector = this.mFeatureExtractor.features(in);
        Vector inputVector = Features.toVector(featureVector, this.mSymbolTable, Integer.MAX_VALUE, false);
        double sum = 0.0;
        int i = this.mBasisVectors.length;
        while (--i >= 0) {
            sum += (double)this.mBasisWeights[i] * this.mKernelFunction.proximity(this.mBasisVectors[i], inputVector);
        }
        return sum > 0.0 ? new ScoredClassification(new String[]{this.mAcceptCategory, this.mRejectCategory}, new double[]{sum, -sum}) : new ScoredClassification(new String[]{this.mRejectCategory, this.mAcceptCategory}, new double[]{-sum, sum});
    }

    double prediction(Vector inputVector, Vector[] featureVectors, boolean[] polarities, int[] ignoreMyWeights, int[] basisIndexes, int currentPerceptronIndex) {
        double sum = 0.0;
        int weightSum = 1;
        int i = currentPerceptronIndex;
        while (i >= 0) {
            int index = basisIndexes[i];
            double kernel = this.mKernelFunction.proximity(inputVector, featureVectors[index]);
            double total = (double)(polarities[i] ? weightSum : -weightSum) * kernel;
            sum += total;
            --i;
        }
        return sum;
    }

    static double power(double base, int exponent) {
        switch (exponent) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return base;
            }
            case 2: {
                return base * base;
            }
            case 3: {
                return base * base * base;
            }
            case 4: {
                return base * base * base * base;
            }
        }
        return Math.pow(base, exponent);
    }

    private Object writeReplace() {
        return new Externalizer(this);
    }

    class CorpusCollector
    implements ObjectHandler<Classified<E>> {
        final List<Vector> mInputFeatureVectorList = new ArrayList<Vector>();
        final List<Boolean> mInputAcceptList = new ArrayList<Boolean>();

        CorpusCollector() {
        }

        @Override
        public void handle(Classified<E> classified) {
            Object object = classified.getObject();
            Classification c = classified.getClassification();
            Map<String, Number> featureMap = PerceptronClassifier.this.mFeatureExtractor.features(object);
            this.mInputFeatureVectorList.add(Features.toVectorAddSymbols(featureMap, PerceptronClassifier.this.mSymbolTable, Integer.MAX_VALUE, false));
            this.mInputAcceptList.add(PerceptronClassifier.this.mAcceptCategory.equals(c.bestCategory()) ? Boolean.TRUE : Boolean.FALSE);
        }

        Vector[] featureVectors() {
            return this.mInputFeatureVectorList.toArray(EMPTY_SPARSE_FLOAT_VECTOR_ARRAY);
        }

        boolean[] polarities() {
            boolean[] categories = new boolean[this.mInputAcceptList.size()];
            int i = 0;
            while (i < categories.length) {
                categories[i] = this.mInputAcceptList.get(i);
                ++i;
            }
            return categories;
        }
    }

    static class Externalizer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -1901362811305741506L;
        final PerceptronClassifier<F> mClassifier;

        public Externalizer() {
            this(null);
        }

        public Externalizer(PerceptronClassifier<F> classifier) {
            this.mClassifier = classifier;
        }

        @Override
        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            FeatureExtractor featureExtractor = (FeatureExtractor)in.readObject();
            KernelFunction kernelFunction = (KernelFunction)in.readObject();
            MapSymbolTable symbolTable = (MapSymbolTable)in.readObject();
            int basisLen = in.readInt();
            Vector[] basisVectors = new Vector[basisLen];
            int i = 0;
            while (i < basisLen) {
                basisVectors[i] = (Vector)in.readObject();
                ++i;
            }
            int[] basisWeights = new int[basisLen];
            int i2 = 0;
            while (i2 < basisLen) {
                basisWeights[i2] = in.readInt();
                ++i2;
            }
            String acceptCategory = in.readUTF();
            String rejectCategory = in.readUTF();
            return new PerceptronClassifier(featureExtractor, kernelFunction, symbolTable, basisVectors, basisWeights, acceptCategory, rejectCategory);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            AbstractExternalizable.compileOrSerialize(this.mClassifier.mFeatureExtractor, out);
            AbstractExternalizable.compileOrSerialize(this.mClassifier.mKernelFunction, out);
            out.writeObject(this.mClassifier.mSymbolTable);
            out.writeInt(this.mClassifier.mBasisVectors.length);
            int i = 0;
            while (i < this.mClassifier.mBasisVectors.length) {
                out.writeObject(this.mClassifier.mBasisVectors[i]);
                ++i;
            }
            i = 0;
            while (i < this.mClassifier.mBasisWeights.length) {
                out.writeInt(this.mClassifier.mBasisWeights[i]);
                ++i;
            }
            out.writeUTF(this.mClassifier.mAcceptCategory);
            out.writeUTF(this.mClassifier.mRejectCategory);
        }
    }
}

