/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.BaseClassifier;
import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.ConfusionMatrix;
import com.aliasi.classify.PrecisionRecallEvaluation;
import com.aliasi.corpus.ObjectHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BaseClassifierEvaluator<E>
implements ObjectHandler<Classified<E>> {
    private final ConfusionMatrix mConfusionMatrix;
    private int mNumCases = 0;
    final String[] mCategories;
    final Set<String> mCategorySet;
    final boolean mStoreInputs;
    BaseClassifier<E> mClassifier;
    final List<Classification> mClassifications = new ArrayList<Classification>();
    final List<E> mCases = new ArrayList();
    final List<String> mReferenceCategories = new ArrayList<String>();

    public BaseClassifierEvaluator(BaseClassifier<E> classifier, String[] categories, boolean storeInputs) {
        this.mClassifier = classifier;
        this.mStoreInputs = storeInputs;
        this.mCategories = categories;
        this.mCategorySet = new HashSet<String>();
        Collections.addAll(this.mCategorySet, categories);
        this.mConfusionMatrix = new ConfusionMatrix(categories);
    }

    public int numCategories() {
        return this.mCategories.length;
    }

    public String[] categories() {
        return (String[])this.mCategories.clone();
    }

    public BaseClassifier<E> classifier() {
        return this.mClassifier;
    }

    public void setClassifier(BaseClassifier<E> classifier) {
        this.setClassifier(classifier, BaseClassifierEvaluator.class);
    }

    public List<Classified<E>> truePositives(String category) {
        return this.caseTypes(category, true, true);
    }

    public List<Classified<E>> falsePositives(String category) {
        return this.caseTypes(category, false, true);
    }

    public List<Classified<E>> falseNegatives(String category) {
        return this.caseTypes(category, true, false);
    }

    public List<Classified<E>> trueNegatives(String category) {
        return this.caseTypes(category, false, false);
    }

    @Override
    public void handle(Classified<E> classified) {
        E input = classified.getObject();
        Classification refClassification = classified.getClassification();
        String refCategory = refClassification.bestCategory();
        this.validateCategory(refCategory);
        Classification classification = this.mClassifier.classify(input);
        this.addClassification(refCategory, classification, input);
    }

    public void addClassification(String referenceCategory, Classification classification, E input) {
        this.addClassificationOld(referenceCategory, classification);
        if (this.mStoreInputs) {
            this.mCases.add(input);
        }
    }

    public int numCases() {
        return this.mNumCases;
    }

    public ConfusionMatrix confusionMatrix() {
        return this.mConfusionMatrix;
    }

    public PrecisionRecallEvaluation oneVersusAll(String refCategory) {
        this.validateCategory(refCategory);
        PrecisionRecallEvaluation prEval = new PrecisionRecallEvaluation();
        int numCases = this.mReferenceCategories.size();
        int i = 0;
        while (i < numCases) {
            String caseRefCategory = this.mReferenceCategories.get(i);
            Classification response = this.mClassifications.get(i);
            String caseResponseCategory = response.bestCategory();
            boolean inRef = caseRefCategory.equals(refCategory);
            boolean inResp = caseResponseCategory.equals(refCategory);
            prEval.addCase(inRef, inResp);
            ++i;
        }
        return prEval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.baseToString(sb);
        sb.append("\nONE VERSUS ALL EVALUATIONS BY CATEGORY\n");
        String[] cats = this.categories();
        int i = 0;
        while (i < cats.length) {
            sb.append("\n\nCATEGORY[" + i + "]=" + cats[i] + " VERSUS ALL\n");
            this.oneVsAllToString(sb, cats[i], i);
            ++i;
        }
        return sb.toString();
    }

    void baseToString(StringBuilder sb) {
        sb.append("BASE CLASSIFIER EVALUATION\n");
        this.mConfusionMatrix.toStringGlobal(sb);
    }

    void oneVsAllToString(StringBuilder sb, String category, int i) {
        sb.append("\nFirst-Best Precision/Recall Evaluation\n");
        sb.append(this.oneVersusAll(category));
        sb.append('\n');
    }

    void setClassifier(BaseClassifier<E> classifier, Class<?> clazz) {
        if (!this.getClass().equals(clazz)) {
            String msg = "Require appropriate classifier type. Evaluator class=" + this.getClass() + " Found classifier.class=" + classifier.getClass();
            throw new IllegalArgumentException(msg);
        }
        this.mClassifier = classifier;
    }

    private List<Classified<E>> caseTypes(String category, boolean refMatch, boolean respMatch) {
        if (!this.mStoreInputs) {
            String msg = "Class must store items to return true positives. Use appropriate constructor flag to store.";
            throw new UnsupportedOperationException(msg);
        }
        ArrayList<Classified<Classified<E>>> result = new ArrayList<Classified<Classified<E>>>();
        int i = 0;
        while (i < this.mReferenceCategories.size()) {
            String refCat = this.mReferenceCategories.get(i);
            Classification c = this.mClassifications.get(i);
            String respCat = c.bestCategory();
            if (category.equals(refCat) == refMatch && category.equals(respCat) == respMatch) {
                Classified<E> classified = new Classified<E>(this.mCases.get(i), c);
                result.add(classified);
            }
            ++i;
        }
        return result;
    }

    private void addClassificationOld(String referenceCategory, Classification classification) {
        this.mConfusionMatrix.increment(referenceCategory, classification.bestCategory());
        this.mReferenceCategories.add(referenceCategory);
        this.mClassifications.add(classification);
        ++this.mNumCases;
    }

    void validateCategory(String category) {
        if (this.mCategorySet.contains(category)) {
            return;
        }
        String msg = "Unknown category=" + category;
        throw new IllegalArgumentException(msg);
    }
}

