/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import java.io.IOException;
import java.io.ObjectInput;

class EstimatorTrie {
    private final int _numNodes;
    private final int[] _nodeSymbol;
    private final int[] _nodeFirstOutcome;
    private final int[] _nodeFirstChild;
    private final float[] _nodeLogOneMinusLambda;
    private final int[] _nodeBackoff;
    private final int _numOutcomes;
    private final int[] _outcomeSymbol;
    private final float[] _outcomeLogEstimate;

    public EstimatorTrie(ObjectInput in) throws IOException {
        this._numNodes = in.readInt();
        this._nodeSymbol = new int[this._numNodes];
        this._nodeFirstOutcome = new int[this._numNodes + 1];
        this._nodeFirstChild = new int[this._numNodes + 1];
        this._nodeLogOneMinusLambda = new float[this._numNodes];
        this._nodeBackoff = new int[this._numNodes];
        int i = 0;
        while (i < this._numNodes) {
            this._nodeSymbol[i] = in.readInt();
            this._nodeFirstOutcome[i] = in.readInt();
            this._nodeFirstChild[i] = in.readInt();
            this._nodeLogOneMinusLambda[i] = in.readFloat();
            this._nodeBackoff[i] = in.readInt();
            ++i;
        }
        this._nodeFirstChild[this._numNodes] = this._numNodes;
        this._nodeFirstOutcome[this._numNodes] = this._numOutcomes = in.readInt();
        this._outcomeSymbol = new int[this._numOutcomes];
        this._outcomeLogEstimate = new float[this._numOutcomes];
        i = 0;
        while (i < this._numOutcomes) {
            this._outcomeSymbol[i] = in.readInt();
            this._outcomeLogEstimate[i] = in.readFloat();
            ++i;
        }
    }

    public double estimateFromNode(int symbolID, int nodeIndex) {
        if (symbolID < 0) {
            return Double.NaN;
        }
        double backoffAccumulator = 0.0;
        int currentNodeIndex = nodeIndex;
        while (currentNodeIndex >= 0) {
            int low = this._nodeFirstOutcome[currentNodeIndex];
            int high = this._nodeFirstOutcome[currentNodeIndex + 1] - 1;
            while (low <= high) {
                int mid = (high + low) / 2;
                if (this._outcomeSymbol[mid] == symbolID) {
                    return backoffAccumulator + (double)this._outcomeLogEstimate[mid];
                }
                if (this._outcomeSymbol[mid] < symbolID) {
                    low = low == mid ? mid + 1 : mid;
                    continue;
                }
                int n = high = high == mid ? mid - 1 : mid;
            }
            backoffAccumulator += (double)this._nodeLogOneMinusLambda[currentNodeIndex];
            currentNodeIndex = this._nodeBackoff[currentNodeIndex];
        }
        return Double.NaN;
    }

    public double estimateFromNodeUniform(int symbolID, int nodeIndex, double uniformEstimate) {
        if (symbolID < 0) {
            return Double.NaN;
        }
        double backoffAccumulator = 0.0;
        int currentNodeIndex = nodeIndex;
        while (currentNodeIndex >= 0) {
            int low = this._nodeFirstOutcome[currentNodeIndex];
            int high = this._nodeFirstOutcome[currentNodeIndex + 1] - 1;
            while (low <= high) {
                int mid = (high + low) / 2;
                if (this._outcomeSymbol[mid] == symbolID) {
                    return backoffAccumulator + (double)this._outcomeLogEstimate[mid];
                }
                if (this._outcomeSymbol[mid] < symbolID) {
                    low = low == mid ? mid + 1 : mid;
                    continue;
                }
                int n = high = high == mid ? mid - 1 : mid;
            }
            backoffAccumulator += (double)this._nodeLogOneMinusLambda[currentNodeIndex];
            currentNodeIndex = this._nodeBackoff[currentNodeIndex];
        }
        return backoffAccumulator + uniformEstimate;
    }

    /*
     * Unable to fully structure code
     */
    public int lookupChild(int symbolID, int parentNodeIndex) {
        low = this._nodeFirstChild[parentNodeIndex];
        high = this._nodeFirstChild[parentNodeIndex + 1] - 1;
        if (symbolID >= 0) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            mid = (high + low) / 2;
            if (this._nodeSymbol[mid] == symbolID) {
                return mid;
            }
            if (this._nodeSymbol[mid] < symbolID) {
                low = low == mid ? mid + 1 : mid;
                continue;
            }
            v0 = high = high == mid ? mid - 1 : mid;
lbl12:
            // 3 sources

            ** while (low <= high)
        }
lbl13:
        // 1 sources

        return -1;
    }
}

