/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import relations.RuleData;

public class Rules {
    int event_type = 0;
    String trigger;
    Map<String, RuleData> map = new HashMap<String, RuleData>();
    Map<String, List<RuleData>> data = new HashMap<String, List<RuleData>>();
    boolean init = false;
    int rcount = 0;
    double[] conf = new double[]{0.03, 0.03, 0.03, 0.03, 0.03, 0.02, 0.03, 0.03, 0.03};
    double skip_value = this.conf[this.event_type];

    public Rules(int type, String trg) {
        this.event_type = type;
        this.trigger = trg;
    }

    public void initMap() {
        List<RuleData> item;
        if (this.init) {
            return;
        }
        for (String s : this.map.keySet()) {
            RuleData p = this.map.get(s);
            String key = p.POS + p.chunk_type;
            item = this.data.get(key);
            if (item == null) {
                item = new ArrayList<RuleData>();
                item.add(p);
                this.data.put(key, item);
                continue;
            }
            item.add(p);
        }
        for (String s : this.data.keySet()) {
            item = this.data.get(s);
            Collections.sort(item);
        }
        this.init = true;
    }

    public void addPattern(int verb_type, String pos, String ctype, boolean pos1, String pr1, boolean inchunk, int ccount, String childTrg, boolean add) {
        RuleData p = new RuleData(verb_type, pos, ctype, pos1, pr1, inchunk, ccount, childTrg);
        String txt = p.getKey();
        if (!this.map.containsKey(txt)) {
            this.map.put(p.getKey(), p);
        } else {
            p = this.map.get(txt);
            if (add) {
                ++p.count;
            }
            if (p.dist1 < ccount) {
                p.dist1 = ccount;
            }
        }
        ++this.rcount;
        if (!childTrg.isEmpty() && childTrg.length() >= 3) {
            p.childMap.add(childTrg);
        }
    }

    public void addPattern(int verb_type, String pos, String ctype, boolean pos1, boolean pos2, boolean order, String pr1, String pr2, boolean has_theme2, boolean inchunk, int ccount1, int ccount2, String childTrg, boolean add) {
        RuleData p = new RuleData(verb_type, pos, ctype, pos1, pos2, order, pr1, pr2, has_theme2, inchunk, ccount1, ccount2, childTrg);
        String txt = p.getKey();
        if (!this.map.containsKey(txt)) {
            this.map.put(p.getKey(), p);
        } else {
            p = this.map.get(txt);
            if (add) {
                ++p.count;
            }
            if (p.dist1 < ccount1) {
                p.dist1 = ccount1;
            }
            if (p.dist2 < ccount2) {
                p.dist2 = ccount2;
            }
        }
        ++this.rcount;
        if (!childTrg.isEmpty() && childTrg.length() >= 3) {
            p.childMap.add(childTrg);
        }
    }

    public void addPattern(int verb_type, String pos, String ctype, boolean pos1, boolean pos2, boolean order, String pr1, String pr2, boolean has_theme2, boolean inchunk, int ccount1, int ccount2, boolean ev1, boolean ev2, String trg1, String trg2, boolean add) {
        RuleData p = new RuleData(verb_type, pos, ctype, pos1, pos2, order, pr1, pr2, has_theme2, inchunk, ccount1, ccount2, ev1, ev2, trg1, trg2);
        String txt = p.getKey();
        if (!this.map.containsKey(txt)) {
            this.map.put(p.getKey(), p);
        } else {
            p = this.map.get(txt);
            if (add) {
                ++p.count;
            }
            if (p.dist1 < ccount1) {
                p.dist1 = ccount1;
            }
            if (p.dist2 < ccount2) {
                p.dist2 = ccount2;
            }
            if (!trg1.isEmpty()) {
                p.childMap.add(trg1);
            }
            if (!trg2.isEmpty()) {
                p.parentMap.add(trg2);
            }
        }
        ++this.rcount;
    }

    public List<RuleData> getEvalRules(String key) {
        if (!this.init) {
            this.initMap();
        }
        List<RuleData> rs = this.data.get(key);
        return rs;
    }

    public void printInfo() {
        System.out.println("Trigger: " + this.trigger + " number of patterns: " + this.map.size() + " number of events: " + this.rcount);
        if (!this.init) {
            this.initMap();
        }
        for (String s : this.data.keySet()) {
            List<RuleData> p = this.data.get(s);
            if (p.size() <= 0) continue;
            for (RuleData dt : p) {
                System.out.println(dt.getKeyInfo());
            }
        }
    }

    public String toString() {
        return this.trigger + " " + this.map.size();
    }
}

