/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.util.ArrayList;
import java.util.List;
import relations.BasicChunk;
import relations.Word;

public class Chunk {
    public String type = null;
    public String txt = null;
    public List<Word> pros = new ArrayList<Word>();
    public List<Word> trigs = new ArrayList<Word>();
    public int begin = 0;
    public int end = 0;
    public boolean is_merged = false;
    public List<Word> cause = new ArrayList<Word>();

    public Chunk(String type) {
        this.type = type;
    }

    public void addWord(String w) {
        this.txt = this.txt == null ? w : this.txt + " " + w;
    }

    public void addPro(Word pr) {
        this.pros.add(pr);
    }

    public void addTrigger(Word trg) {
        this.trigs.add(trg);
    }

    public String getType() {
        return this.type;
    }

    public String getText() {
        return this.txt;
    }

    public void merge(Chunk c) {
        this.end = c.end;
        this.pros.addAll(c.pros);
        this.trigs.addAll(c.trigs);
        this.txt = this.txt + " " + c.txt;
    }

    public void removeTRG(Word tg) {
        this.trigs.remove(tg);
    }

    public void removePRO(Word pro) {
        this.pros.remove(pro);
    }

    public void removePro(int pos) {
        Word pr = null;
        for (Word w : this.pros) {
            if (w.pos != pos) continue;
            pr = w;
            break;
        }
        if (pr != null) {
            this.pros.remove(pr);
            this.cause.add(pr);
        }
    }

    public boolean isQualify() {
        return this.pros.size() > 0 && this.trigs.size() > 0;
    }

    public boolean contains(Word key) {
        return key.pos >= this.begin && key.pos <= this.end;
    }

    public boolean inChunkTG(Word tg1, Word tg2) {
        if (this.contains(tg1) && this.contains(tg2)) {
            int pos1 = Math.min(tg1.pos, tg2.pos);
            int pos2 = Math.max(tg1.pos, tg2.pos);
            for (Word pr : this.pros) {
                if (pr.pos <= pos1 || pr.pos >= pos2) continue;
                return false;
            }
            if (pos1 != pos2) {
                return true;
            }
        }
        return false;
    }

    public boolean inChunk(Word trg, Word pro) {
        if (this.contains(trg) && this.contains(pro) && pro.pos <= trg.pos) {
            if (!pro.combined && !trg.combined) {
                return true;
            }
            if (pro.pos == trg.pos) {
                return true;
            }
        }
        return false;
    }

    public boolean inChunk(Word trg, Word pro, String[] tokens) {
        if (!(trg.pos != this.end || trg.compound || trg.combined || trg.pos >= tokens.length - 1 || !tokens[trg.pos + 1].equals("of") || this.end - this.begin <= 2 && this.pros.size() == 1)) {
            return false;
        }
        if (this.contains(trg) && this.contains(pro) && pro.pos <= trg.pos) {
            if (this.pros.size() == 1) {
                if (!this.hasConj(trg.pos, tokens)) {
                    if (!pro.combined && !trg.combined) {
                        return true;
                    }
                    if (pro.pos == trg.pos) {
                        return true;
                    }
                }
            } else {
                Word pr = this.pros.get(this.pros.size() - 1);
                if (pr.pos < trg.pos && !this.hasConj(trg.pos, tokens) && pro.pos <= pr.pos) {
                    if (!pro.combined && !trg.combined) {
                        return true;
                    }
                    if (pro.pos == trg.pos) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean hasConj(int pos, String[] tokens) {
        return pos > 0 && pos < tokens.length && BasicChunk.ccMap.contains(tokens[pos - 1]);
    }

    public boolean is_inChunk(Word trg, String[] tokens) {
        if (this.contains(trg) && this.pros.size() > 0) {
            int idx = this.trigs.indexOf(trg);
            int pos = this.begin;
            int pcount = 0;
            if (!(trg.pos != this.end || trg.compound || trg.combined || trg.pos >= tokens.length - 1 || !tokens[trg.pos + 1].equals("of") || this.pros.size() == 1 && trg.pos - this.pros.get((int)(this.pros.size() - 1)).pos < 3)) {
                return false;
            }
            if (trg.combined) {
                for (Word pr : this.pros) {
                    if (pr.pos != trg.pos) continue;
                    trg.inchunk = true;
                    return true;
                }
            }
            if (idx > 0) {
                pos = this.getStartPos(trg, tokens);
            }
            for (Word pr : this.pros) {
                if (pr.pos > trg.pos || pr.pos < pos || pr.combined) continue;
                ++pcount;
            }
            if (pcount > 0 && !this.hasConj(trg.pos, tokens)) {
                trg.inchunk = true;
                return true;
            }
        }
        return false;
    }

    private int getStartPos(Word tg, String[] tokens) {
        for (int pos = this.trigs.indexOf(tg); pos > 0; --pos) {
            Word tg1 = this.trigs.get(pos - 1);
            if (this.isSameRole(tg1, tg, tokens)) continue;
            return tg1.pos + 1;
        }
        return this.begin;
    }

    private int getEndPos(Word tg, String[] tokens) {
        for (int pos = this.trigs.indexOf(tg) + 1; pos < this.trigs.size(); ++pos) {
            Word tg1 = this.trigs.get(pos);
            if (this.isSameRole(tg1, tg, tokens)) continue;
            return tg1.pos - 1;
        }
        return this.end;
    }

    public boolean isSameRole(Word tg1, Word tg2, String[] tokens) {
        if (tg1.pos_tag.equals(tg2.pos_tag)) {
            int pos1 = Math.min(tg1.pos, tg2.pos);
            int pos2 = Math.max(tg1.pos, tg2.pos);
            for (int i = pos1 + 1; i < pos2; ++i) {
                if (!BasicChunk.ccMap.contains(tokens[i])) continue;
                return true;
            }
        }
        return false;
    }

    public List<Word> getInChunkPro(Word tg, String[] tokens) {
        ArrayList<Word> ls = new ArrayList<Word>();
        if (this.contains(tg) && this.pros.size() > 0 && tg.inchunk) {
            if (tg.combined) {
                for (Word w : this.pros) {
                    if (w.pos != tg.pos) continue;
                    ls.add(w);
                    return ls;
                }
            }
            int idx = this.getStartPos(tg, tokens);
            for (Word w : this.pros) {
                if (w.combined || w.pos >= tg.pos || w.pos < idx) continue;
                ls.add(w);
            }
        }
        return ls;
    }

    public List<Word> getPro(String[] tokens) {
        ArrayList<Word> ls = new ArrayList<Word>();
        int pos1 = this.begin;
        int pos2 = this.end;
        if (this.pros.size() > 0 && (this.is_merged || this.trigs.isEmpty())) {
            return this.pros;
        }
        if (this.trigs.size() > 0 && this.pros.size() > 0) {
            for (int i = 0; i < this.trigs.size(); ++i) {
                Word tg = this.trigs.get(i);
                if (tg.inchunk) {
                    pos1 = tg.pos + 1;
                    continue;
                }
                pos2 = tg.pos - 1;
                break;
            }
            for (Word w : this.pros) {
                if (w.pos < pos1 || w.pos > pos2) continue;
                ls.add(w);
            }
        }
        return ls;
    }

    public List<Word> getProFront() {
        ArrayList<Word> ls = new ArrayList<Word>();
        if (this.pros.size() > 0 && (this.is_merged || this.trigs.isEmpty())) {
            return this.pros;
        }
        return ls;
    }

    public List<Word> getPro(Word tg, String[] tokens) {
        ArrayList<Word> ls = new ArrayList<Word>();
        int pos = Math.max(this.begin, tg.pos);
        int idx = this.end;
        if (this.contains(tg) && this.pros.size() > 0) {
            int pos1 = this.trigs.indexOf(tg);
            if (this.trigs.size() == 1 || pos1 == this.trigs.size() - 1) {
                for (Word pr : this.pros) {
                    if (pr.pos <= pos || pr.pos > idx || pr.combined) continue;
                    ls.add(pr);
                }
            } else if (pos1 < this.trigs.size() - 1) {
                return ls;
            }
            return ls;
        }
        return ls;
    }

    public String getValues() {
        String st = "[" + this.type + " " + this.txt;
        if (this.pros.size() > 0) {
            st = st + " >>PRO: ";
            for (Word w : this.pros) {
                st = st + " " + w.word;
            }
        }
        if (this.trigs.size() > 0) {
            st = st + " >>TRG ";
            for (Word w : this.trigs) {
                st = st + " " + w.word + "_" + w.pos_tag;
            }
        }
        st = st + "]";
        return st;
    }

    public String toString() {
        String text = "[" + this.type + " " + this.txt + "]";
        return text;
    }
}

