/*
 * Decompiled with CFR 0.152.
 */
package application;

import corpora.DataLoader;
import java.util.ArrayList;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import relations.EventExtraction;
import relations.RuleLearner;
import relations.TriggerLearner;
import utils.DBUtils;

public class BioSemApplication {
    static final String PATH_DELIM = System.getProperty("file.separator");
    static final String NEWLINE = System.getProperty("line.separator");
    static final ArrayList<String> SET_NAMES = new ArrayList<String>(){
        {
            this.add("train");
            this.add("test");
            this.add("devel");
        }
    };
    private static String input_root;
    private static String db_root;
    private static String modus;
    private static String set;
    private static String destination;

    private void readCommandLineArgs(String[] args) {
        BasicParser cmd = new BasicParser();
        CommandLine paramParser = null;
        Options options = new Options();
        options.addOption("i", "input", true, "input folder");
        options.addOption("o", "output", true, "database folder");
        options.addOption("m", "modus", true, "step of BioSEM Extractor");
        options.addOption("s", "set", true, "what set");
        options.addOption("d", "destination", true, "destination");
        options.addOption("x", "mix", false, "whether to use mix set");
        try {
            String mix;
            paramParser = cmd.parse(options, args);
            String param = paramParser.getOptionValue("m");
            if (param != null) {
                modus = param;
                if (!(this.getModus().equalsIgnoreCase("complete") || this.getModus().equalsIgnoreCase("data-preparation") || this.getModus().equalsIgnoreCase("trigger-learn") || this.getModus().equalsIgnoreCase("pattern-learn") || this.getModus().equalsIgnoreCase("event-extraction"))) {
                    System.out.println("Modus \"" + this.getModus() + "\" is not known. Aborting.");
                    System.exit(-1);
                }
                System.out.println("Modus: " + this.getModus());
            } else {
                modus = "complete";
                System.out.println("No modus specified; using default." + NEWLINE + "Modus: \"complete\".");
            }
            param = paramParser.getOptionValue("i");
            if (param != null) {
                input_root = param;
                System.out.println("Input: " + this.getInput_root());
            } else {
                System.out.println("Specify input directory root (-i). Aborting.");
                System.exit(-1);
            }
            param = paramParser.getOptionValue("o");
            if (param != null) {
                db_root = param;
                System.out.println("Database-Root: " + this.getDb_root());
            } else {
                System.out.println("Specify output database directory (-o). Aborting.");
            }
            param = paramParser.getOptionValue("s");
            if (param != null) {
                set = param;
                if (!(this.getSet().equalsIgnoreCase("train") || this.getSet().equalsIgnoreCase("test") || this.getSet().equalsIgnoreCase("devel") || this.getSet().equalsIgnoreCase("mix"))) {
                    System.out.println(NEWLINE + "A specific set needs to be declared (-s). \"" + this.getSet() + "\" is no valid set; choose: \"train\",\"test\", \"devel\" or \"mix\". Aborting.");
                    System.exit(-1);
                }
                if (this.getSet().equalsIgnoreCase("mix")) {
                    SET_NAMES.add("mix");
                    System.out.println(NEWLINE + "\"mix\" option was not set but declared in set-option; added automatically.");
                }
            } else if (!this.getModus().equalsIgnoreCase("complete")) {
                System.out.println(NEWLINE + "A specific set needs to be declared (-s); choose: \"train\",\"test\", \"devel\" or \"mix\". Aborting.");
                System.exit(-1);
            }
            if ((param = paramParser.getOptionValue("x")) != null && (mix = param).equalsIgnoreCase("true")) {
                SET_NAMES.add("mix");
            }
            if ((param = paramParser.getOptionValue("d")) != null) {
                destination = param;
                if (!SET_NAMES.contains(this.getDestination().toLowerCase())) {
                    System.out.println(NEWLINE + "\"" + this.getDestination() + "\" is no valid destination; choose: \"train\", \"test\", \"devel\" or \"mix\" (if mix option is set to \"true\"). Aborting.");
                    System.exit(-1);
                } else if (this.getDestination().equalsIgnoreCase("mix")) {
                    SET_NAMES.add("mix");
                    System.out.println(NEWLINE + "\"mix\" option was not set but declared in destination-option; added automatically.");
                }
            } else if (!this.getModus().equalsIgnoreCase("data-preparation")) {
                System.out.println(NEWLINE + "For modes other than \"data-preparation\" there needs to be a destination database declared (-d). Aborting.");
                System.exit(-1);
            }
        }
        catch (ParseException e) {
            System.out.println((Object)e);
        }
    }

    private void loadData(String set) {
        DataLoader data = new DataLoader();
        boolean a2 = true;
        if (set.equalsIgnoreCase("test")) {
            a2 = false;
        }
        data.Txt2Db(this.getInput_root() + PATH_DELIM + set, this.getDb_root() + PATH_DELIM + set, a2);
    }

    private void learnTrigger(String src, String dest) {
        String dbsr = this.getDb_root() + PATH_DELIM + src;
        DBUtils dbsrc = new DBUtils();
        dbsrc.openDB(dbsr);
        String dbname = this.getDb_root() + PATH_DELIM + dest;
        DBUtils dbdest = new DBUtils();
        dbdest.openDB(dbname);
        TriggerLearner learner = new TriggerLearner(dbsrc, dbdest);
        learner.createTriggers();
        dbdest.shutdownDB();
        if (!src.equals(dest)) {
            dbsrc.closeDB();
        }
    }

    private void learnRules(String src, String dest) {
        String dbsr = this.getDb_root() + PATH_DELIM + src;
        DBUtils dbsrc = new DBUtils();
        dbsrc.openDB(dbsr);
        String dbname = this.getDb_root() + PATH_DELIM + dest;
        DBUtils dbdest = new DBUtils();
        dbdest.openDB(dbname);
        RuleLearner learner = new RuleLearner(dbsrc, dbdest);
        learner.LearnData();
        dbsrc.shutdownDB();
        if (!src.equals(dest)) {
            dbdest.shutdownDB();
        }
    }

    private void extractEvents(String src, String dest) {
        String sr_path = this.getDb_root() + PATH_DELIM + src;
        DBUtils sr = new DBUtils();
        sr.openDB(sr_path);
        String dest_path = this.getDb_root() + PATH_DELIM + dest;
        DBUtils des = new DBUtils();
        des.openDB(dest_path);
        EventExtraction xtr = new EventExtraction(sr, des);
        xtr.Test(this.getDb_root() + PATH_DELIM + "results" + PATH_DELIM + this.getDestination());
        sr.closeDB();
        if (!src.equals(dest)) {
            des.closeDB();
        }
    }

    public static void main(String[] args) {
        BioSemApplication app = new BioSemApplication();
        app.readCommandLineArgs(args);
        if (modus.equalsIgnoreCase("data-preparation")) {
            app.loadData(set);
        }
        if (modus.equalsIgnoreCase("trigger-learn")) {
            app.learnTrigger(set, destination);
        }
        if (modus.equalsIgnoreCase("pattern-learn")) {
            app.learnRules(set, destination);
        }
        if (modus.equalsIgnoreCase("event-extraction")) {
            app.extractEvents(set, destination);
        }
        if (modus.equalsIgnoreCase("complete")) {
            for (String s : SET_NAMES) {
                if (!s.equalsIgnoreCase(app.getSet()) && !s.equalsIgnoreCase(app.getDestination())) continue;
                System.out.println(NEWLINE + "[Loading " + s + "-set]");
                app.loadData(s);
            }
            System.out.println(NEWLINE);
            app.learnTrigger(set, set);
            System.out.println(NEWLINE);
            app.learnRules(set, set);
            System.out.println(NEWLINE);
            app.extractEvents(set, destination);
        }
        System.out.println(NEWLINE + "DONE PROCESSING");
    }

    public String getInput_root() {
        return input_root;
    }

    public String getDb_root() {
        return db_root;
    }

    public String getModus() {
        return modus;
    }

    public String getSet() {
        return set;
    }

    public String getDestination() {
        return destination;
    }
}

