/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import relations.Counter;
import relations.EData;
import relations.KeyData;
import relations.SenAnalyzer;
import relations.SenSimplifier;
import relations.TData;
import relations.Word;
import utils.DBUtils;

public class TriggerLearner {
    Map<String, Counter>[] maptype = new HashMap[trigger_type.length];
    DBUtils db_sr;
    DBUtils db_dest;
    Connection con;
    Statement stmt;
    ResultSet rs;
    PreparedStatement ps;
    SenSimplifier sim;
    int nr_event = 9;
    public List<Word> proWord = new ArrayList<Word>();
    public List<Word> prepWord = new ArrayList<Word>();
    public List<Word> relWords = new ArrayList<Word>();
    int fthreshold = 2;
    Map<String, String> tmap = new HashMap<String, String>();
    Map<String, TData> mprotein = new HashMap<String, TData>();
    Map<String, TData> mtrigger = new HashMap<String, TData>();
    Map<String, EData> mevent = new HashMap<String, EData>();
    List<TData> plist;
    List<TData> tlist;
    List<EData> elist;
    String simp;
    String[] simpsen;
    String[] longsen;
    TData tgr;
    TData prt;
    int[] simp_pos;
    int[] full_pos;
    int split_count = 0;
    public static String[] trigger_type = new String[]{"Gene_expression", "Transcription", "Protein_catabolism", "Phosphorylation", "Localization", "Binding", "Positive_regulation", "Regulation", "Negative_regulation", "Ubiquitination", "Protein_modification", "Deacetylation", "Acetylation"};
    int[] score = new int[trigger_type.length];
    Map<String, Integer> hashType = new HashMap<String, Integer>();
    Map<String, String> notrigger = new HashMap<String, String>();
    public static final String[] none_rel = new String[]{"over", "when", "by", "via", "after", "high", "lower", "under", "transcripts", "transcript", "upon", "poor", "potent", "in", "low", "through", "a", "the", "are", "is", "was", "for", "into", "not", "it", "that", "level", "levels", "negative", "higher", "low", "because", "due", "to", "with", "without", "at", "from", "more", "pair", "both", "and", "on", "inhibitor", "inhibitors", "receptors", "receptor", "complex", "complexes", "transcriptional", "heterodimers", "heterodimer", "homodimer", "during", "crucial", "failed", "exist", "critical", "of", "due to", "because of", "by", "an", "of", "positive", "mrna", "mrnas"};

    public TriggerLearner(DBUtils sr, DBUtils dbs) {
        int i;
        this.db_sr = sr;
        this.db_dest = dbs;
        try {
            this.con = this.db_sr.getConnection();
            this.stmt = this.con.createStatement();
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
        for (i = 0; i < trigger_type.length; ++i) {
            this.hashType.put(trigger_type[i], i);
        }
        for (i = 0; i < none_rel.length; ++i) {
            this.notrigger.put(none_rel[i], none_rel[i]);
        }
        this.sim = new SenSimplifier(this.db_sr);
    }

    public void clearList() {
        this.proWord.clear();
        this.prepWord.clear();
        this.relWords.clear();
    }

    public void preparedData() {
        String sql = "select t_type,txt, count(txt) as num from (select event.t_type, triggers.txt from event, triggers where event.PMID = triggers.PMID and event.TRIG_ID = triggers.TID) group by t_type,txt order by num desc";
        int len = trigger_type.length;
        ArrayList<String> keylist = new ArrayList<String>();
        HashMap<String, String> mapkey = new HashMap<String, String>();
        try {
            System.out.println("Creating trigger list .....");
            this.stmt.execute("DROP TABLE trigdata if exists");
            this.stmt.execute("CREATE CACHED TABLE TRIGDATA(KEY VARCHAR(80), expr INT, trans INT , catabo int, phospho INT, local INT, bind int, pos_reg int, reg int, neg_reg int, ubi int, prot_mod int, deacet int, acet int, tt int) ");
            this.ps = this.con.prepareStatement("insert into trigdata(key,expr,trans,catabo,phospho,local,bind,pos_reg,reg,neg_reg,ubi,prot_mod,deacet,acet,tt) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            for (int i = 0; i < len; ++i) {
                this.maptype[i] = new HashMap<String, Counter>();
            }
            this.rs = this.stmt.executeQuery(sql);
            while (this.rs.next()) {
                String t_type = this.rs.getString(1);
                int idx = SenSimplifier.hashType.get(t_type);
                Map<String, Counter> item = this.maptype[idx];
                String txt = this.rs.getString(2).toLowerCase();
                if (this.notrigger.containsKey(txt)) continue;
                int count = this.rs.getInt(3);
                if (!item.containsKey(txt)) {
                    item.put(txt, new Counter(count));
                } else {
                    Counter c = item.get(txt);
                    c.add(count);
                }
                if (mapkey.containsKey(txt)) continue;
                mapkey.put(txt, txt);
                keylist.add(txt);
            }
            this.rs.close();
            Map<String, Counter>[] array = this.maptype;
            int[] data = new int[len];
            for (String s : keylist) {
                for (int i = 0; i < len; ++i) {
                    data[i] = 0;
                    if (!array[i].containsKey(s)) continue;
                    data[i] = array[i].get(s).getValue();
                }
                this.saveData(s, data);
            }
            this.ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Integer> getType(int[] data) {
        int i;
        int freq = this.fthreshold;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < 9; ++i) {
            if (data[i] < freq) continue;
            list.add(i);
        }
        if (list.size() == 1) {
            return list;
        }
        i = 0;
        while (i < list.size()) {
            int idx = (Integer)list.get(i);
            if (data[idx] < freq + 3) {
                list.remove(i);
                continue;
            }
            ++i;
        }
        return list;
    }

    private void saveKeyData(Map<String, KeyData> map) {
        String sql = " Insert into keydata(key,ktype,type,freq,total, pcount, ecount,pcause,ecause,t2count,child, parent) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        System.out.println("Saving trigger data..........");
        try {
            System.out.println("---> Saving dictionary, number of entries: " + map.size());
            Connection con1 = this.db_dest.getConnection();
            Statement stmt1 = con1.createStatement();
            stmt1.execute("DROP TABLE keydata if exists");
            stmt1.execute(" Create cached table KEYDATA(key varchar(80), ktype int, type varchar(50), freq int, total int, pcount int,ecount int, pcause int, ecause int, t2count int,child varchar(2000), parent varchar(2000))");
            PreparedStatement ps1 = con1.prepareStatement(sql);
            ArrayList<KeyData> ls = new ArrayList<KeyData>();
            for (String s : map.keySet()) {
                KeyData dt = map.get(s);
                int total = dt.found;
                if (total < this.fthreshold) continue;
                ls.clear();
                if (dt.keytype == 1) {
                    ls.add(dt);
                } else {
                    ls.addAll(dt.getMap().values());
                }
                for (KeyData k : ls) {
                    ps1.setString(1, k.key);
                    ps1.setInt(2, k.keytype);
                    ps1.setString(3, k.type);
                    ps1.setInt(4, k.freq);
                    ps1.setInt(5, total);
                    ps1.setInt(6, k.pcount);
                    ps1.setInt(7, k.ecount);
                    ps1.setInt(8, k.pcause);
                    ps1.setInt(9, k.ecause);
                    ps1.setInt(10, k.t2count);
                    ps1.setString(11, k.set2String(k.child));
                    ps1.setString(12, k.set2String(k.parent));
                    ps1.executeUpdate();
                }
            }
            ps1.close();
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
        System.out.println("Saving trigger data... done!");
    }

    public void createTriggers() {
        this.preparedData();
        this.generateKeyData();
    }

    public static void main(String[] args) {
        String dbsr = "D:/DataNLP/Mix2011/Data";
        DBUtils dbsrc = new DBUtils();
        dbsrc.openDB(dbsr);
        String dbname = "D:/DataNLP/Dev2011/Data";
        DBUtils dbdest = new DBUtils();
        dbdest.openDB(dbname);
        TriggerLearner learner = new TriggerLearner(dbsrc, dbdest);
        learner.createTriggers();
        dbdest.shutdownDB();
    }

    private void saveData(String key, int[] data) {
        int len = trigger_type.length;
        int[] sc = new int[len];
        int sum = 0;
        try {
            int i;
            for (i = 0; i < len; ++i) {
                sc[i] = data[i];
                int n = i;
                this.score[n] = this.score[n] + sc[i];
                sum += sc[i];
            }
            if (sum <= this.fthreshold) {
                return;
            }
            this.ps.setString(1, key);
            for (i = 0; i < len; ++i) {
                this.ps.setInt(i + 2, sc[i]);
            }
            this.ps.setInt(len + 2, sum);
            this.ps.executeUpdate();
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
    }

    public boolean initEventData(String pid) {
        this.plist = this.sim.loadProtein(pid);
        this.tlist = this.sim.loadTrigger(pid);
        this.elist = this.sim.loadEvent(pid);
        this.mprotein.clear();
        for (TData dt : this.plist) {
            this.mprotein.put(dt.tid, dt);
        }
        this.mtrigger.clear();
        for (TData dt : this.tlist) {
            this.mtrigger.put(dt.tid, dt);
        }
        this.mevent.clear();
        for (EData edt : this.elist) {
            this.mevent.put(edt.eid, edt);
        }
        for (EData ed : this.elist) {
            ed.init(this.mprotein, this.mtrigger, this.mevent);
        }
        return true;
    }

    private boolean inSentence(int begin, int end, EData ev) {
        boolean theme = false;
        boolean cause = false;
        TData tg = ev.trgdata;
        if (tg.list[0] >= begin && tg.list[1] <= end) {
            TData pr2;
            if (ev.data1 instanceof TData) {
                TData pr1 = (TData)ev.data1;
                if (pr1.list[0] >= begin && pr1.list[1] <= end) {
                    theme = true;
                }
            } else {
                EData ev1 = (EData)ev.data1;
                theme = this.inSentence(begin, end, ev1);
            }
            if (ev.ecause != null) {
                if (ev.ecause instanceof EData) {
                    cause = this.inSentence(begin, end, (EData)ev.ecause);
                } else {
                    pr2 = (TData)ev.ecause;
                    if (pr2.list[0] >= begin && pr2.list[1] <= end) {
                        cause = true;
                    }
                }
            } else if (ev.data2 != null) {
                pr2 = ev.data2;
                if (pr2.list[0] >= begin && pr2.list[1] <= end) {
                    cause = true;
                }
            } else {
                cause = true;
            }
            if (theme && cause) {
                return true;
            }
        }
        return false;
    }

    private String getKey(String tg, Set<String> dic) {
        if (dic.contains(tg)) {
            return tg;
        }
        String[] txt = tg.split(" ");
        for (int i = txt.length - 1; i >= 0; --i) {
            if (!dic.contains(txt[i])) continue;
            return txt[i];
        }
        return null;
    }

    public void generateKeyData() {
        int ev_type = 0;
        List<String> pmids = this.sim.loadPMIDs();
        this.sim.loadSimpleDic();
        SenAnalyzer analyzer = new SenAnalyzer(this.sim);
        HashMap[] allTrg = new HashMap[trigger_type.length];
        HashMap<String, int[]> keys = new HashMap<String, int[]>();
        for (int i = 0; i < trigger_type.length; ++i) {
            allTrg[i] = new HashMap();
        }
        HashMap<String, Counter> sharedTrg = new HashMap<String, Counter>();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        Set<String> dict = this.sim.simpleDic;
        HashMap<TData, TData> usedTG = new HashMap<TData, TData>();
        try {
            TriggerData tgdt;
            int[] counter;
            System.out.println("Generating trigger related data.....");
            for (String id : pmids) {
                if (!analyzer.initData(id)) continue;
                this.initEventData(id);
                List<EData>[] events = analyzer.splitEvents(this.elist);
                for (int i = 0; i < analyzer.shortsen.length; ++i) {
                    tempMap.clear();
                    usedTG.clear();
                    int sen_begin = analyzer.senpos[i];
                    int sen_end = analyzer.senpos[i] + analyzer.longsen[i].length();
                    for (EData eData : events[i]) {
                        TData tg2;
                        EData obj;
                        String[] ww;
                        ev_type = this.hashType.get(eData.type);
                        if (!this.inSentence(sen_begin, sen_end, eData)) continue;
                        TData tg = eData.getTrigger();
                        Object data1 = eData.data1;
                        String tg_value = tg.name.toLowerCase();
                        if (tg_value.contains("-") && tg_value.length() > 8 && (ww = tg_value.split("-")).length == 2 && dict.contains(ww[0] + ww[1])) {
                            tg_value = ww[0] + ww[1];
                        }
                        if (!dict.contains(tg_value) || usedTG.containsKey(tg)) continue;
                        usedTG.put(tg, tg);
                        String tg_key = tg_value + tg.list[0] + "" + tg.list[1];
                        if (!tempMap.containsKey(tg_key)) {
                            tempMap.put(tg_key, eData.type);
                        } else {
                            String old_type = (String)tempMap.get(tg_key);
                            if (!old_type.equals(eData.type)) {
                                Counter c = (Counter)sharedTrg.get(tg_value);
                                if (c == null) {
                                    c = new Counter(1);
                                    sharedTrg.put(tg_value, c);
                                } else {
                                    c.inc();
                                }
                            }
                        }
                        counter = (int[])keys.get(tg_value);
                        if (counter == null) {
                            counter = new int[trigger_type.length + 1];
                            keys.put(tg_value, counter);
                        }
                        int n = ev_type;
                        counter[n] = counter[n] + 1;
                        tgdt = (TriggerData)allTrg[ev_type].get(tg_value);
                        if (tgdt == null) {
                            tgdt = new TriggerData(tg_value, tg.type);
                            allTrg[ev_type].put(tg_value, tgdt);
                        }
                        if (data1 instanceof TData) {
                            ++tgdt.pcount;
                        } else {
                            ++tgdt.ecount;
                            obj = (EData)data1;
                            int idx = this.hashType.get(obj.type);
                            tg2 = obj.getTrigger();
                            String tg2_value = tg2.name.toLowerCase();
                            if (dict.contains(tg2_value)) {
                                tgdt.child[idx].add(tg2_value);
                            }
                        }
                        if (eData.data2 != null) {
                            ++tgdt.t2_count;
                        }
                        if (eData.ecause == null) continue;
                        if (eData.ecause instanceof TData) {
                            ++tgdt.pcause;
                            continue;
                        }
                        ++tgdt.ecause;
                        obj = (EData)eData.ecause;
                        tg2 = obj.getTrigger();
                        String tg2_value = tg2.name.toLowerCase();
                        if (!dict.contains(tg2_value)) continue;
                        tgdt.parent.add(tg2_value);
                    }
                    if (analyzer.detectedTrg[i].size() <= 0 || analyzer.detectedPro[i].size() <= 0) continue;
                    for (Word word : analyzer.detectedTrg[i]) {
                        counter = (int[])keys.get(word.word);
                        if (counter == null) {
                            counter = new int[trigger_type.length + 1];
                        }
                        int n = trigger_type.length;
                        counter[n] = counter[n] + 1;
                    }
                }
            }
            int skip = 0;
            HashMap<String, KeyData> mdict = new HashMap<String, KeyData>();
            for (String s : keys.keySet()) {
                KeyData item;
                counter = (int[])keys.get(s);
                List<Integer> list = this.getType(counter);
                if (list.isEmpty()) {
                    System.out.print("Skip:  " + s + " --> freq: ");
                    for (int u = 0; u < counter.length; ++u) {
                        System.out.print(counter[u] + "  ");
                    }
                    System.out.println("");
                    ++skip;
                    continue;
                }
                if (list.size() == 1) {
                    int idx = list.get(0);
                    item = new KeyData(s, trigger_type[idx], counter[idx], 1, counter[trigger_type.length]);
                    mdict.put(s, item);
                    continue;
                }
                int ktype = 3;
                if (sharedTrg.containsKey(s) && ((Counter)sharedTrg.get((Object)s)).count > this.fthreshold + 2) {
                    ktype = 2;
                    for (int z = 0; z < list.size(); ++z) {
                        if (!((double)((float)counter[list.get(z)] * 1.0f / (float)this.sum(counter)) < 0.3)) continue;
                        ktype = 3;
                        break;
                    }
                }
                item = new KeyData(s, null, this.sum(counter), ktype, counter[trigger_type.length]);
                mdict.put(s, item);
                for (int j = 0; j < list.size(); ++j) {
                    int k = list.get(j);
                    KeyData kdt = new KeyData(s, trigger_type[k], counter[k], ktype, counter[9]);
                    item.addToMap(kdt);
                }
            }
            for (int i = 6; i < 9; ++i) {
                HashMap hashMap = allTrg[i];
                for (String s : hashMap.keySet()) {
                    tgdt = (TriggerData)hashMap.get(s);
                    if (tgdt.child[1].isEmpty()) continue;
                    for (String st : tgdt.child[1]) {
                        TriggerData tmtrg = (TriggerData)allTrg[1].get(st);
                        if (tmtrg == null) continue;
                        tmtrg.parent.add(tgdt.trigger);
                    }
                }
            }
            KeyData kdt = null;
            ArrayList<KeyData> kls = new ArrayList<KeyData>();
            for (String s : mdict.keySet()) {
                kls.clear();
                kdt = (KeyData)mdict.get(s);
                if (kdt.keytype == 1) {
                    kls.add(kdt);
                } else {
                    kls.addAll(kdt.getMap().values());
                }
                for (KeyData dt : kls) {
                    int idx = this.hashType.get(dt.type);
                    tgdt = (TriggerData)allTrg[idx].get(s);
                    if (tgdt == null) continue;
                    StringBuilder ls = new StringBuilder();
                    StringBuilder cs = new StringBuilder();
                    for (int j = 0; j < tgdt.child.length; ++j) {
                        for (String st : tgdt.child[j]) {
                            ls.append(st);
                            ls.append(',');
                        }
                        for (String st : tgdt.parent) {
                            cs.append(st);
                            cs.append(',');
                        }
                    }
                    dt.pcount = tgdt.pcount;
                    dt.ecount = tgdt.ecount;
                    dt.pcause = tgdt.pcause;
                    dt.ecause = tgdt.ecause;
                    dt.t2count = tgdt.t2_count;
                    dt.initData(ls.toString(), cs.toString());
                }
            }
            this.saveKeyData(mdict);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getCause());
        }
        System.out.println("Trigger data generating .... Done!");
    }

    private int sum(int[] ls) {
        int total = 0;
        for (int i = 0; i < 9; ++i) {
            total += ls[i];
        }
        return total;
    }

    public class TriggerData {
        String trigger;
        String type;
        int ttype = -1;
        int pcount = 0;
        int ecount = 0;
        int pcause = 0;
        int ecause = 0;
        int t2_count = 0;
        public Set<String>[] child = new HashSet[trigger_type.length];
        public Set<String> parent = new HashSet<String>();

        public TriggerData(String trg, String tp) {
            this.trigger = trg;
            this.type = tp;
            for (int i = 0; i < trigger_type.length; ++i) {
                this.child[i] = new HashSet<String>();
            }
        }
    }
}

