/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import relations.Chunk;
import relations.Word;
import utils.BioSemException;

public class BasicChunk {
    public String type;
    List<Chunk> chunkList = new ArrayList<Chunk>();
    List<Word> proList = new ArrayList<Word>();
    List<Word> trgList = new ArrayList<Word>();
    int start = 0;
    int end = -1;
    public boolean extracted = false;
    Set<Word> usedPro = new HashSet<Word>();
    public boolean is_merged = false;
    public boolean init = false;
    Set<Word> failed = new HashSet<Word>();
    public static final String[] ccList = new String[]{"and", "or", "but not", "as well as"};
    public static final String[] appoList = new String[]{"like", "such as", "including"};
    public static final Set<String> appoMap = new HashSet<String>(5);
    public static final Set<String> ccMap = new HashSet<String>(10);

    public boolean isEmpty() {
        return this.end == -1;
    }

    public void addChunk(BasicChunk bc) {
        for (Chunk c : bc.chunkList) {
            this.addChunk(c);
        }
    }

    public void removeTrg(Word tg) {
        Chunk c = this.getChunk(tg.pos);
        if (c != null) {
            c.trigs.remove(tg);
            if (tg.combined) {
                c.removePro(tg.pos);
            }
            this.trgList.remove(tg);
            Word pr = null;
            for (Word w : this.proList) {
                if (w.pos != tg.pos) continue;
                pr = w;
                break;
            }
            if (pr != null) {
                this.proList.remove(pr);
            }
        } else {
            String message = "---> BUG: " + tg.word + "  Pos: " + tg.pos;
            throw new BioSemException(new Exception("There was a word without a chunk: " + message + ". This issue could probably handled more gracefully if someone would look into it."));
        }
    }

    public boolean inChunkTrg(Word tg, String[] tokens) {
        int pos = this.getChunkPos(tg.pos);
        if (pos < 0) {
            return false;
        }
        Chunk c = this.chunkList.get(pos);
        return c.is_inChunk(tg, tokens);
    }

    public boolean isSameRole(Word tg1, Word tg2, String[] tokens) {
        if (tg1.inchunk || tg2.inchunk) {
            return false;
        }
        if (tg1.combined || tg2.combined || !tg1.pos_tag.equals(tg2.pos_tag)) {
            return false;
        }
        int pos1 = this.getChunkPos(tg1.pos);
        int pos2 = this.getChunkPos(tg2.pos);
        if (pos1 < 0 || pos2 < 0) {
            return false;
        }
        if (pos2 == pos1 + 2) {
            if (pos1 > 0 && this.chunkList.get((int)(pos1 - 1)).txt.equals("of")) {
                return false;
            }
            if (!ccMap.contains(this.chunkList.get((int)(pos1 + 1)).txt)) {
                return false;
            }
        } else if (pos1 != pos2) {
            return false;
        }
        pos1 = Math.min(tg1.pos, tg2.pos);
        pos2 = Math.max(tg1.pos, tg2.pos);
        for (int i = pos1 + 1; i < pos2; ++i) {
            if (!ccMap.contains(tokens[i])) continue;
            for (Word pr : this.proList) {
                if (pr.pos <= pos1 || pr.pos >= pos2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSameChunk(Word tg, Word pr) {
        int pos2;
        int pos1 = this.getChunkPos(tg.pos);
        return pos1 == (pos2 = this.getChunkPos(pr.pos)) && pos1 >= 0 && tg.pos < pr.pos;
    }

    public List<Word> getPro() {
        ArrayList<Word> ls = new ArrayList<Word>();
        for (Word w : this.proList) {
            if (this.usedPro.contains(w)) continue;
            ls.add(w);
        }
        return ls;
    }

    public void mergeNP() {
        if (this.init) {
            return;
        }
        int i = 1;
        Chunk prev = null;
        if (this.chunkList.isEmpty()) {
            return;
        }
        prev = this.chunkList.get(0);
        while (i < this.chunkList.size()) {
            Chunk curr = this.chunkList.get(i);
            if (prev != null && prev.type.equals("NP") && curr.type.equals("NP")) {
                prev.merge(curr);
                this.chunkList.remove(curr);
                continue;
            }
            if (curr.type.equals("ADVP") && curr.pros.isEmpty() && curr.trigs.isEmpty() && i < this.chunkList.size() - 1) {
                Chunk next = this.chunkList.get(i + 1);
                if (prev != null && prev.txt.equals(",") && next.txt.equals(",")) {
                    this.chunkList.remove(prev);
                    this.chunkList.remove(curr);
                    this.chunkList.remove(next);
                    prev = null;
                    continue;
                }
            }
            ++i;
            prev = curr;
        }
        this.findCoordinator(this.chunkList);
        this.init = true;
    }

    public String findTrigger(Word tg, Word pro) {
        String txt = null;
        int p1 = Math.min(tg.pos, pro.pos);
        int p2 = Math.max(tg.pos, pro.pos);
        for (Word w : this.trgList) {
            if (w.pos <= p1 || w.pos >= p2) continue;
            if (txt == null) {
                txt = w.word;
                continue;
            }
            txt = txt + "," + w.word;
        }
        if (txt != null) {
            return txt;
        }
        return "";
    }

    public void findCoordinator(List<Chunk> ls) {
        int i = 0;
        int idx = 0;
        while (i < ls.size() - 2) {
            Chunk curr = ls.get(i);
            boolean found = false;
            boolean in_loop = false;
            if (curr.type.equals("NP")) {
                Chunk next;
                int j = i + 1;
                if (curr.txt.contains(",")) {
                    in_loop = true;
                }
                while (j < ls.size() - 1) {
                    Chunk tmp;
                    next = ls.get(j);
                    Chunk next1 = ls.get(j + 1);
                    if (next.type.equals("VP") && next.txt.equals("containing") && next1.type.equals("NP")) {
                        found = true;
                        idx = j + 1;
                        break;
                    }
                    if (next.txt.equals(",") && next1.type.equals("NP")) {
                        j += 2;
                        in_loop = true;
                        continue;
                    }
                    if (next.txt.equals(",")) {
                        if (next1.type.equals("O") && ccMap.contains(next1.txt) && in_loop) {
                            if (j < ls.size() - 2) {
                                tmp = ls.get(j + 2);
                                if (!tmp.type.equals("NP")) break;
                                found = true;
                                idx = j + 2;
                                break;
                            }
                            System.out.println("BasicChunk: findCoordinator -----> Unkown case: ---> co-ordination");
                            System.out.println(this.toString());
                            break;
                        }
                        if (appoMap.contains(next1.txt)) {
                            if (j < ls.size() - 2) {
                                tmp = ls.get(j + 2);
                                if (!tmp.type.equals("NP")) break;
                                idx = j + 2;
                                j += 3;
                                in_loop = true;
                                found = true;
                                continue;
                            }
                            System.out.println("BasicChunk: findCoordinator -----> Unkown case: --> apposition ---");
                            System.out.println(this.toString());
                            break;
                        }
                        if (!in_loop || !next1.txt.contains(" and ") && !next1.txt.contains(" or ")) break;
                        found = true;
                        idx = j + 2;
                        break;
                    }
                    if (next.type.equals("O") && ccMap.contains(next.txt) && next1.type.equals("NP")) {
                        found = true;
                        idx = j + 1;
                        if (in_loop || j >= ls.size() - 2) break;
                        tmp = ls.get(j + 2);
                        if (!tmp.txt.equals("of")) break;
                        found = false;
                        break;
                    }
                    if (next.type.equals("CONJP") && next1.type.equals("NP")) {
                        idx = j + 1;
                        found = true;
                        if (in_loop || j >= ls.size() - 2) break;
                        tmp = ls.get(j + 2);
                        if (!tmp.txt.equals("of")) break;
                        found = false;
                        break;
                    }
                    if (!appoMap.contains(next.txt) || !next1.type.equals("NP")) break;
                    if (j + 3 < ls.size()) {
                        tmp = ls.get(j + 2);
                        if (tmp.txt.equals("of")) {
                            found = false;
                            break;
                        }
                        idx = j += 3;
                        found = true;
                        in_loop = true;
                        continue;
                    }
                    found = true;
                    idx = j + 1;
                    break;
                }
                if (found) {
                    in_loop = false;
                    ArrayList<Chunk> rm = new ArrayList<Chunk>();
                    for (int k = i + 1; k <= idx; ++k) {
                        next = ls.get(k);
                        curr.merge(next);
                        rm.add(next);
                    }
                    for (Chunk c : rm) {
                        ls.remove(c);
                    }
                    curr.is_merged = true;
                    continue;
                }
            }
            ++i;
        }
    }

    public int proCount() {
        return this.proList.size();
    }

    public int trgCount() {
        return this.trgList.size();
    }

    public boolean containsKey(Word key) {
        return key.pos >= this.start && key.pos <= this.end;
    }

    public boolean belongTO(Word trg, Word pr) {
        return this.containsKey(pr) && this.containsKey(trg);
    }

    public boolean belongTO(Word trg, Word pr, Word pr2) {
        if (this.containsKey(pr) && this.containsKey(trg)) {
            if (pr2 == null) {
                return true;
            }
            if (this.containsKey(pr2)) {
                return true;
            }
        }
        return false;
    }

    public int countChunks(Word w1, Word w2) {
        int pos1 = this.getChunkPos(w1.pos);
        int pos2 = this.getChunkPos(w2.pos);
        if (pos1 < 0 || pos2 < 0) {
            System.out.println("---> not belong to BasicChunk ----> start: " + this.start + " end: " + this.end);
            System.out.println("V1: " + w1.word + " pos: " + w1.pos + " V2: " + w2.word + " pos: " + w2.pos);
            return -1;
        }
        return Math.abs(pos1 - pos2);
    }

    public Chunk getChunk(int pos) {
        for (Chunk c : this.chunkList) {
            if (pos < c.begin || pos > c.end) continue;
            return c;
        }
        return null;
    }

    public String getBy_Through(Word tg, Word pr, String[] tokens) {
        int st1 = Math.min(tg.pos, pr.pos);
        int st2 = Math.max(tg.pos, pr.pos);
        for (int i = st1; i < st2; ++i) {
            if (!tokens[i].equals("through")) continue;
            return tokens[i];
        }
        return null;
    }

    public boolean isQualify() {
        return this.proList.size() > 0 && this.trgList.size() > 0;
    }

    public String getPrep(Word tg, Word pr) {
        return "";
    }

    public int getChunkPos(int pos) {
        if (pos >= this.start && pos <= this.end) {
            for (int i = 0; i < this.chunkList.size(); ++i) {
                Chunk c = this.chunkList.get(i);
                if (pos < c.begin || pos > c.end) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean inChunk(Word trg, Word pro) {
        if (this.belongTO(trg, pro)) {
            for (Chunk c : this.chunkList) {
                if (!c.inChunk(trg, pro)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean inChunkTG(Word trg1, Word trg2) {
        if (this.belongTO(trg1, trg2)) {
            for (Chunk c : this.chunkList) {
                if (!c.inChunkTG(trg1, trg2)) continue;
                return true;
            }
        }
        return false;
    }

    public void addChunk(Chunk c) {
        if (this.chunkList.isEmpty()) {
            this.start = c.begin;
        }
        this.end = c.end;
        this.chunkList.add(c);
        if (c.pros.size() > 0) {
            this.proList.addAll(c.pros);
        }
        if (c.trigs.size() > 0) {
            this.trgList.addAll(c.trigs);
        }
    }

    public void addPro(Word pro) {
        this.proList.add(pro);
    }

    public void addTrg(Word trg) {
        this.trgList.add(trg);
    }

    public void printChunk() {
        for (Chunk ch : this.chunkList) {
            System.out.print("[" + ch.type + " " + ch.txt + "]");
        }
        System.out.print(" | ");
    }

    private void splitAND() {
        if (this.chunkList.size() <= 3) {
            return;
        }
        Chunk prev = this.chunkList.get(0);
        for (int i = 1; i < this.chunkList.size() - 1; ++i) {
            Chunk c = this.chunkList.get(i);
            if (prev.txt.equals("of")) {
                Chunk next = this.chunkList.get(i + 1);
                if (c.txt.contains("and") && next.txt.equals("of")) {
                    String[] s = c.txt.split(" ");
                    int count = 0;
                    while (!s[count].equals("and")) {
                        prev.txt = prev.txt + " " + s[count];
                        ++count;
                    }
                    prev.end += count;
                    Chunk and = new Chunk("O");
                    and.txt = "and";
                    and.begin = c.begin + count;
                    and.end = c.begin + count;
                    c.begin += count + 1;
                    int idx = c.txt.indexOf("and");
                    c.txt = c.txt.substring(idx + 4);
                    this.chunkList.add(i, and);
                }
            }
            prev = c;
        }
    }

    public String toString() {
        String result = "";
        for (Chunk c : this.chunkList) {
            result = result + c.toString();
        }
        return result;
    }

    static {
        ccMap.addAll(Arrays.asList(ccList));
        appoMap.addAll(Arrays.asList(appoList));
    }
}

