/*
 * Decompiled with CFR 0.152.
 */
package corpora;

import corpora.DataSaver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import utils.DBUtils;

public class DataLoader {
    DataSaver saver;
    String currentPid = null;
    int countabs = 0;
    static final String new_line = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProtein(String filename) {
        File file = new File(filename);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String text = null;
            while ((text = reader.readLine()) != null) {
                this.readProteinLine(text);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readProteinLine(String proteinLine) {
        int i;
        String[] st = proteinLine.split("\\t|\\s+", 5);
        int lWs = 0;
        int rWs = 0;
        String name = st[4];
        for (i = 0; i < name.length() && name.charAt(i) == ' '; ++i) {
            ++lWs;
        }
        for (i = name.length() - 1; i > 0 && name.charAt(i) == ' '; --i) {
            ++rWs;
        }
        this.saver.saveProtein(this.currentPid, st[0], Integer.parseInt(st[2]) + lWs, Integer.parseInt(st[3]) - rWs, name.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAbstract(String filename) {
        File file = new File(filename);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String text = null;
            ArrayList<String> list = new ArrayList<String>();
            while ((text = reader.readLine()) != null) {
                list.add(text);
            }
            text = (String)list.get(0);
            if (list.size() > 1) {
                for (int i = 1; i < list.size(); ++i) {
                    text = text + "\n" + (String)list.get(i);
                }
            }
            this.saver.saveAbstract(this.currentPid, text);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTrigger(String filename) {
        File file = new File(filename);
        BufferedReader reader = null;
        String cause_id = "";
        String theme2 = "";
        try {
            reader = new BufferedReader(new FileReader(file));
            String text = null;
            while ((text = reader.readLine()) != null) {
                String[] st;
                if (text.startsWith("T")) {
                    st = text.split("\\t|\\s+", 5);
                    this.saver.saveTrigger(this.currentPid, st[0], st[1], Integer.parseInt(st[2]), Integer.parseInt(st[3]), st[4]);
                } else {
                    st = text.split("\\t|\\s+", 0);
                }
                if (st[0].startsWith("E")) {
                    if (st.length >= 4) {
                        String[] sub3 = st[3].split(":");
                        if (sub3[0].startsWith("Theme2")) {
                            theme2 = sub3[1];
                            cause_id = "";
                        } else if (sub3[0].startsWith("Cause")) {
                            cause_id = sub3[1];
                            theme2 = "";
                        } else {
                            cause_id = "";
                            theme2 = "";
                        }
                    } else {
                        cause_id = "";
                        theme2 = "";
                    }
                    String[] sub1 = st[1].split(":");
                    String[] sub2 = st[2].split(":");
                    this.saver.saveEvent(this.currentPid, st[0], sub1[0], sub1[1], sub2[1], theme2, cause_id);
                    continue;
                }
                if (st[0].startsWith("M")) {
                    this.saver.saveModify(this.currentPid, st[0], st[1], st[2]);
                    continue;
                }
                if (!st[0].startsWith("*")) continue;
                st = text.split("\\t|\\s+", 4);
                this.saver.saveEquiv(this.currentPid, st[2], st[3]);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadData(String path, boolean train) {
        int count = 0;
        try {
            File[] list;
            File file = new File(path);
            for (File f : list = file.listFiles()) {
                if (!f.isFile()) continue;
                String name = f.getName();
                String file_path = f.getParent();
                if (!name.endsWith("txt")) continue;
                String[] ns = name.split("\\.txt");
                this.currentPid = ns[0];
                String n = file_path + File.separatorChar + ns[0] + ".txt";
                this.readAbstract(n);
                String n1 = file_path + File.separatorChar + ns[0] + ".a1";
                this.readProtein(n1);
                if (train) {
                    String n2 = file_path + File.separatorChar + ns[0] + ".a2";
                    this.readTrigger(n2);
                }
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Number of abstracts: " + count);
    }

    public void Txt2Db(String path, String dest, boolean train) {
        DBUtils db = new DBUtils();
        db.openDB(dest);
        System.out.println("Loading data .... !");
        this.saver = new DataSaver(db);
        this.loadData(path, train);
        System.out.println("Loading data .... done!");
        db.closeDB();
    }

    public DBUtils Txt2Db(String pid, String text, List<String> proteins) {
        this.currentPid = pid;
        DBUtils db = new DBUtils(pid, "mem");
        db.openDB();
        this.saver = new DataSaver(db);
        this.saver.saveAbstract(this.currentPid, text);
        for (String proteinLine : proteins) {
            this.readProteinLine(proteinLine);
        }
        return db;
    }

    public static void main(String[] args) {
        DataLoader data = new DataLoader();
        data.Txt2Db("D:/DataNLP/Data2011Text", "D:/DataNLP/Mix2011/Data", true);
    }
}

