/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtils {
    private static final Logger log = LoggerFactory.getLogger(DBUtils.class);
    public Connection con;
    public ResultSet rs;
    public Statement stmt;
    boolean open = false;
    private String defaultName;
    private String protocol;
    private String properties;

    public DBUtils() {
        this("data/Data", "file");
    }

    public DBUtils(String defaultName, String protocol) {
        this(defaultName, protocol, null);
    }

    public DBUtils(String defaultName, String protocol, String properties) {
        this.defaultName = defaultName;
        this.protocol = protocol;
        this.properties = properties;
    }

    public void openDB() {
        log.debug("Opening database with protocol {}, name {} and properties {}.", new Object[]{this.protocol, this.defaultName, this.properties});
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            String propertyString = this.properties != null ? ";" + this.properties : "";
            this.con = DriverManager.getConnection("jdbc:hsqldb:" + this.protocol + ":" + this.defaultName + propertyString, "sa", "");
            this.stmt = this.con.createStatement();
            this.open = true;
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void openDB(String dbName) {
        log.debug("Opening database with protocol {}, name {} and properties {}.", new Object[]{this.protocol, this.defaultName, this.properties});
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            String propertyString = this.properties != null ? ";" + this.properties : "";
            this.con = DriverManager.getConnection("jdbc:hsqldb:" + this.protocol + ":" + dbName + propertyString, "sa", "");
            this.stmt = this.con.createStatement();
            this.open = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public Connection createConnection(String name) {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.open = true;
            return DriverManager.getConnection(name, "sa", "");
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    @Deprecated
    public void createDB(String sql) {
        try {
            this.checkStmt();
            this.stmt.execute(sql);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Deprecated
    private void checkStmt() {
        if (this.stmt == null) {
            if (!this.open) {
                this.openDB();
            } else {
                try {
                    this.con.createStatement();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Deprecated
    public ResultSet execQuery(String sql) {
        try {
            this.checkStmt();
            return this.stmt.executeQuery(sql);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public Connection getConnection() {
        if (this.con != null) {
            return this.con;
        }
        this.openDB();
        return this.con;
    }

    public void dropTable(String tablename) {
        try {
            this.stmt.executeUpdate("DROP TABLE " + tablename + " IF EXISTS");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void execUpdate(String sql) {
        try {
            this.stmt.executeUpdate(sql);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean checkTable(String tableName) {
        if (this.con == null) {
            this.con = this.getConnection();
        }
        try {
            DatabaseMetaData meta = this.con.getMetaData();
            this.rs = meta.getTables(null, null, null, new String[]{"TABLE"});
            while (this.rs.next()) {
                String Name = this.rs.getString("TABLE_NAME");
                if (!Name.contentEquals(tableName) && !Name.contentEquals(tableName.toUpperCase())) continue;
                this.rs.close();
                return true;
            }
            this.rs.close();
        }
        catch (Exception e) {
            System.out.println("Error in chechTable" + e);
        }
        return false;
    }

    public void closeDB() {
        try {
            if (this.con != null && !this.con.isClosed()) {
                this.stmt.execute("SHUTDOWN");
                this.con.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdownDB() {
        try {
            if (this.con != null && !this.con.isClosed()) {
                this.stmt.execute("SHUTDOWN COMPACT");
                this.con.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

