/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relations.EData;
import relations.KeyData;
import relations.RuleData;
import relations.RuleSet;
import relations.Rules;
import relations.TData;
import relations.TriggerLearner;
import utils.DBUtils;
import utils.SentenceSplitter;

public class SenSimplifier {
    private static final Logger log;
    List<TData> plist;
    List<TData> tlist;
    String abst;
    String simp;
    DBUtils db;
    Connection con;
    Statement stmt;
    ResultSet rs;
    PreparedStatement ps_sen;
    Pattern pt;
    Matcher mc;
    boolean loaddict = false;
    List<String> idList = new ArrayList<String>();
    public Set<String> simpleDic = new HashSet<String>();
    int fvalues = 2;
    double fscore = 0.1;
    int pmiss_count = 0;
    int trmiss_count = 0;
    public int er_count = 0;
    int bug_count = 0;
    public final int nr_event = 9;
    public static final String[] preps;
    public static final Set<String> prepmap;
    public static final Map<String, String> modifiers;
    public Map<String, String> equimap = new HashMap<String, String>();
    public static final Map<String, String> none_rel;
    public static final String[] trigger_type;
    public static final Map<String, Integer> hashType;
    public Map<String, KeyData> sharedDic = new HashMap<String, KeyData>();
    public Map<String, List<String>> equiList = new HashMap<String, List<String>>();

    public SenSimplifier(DBUtils dbs) {
        try {
            this.db = dbs;
            this.con = this.db.getConnection();
            this.stmt = this.con.createStatement();
            this.pt = Pattern.compile("PRO\\d{1,3}");
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public SenSimplifier() {
    }

    public void setDB(DBUtils dbs) {
        this.db = dbs;
        this.con = this.db.getConnection();
        try {
            this.stmt = this.con.createStatement();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Rules>[] loadPatterns(DBUtils db) {
        HashMap[] rules = new HashMap[trigger_type.length];
        for (int i = 0; i < trigger_type.length; ++i) {
            rules[i] = new HashMap();
        }
        DBUtils dbs = db;
        int ptcount = 0;
        try {
            Connection cons = dbs.getConnection();
            Statement stms = cons.createStatement();
            String sql = "select trgkey,type,verb_type, pos, chunk_type,pos1, pos2,prep1,prep2,prep_order,has_theme2,in_chunk,chunk1,chunk2,event1,event2,trg1,trg2,pcount, detected from PATTERNS";
            ResultSet rst = stms.executeQuery(sql);
            while (rst.next()) {
                ++ptcount;
                String key = rst.getString(1);
                String type = rst.getString(2);
                int idx = hashType.get(type);
                HashMap m = rules[idx];
                Rules rule = (Rules)m.get(key);
                if (rule == null) {
                    rule = new Rules(idx, key);
                    m.put(key, rule);
                }
                int verb_type = rst.getInt(3);
                String POS = rst.getString(4);
                String chunk_type = rst.getString(5);
                boolean prep1_pos = rst.getBoolean(6);
                boolean prep2_pos = rst.getBoolean(7);
                String prep1 = rst.getString(8);
                String prep2 = rst.getString(9);
                boolean prep_order = rst.getBoolean(10);
                boolean has_theme2 = rst.getBoolean(11);
                boolean in_chunk = rst.getBoolean(12);
                int count1 = rst.getInt(13);
                int count2 = rst.getInt(14);
                boolean event1 = rst.getBoolean(15);
                boolean event2 = rst.getBoolean(16);
                String trg1 = rst.getString(17);
                String trg2 = rst.getString(18);
                int pcount = rst.getInt(19);
                rule.rcount += pcount;
                RuleData p = idx < 5 ? new RuleData(verb_type, POS, chunk_type, prep1_pos, prep1, in_chunk, count1, trg1) : (idx == 5 ? new RuleData(verb_type, POS, chunk_type, prep1_pos, prep2_pos, prep_order, prep1, prep2, has_theme2, in_chunk, count1, count2, trg1) : new RuleData(verb_type, POS, chunk_type, prep1_pos, prep2_pos, prep_order, prep1, prep2, has_theme2, in_chunk, count1, count2, event1, event2, trg1, trg2));
                p.count = pcount;
                p.detected = rst.getInt(20);
                if (pcount < 1) continue;
                rule.map.put(p.getKey(), p);
            }
            rst.close();
            System.out.println("---DONE---> Loading patterns, number of patterns: " + ptcount);
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
        return rules;
    }

    public Map<String, RuleSet> loadRuleSet(DBUtils db) {
        HashMap<String, RuleSet> map = new HashMap<String, RuleSet>();
        DBUtils dbs = db;
        try {
            Connection cons = dbs.getConnection();
            Statement stms = cons.createStatement();
            String sql = "select key,inchunk,dist1,dist2,prep,prep2,t_order,pcount,ecount,t2count, pcause,ecause,inprep,in_front,prep_1,prep_2,detected, inchunk_count, apply from RULESET";
            ResultSet rst = stms.executeQuery(sql);
            while (rst.next()) {
                String[] st;
                HashSet<String> set;
                RuleSet rule = new RuleSet();
                String key = rst.getString(1);
                rule.in_chunk = rst.getBoolean(2);
                rule.dist1 = rst.getInt(3);
                rule.dist2 = rst.getInt(4);
                String prep = rst.getString(5);
                String prep2 = rst.getString(6);
                rule.order = rst.getBoolean(7);
                rule.pcount = rst.getInt(8);
                rule.ecount = rst.getInt(9);
                rule.t2count = rst.getInt(10);
                rule.pcause = rst.getInt(11);
                rule.ecause = rst.getInt(12);
                String inprep = rst.getString(13);
                rule.in_front = rst.getInt(14);
                String prep_1 = rst.getString(15);
                String prep_2 = rst.getString(16);
                rule.detected = rst.getInt(17);
                if (rule.detected <= 1) continue;
                rule.inchunk_count = rst.getInt(18);
                rule.apply = rst.getInt(19);
                if (!prep.isEmpty()) {
                    set = new HashSet<String>();
                    st = prep.split(" ");
                    set.addAll(Arrays.asList(st));
                    rule.prep = set;
                }
                if (!inprep.isEmpty()) {
                    set = new HashSet();
                    st = inprep.split(" ");
                    set.addAll(Arrays.asList(st));
                    rule.inchunk_prep = set;
                }
                if (!prep_1.isEmpty()) {
                    set = new HashSet();
                    st = prep_1.split(" ");
                    set.addAll(Arrays.asList(st));
                    rule.prep_1 = set;
                }
                if (!prep_2.isEmpty()) {
                    set = new HashSet();
                    st = prep_2.split(" ");
                    set.addAll(Arrays.asList(st));
                    rule.prep_2 = set;
                }
                if (!prep2.isEmpty()) {
                    HashMap<String, Set<String>> prep2Map = new HashMap<String, Set<String>>();
                    for (String s : st = prep2.split("\\|")) {
                        String[] st1 = s.split(":");
                        String[] st2 = st1[1].split(" ");
                        HashSet<String> set2 = new HashSet<String>();
                        set2.addAll(Arrays.asList(st2));
                        prep2Map.put(st1[0], set2);
                    }
                    rule.prep2 = prep2Map;
                }
                map.put(key, rule);
            }
            rst.close();
            System.out.println("---DONE---> Loading rule set, number of rules: " + map.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getLocalizedMessage());
            System.out.println(e.getCause());
        }
        return map;
    }

    public void loadSimpleDic(Map<String, KeyData> map) {
        if (this.simpleDic.isEmpty()) {
            for (String s : map.keySet()) {
                this.simpleDic.add(s);
            }
        }
        System.out.println("Loading simple dict: " + this.simpleDic.size() + " entries");
    }

    public void loadSimpleDic() {
        if (this.simpleDic.isEmpty()) {
            try {
                Connection cons = this.db.getConnection();
                Statement stms = cons.createStatement();
                this.rs = stms.executeQuery(" select key, tt from trigdata order by tt desc");
                while (this.rs.next()) {
                    String s = this.rs.getString(1);
                    String[] tmp = s.split(" ");
                    if (tmp.length > 2 || s.length() < 3) continue;
                    this.simpleDic.add(s);
                }
                this.rs.close();
            }
            catch (Exception ex) {
                System.out.println("Error in loading simple dic, due to: " + ex.getLocalizedMessage());
            }
            System.out.println("---> loading simple dict DONE!");
            ArrayList<String> remove = new ArrayList<String>();
            for (String s : this.simpleDic) {
                String[] ww;
                if (!s.contains("-") || (ww = s.split("-")).length != 2 || !this.simpleDic.contains(ww[0] + ww[1])) continue;
                remove.add(s);
            }
            for (String s : remove) {
                this.simpleDic.remove(s);
            }
        }
    }

    public void setSimpleDic(Set<String> map) {
        this.simpleDic = map;
    }

    public final void loadDict(DBUtils dbs) {
        DBUtils dbdict = dbs;
        try {
            String sql = "select key,ktype,type,freq,total, pcount, ecount,pcause,ecause,t2count,child, parent from keydata";
            Connection cons = dbdict.getConnection();
            Statement stms = cons.createStatement();
            this.rs = stms.executeQuery(sql);
            while (this.rs.next()) {
                String key = this.rs.getString(1);
                int keytype = this.rs.getInt(2);
                String stype = this.rs.getString(3);
                int freq = this.rs.getInt(4);
                int found = this.rs.getInt(5);
                int pcount = this.rs.getInt(6);
                int ecount = this.rs.getInt(7);
                int pcause = this.rs.getInt(8);
                int ecause = this.rs.getInt(9);
                int t2count = this.rs.getInt(10);
                String child = this.rs.getString(11);
                String parent = this.rs.getString(12);
                KeyData item = new KeyData(key, stype, freq, keytype, found);
                item.pcount = pcount;
                item.ecount = ecount;
                item.pcause = pcause;
                item.ecause = ecause;
                item.t2count = t2count;
                item.initData(child, parent);
                if (keytype == 1) {
                    this.sharedDic.put(key, item);
                    continue;
                }
                KeyData tmp = this.sharedDic.get(key);
                if (tmp != null) {
                    tmp.addToMap(item);
                    tmp.freq += freq;
                    tmp.score = (float)tmp.freq * 1.0f / ((float)found * 1.0f);
                    continue;
                }
                tmp = new KeyData(key, null, 0, keytype, found);
                tmp.freq = freq;
                tmp.addToMap(item);
                tmp.score = (float)tmp.freq * 1.0f / ((float)tmp.found * 1.0f);
                this.sharedDic.put(key, tmp);
            }
            this.rs.close();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        System.out.println("Loading dic ... done. Number of entries:" + this.sharedDic.size());
        this.loaddict = true;
        ArrayList<String> rm = new ArrayList<String>();
        for (String s : this.sharedDic.keySet()) {
            KeyData k = this.sharedDic.get(s);
            if (!(k.score < this.fscore && k.keytype == 1) && (!(k.score < 0.15) || k.keytype == 1)) continue;
            rm.add(s);
        }
        for (String k : rm) {
            this.sharedDic.remove(k);
        }
        this.loadSimpleDic(this.sharedDic);
        this.setModifier();
    }

    public void setModifier() {
        String[] list = new String[]{"appearance:Gene_expression:gene|genes:true", "induction:Gene_expression:gene1|genes1:true", "secreting:Gene_expression:gene|genes:true", "expression:Transcription:mRNA|mRNAs|transcripts:true", "expressed:Transcription:RNA|mRNA|mRNAs:true", "induction:Transcription:RNA|mRNA|mRNAs:true", "express:Transcription:RNA|mRNA|mRNAs:true", "production:Transcription:RNA|mRNA|mRNAs|transcripts|level:true", "detected:Transcription:RNA|mRNA|mRNAs|level|transcripts:true", "levels:Transcription:mRNA|mRNAs|transcripts:true", "synthesis:Transcription:mRNA|mRNAs|transcripts:true", "transcription:Transcription:RNA|mRNA|mRNAs|level|transcripts|gene|genes:true", "transcriptional:Transcription:RNA|mRNA|mRNAs|level|transcripts|gene|genes:true", "transcript:Transcription:mRNA|mRNAs|genes|gene|level:true", "levels:Transcription:mRNA|mRNAs|transcript:true", "expression:Localization:nuclear|nucleus:true", "appearance:Localization:nuclear|nucleus:true"};
        System.out.println("----------- Set modifier: ");
        for (String s : list) {
            KeyData dt1;
            String[] values = s.split(":");
            KeyData dt = this.sharedDic.get(values[0]);
            String[] mdf = values[2].split("\\|");
            if (dt == null || dt.keytype != 3 || (dt1 = dt.getKeyData(values[1])) == null) continue;
            dt1.setModifiers(mdf);
            if (!values[3].equals("true")) continue;
            dt1.required = true;
        }
    }

    public List<TData> loadProtein(String pmid) {
        ArrayList<TData> list = new ArrayList<TData>();
        String sql = "Select * from PROTEIN WHERE PMID LIKE '" + pmid + "'";
        try {
            this.rs = this.stmt.executeQuery(sql);
            while (this.rs.next()) {
                int[] pos = new int[2];
                String pid = this.rs.getString(1);
                String tid = this.rs.getString(2);
                pos[0] = this.rs.getInt(3);
                pos[1] = this.rs.getInt(4);
                String txt = this.rs.getString(5);
                TData dt = new TData(pid, tid, "protein", pos, txt);
                list.add(dt);
            }
            this.rs.close();
        }
        catch (Exception e) {
            System.out.println("Load Protein failed: reasons:");
            System.out.println(e.getLocalizedMessage());
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            ((TData)list.get((int)i)).new_name = "PRO" + i;
        }
        return list;
    }

    public int getPIndex(String pname) {
        int i = pname.length() - 1;
        while (Character.isDigit(pname.charAt(i))) {
            --i;
        }
        return Integer.parseInt(pname.substring(i + 1));
    }

    public List<String> getProteins(String s) {
        ArrayList<String> list = new ArrayList<String>();
        this.mc = this.pt.matcher(s);
        while (this.mc.find()) {
            list.add(this.mc.group());
        }
        return list;
    }

    public int findProIndex(List<TData> plist, int pos) {
        for (int i = 0; i < plist.size(); ++i) {
            TData data = plist.get(i);
            if (data.list[0] < pos) {
                continue;
            }
            return i;
        }
        return plist.size() - 1;
    }

    public List<TData> loadTrigger(String pmid) {
        ArrayList<TData> list = new ArrayList<TData>();
        String sql = "Select pmid,tid,t_type,pos1,pos2,txt from TRIGGERS WHERE PMID LIKE '" + pmid + "'";
        try {
            this.rs = this.stmt.executeQuery(sql);
            while (this.rs.next()) {
                int[] pos = new int[2];
                String pid = this.rs.getString(1);
                String tid = this.rs.getString(2);
                String ttype = this.rs.getString(3);
                pos[0] = this.rs.getInt(4);
                pos[1] = this.rs.getInt(5);
                String txt = this.rs.getString(6);
                TData dt = new TData(pid, tid, ttype, pos, txt);
                list.add(dt);
            }
            this.rs.close();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        Collections.sort(list);
        return list;
    }

    public List<EData> loadEvent(String pmid) {
        ArrayList<EData> list = new ArrayList<EData>();
        String sql = "Select pmid,eid,t_type,trig_id,theme1,theme2,cause from event WHERE PMID LIKE '" + pmid + "'";
        try {
            this.rs = this.stmt.executeQuery(sql);
            while (this.rs.next()) {
                String pid = this.rs.getString(1);
                String eid = this.rs.getString(2);
                String ttype = this.rs.getString(3);
                String tid = this.rs.getString(4);
                String th1 = this.rs.getString(5);
                String th2 = this.rs.getString(6);
                String cause = this.rs.getString(7);
                EData dt = new EData(pid, eid, ttype, tid, th1, th2, cause);
                list.add(dt);
            }
            this.rs.close();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        return list;
    }

    public List<String> loadPMIDs() {
        String sql = "SELECT pmid FROM ABSTRACT";
        try {
            this.idList.clear();
            this.rs = this.stmt.executeQuery(sql);
            while (this.rs.next()) {
                String pmid = this.rs.getString(1);
                this.idList.add(pmid);
            }
            this.rs.close();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        return this.idList;
    }

    @Deprecated
    public String loadSimplified(String pmid) {
        String sql1 = "select text from simplify where pmid like '" + pmid + "'";
        String text = "";
        try {
            this.rs = this.stmt.executeQuery(sql1);
            while (this.rs.next()) {
                text = this.rs.getString("text");
            }
            this.rs.close();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        return text;
    }

    public String loadSentence(String pmid) {
        String sql1 = "select text from abstract where pmid like '" + pmid + "'";
        String text = "";
        try {
            this.rs = this.stmt.executeQuery(sql1);
            while (this.rs.next()) {
                text = this.rs.getString("text");
            }
            this.rs.close();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        return text;
    }

    public String trim(String txt) {
        String temp = txt;
        if (temp.endsWith(",") || temp.endsWith(";") || temp.endsWith(".") || temp.endsWith(":") || temp.endsWith("?") || temp.endsWith(")")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        if (temp.endsWith(")") || temp.endsWith("}") || temp.endsWith("]") || temp.endsWith("?") || temp.endsWith("\"")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        if (temp.startsWith("(") || temp.startsWith("-") || temp.startsWith("[") || temp.startsWith("\"")) {
            temp = temp.substring(1);
        }
        return temp;
    }

    public List<String[]> loadEquiv(String pmid) {
        String sql1 = "select tid1,tid2 from equiv where pmid like '" + pmid + "'";
        ArrayList<String[]> list = new ArrayList<String[]>();
        try {
            this.rs = this.stmt.executeQuery(sql1);
            String[] s = new String[2];
            while (this.rs.next()) {
                s = new String[]{this.rs.getString(1), this.rs.getString(2)};
                list.add(s);
            }
            this.rs.close();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        return list;
    }

    public void testSpliter() {
        String s = "";
        String[] txt = s.split(",");
        if (txt.length >= 1) {
            System.out.println("Values:" + txt[0] + " length: " + txt[0].length());
        }
        System.out.println("Length: " + txt.length);
    }

    public String[] brLine(String txt, String br) {
        int idx = txt.indexOf(br);
        String[] rst = new String[2];
        if (idx > 0) {
            rst[0] = txt.substring(0, idx);
            int off = br.equals("\n") ? 1 : 2;
            rst[1] = txt.substring(idx + off);
        } else {
            rst[0] = txt;
            rst[1] = null;
        }
        return rst;
    }

    @Deprecated
    public String[] abs2Sen(String txt, String br) {
        List<SentenceSplitter.BioSemSentence> ls2;
        String[] ab = this.brLine(txt, br);
        List<SentenceSplitter.BioSemSentence> ls1 = SentenceSplitter.spliter(ab[0]);
        if (ab[1] != null) {
            ls2 = SentenceSplitter.spliter(ab[1]);
            ls1.addAll(ls2);
        } else {
            ls2 = null;
        }
        ArrayList<String> sentences = new ArrayList<String>();
        for (int i = 0; i < ls1.size(); ++i) {
            sentences.add(ls1.get((int)i).text);
        }
        return sentences.toArray(new String[sentences.size()]);
    }

    public SentenceSplitter.BioSemSentence[] doSentenceSplitting(String txt, String br) {
        String[] ab = this.brLine(txt, br);
        List<SentenceSplitter.BioSemSentence> ls1 = SentenceSplitter.spliter(ab[0]);
        if (ab[1] != null) {
            int brIndex = txt.indexOf(br);
            List<SentenceSplitter.BioSemSentence> ls2 = SentenceSplitter.spliter(ab[1]);
            for (int i = 0; i < ls2.size(); ++i) {
                SentenceSplitter.BioSemSentence s = ls2.get(i);
                s.begin = s.begin + brIndex + 1;
                s.end = s.end + brIndex + 1;
            }
            ls1.addAll(ls2);
        } else {
            Object ls2 = null;
        }
        return ls1.toArray(new SentenceSplitter.BioSemSentence[ls1.size()]);
    }

    public int getSenIndex(int start, int[] subpos) {
        for (int i = subpos.length - 1; i > 0; --i) {
            if (start < subpos[i]) continue;
            return i;
        }
        return 0;
    }

    public int getOffset(int idx, int[] subpos) {
        return subpos[idx];
    }

    private void storeSentence(String pmid, String txt) {
        try {
            this.ps_sen.setString(1, pmid);
            this.ps_sen.setString(2, txt);
            this.ps_sen.executeUpdate();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public String[] doSimplifySentenceWise(SentenceSplitter.BioSemSentence[] originalSentences, String docId) {
        List<TData> plist = this.loadProtein(docId);
        int pIndex = plist.size() - 1;
        String[] simplifiedSentences = new String[originalSentences.length];
        for (int i = originalSentences.length - 1; i >= 0; --i) {
            SentenceSplitter.BioSemSentence sentence = originalSentences[i];
            StringBuilder sb = new StringBuilder(sentence.text);
            while (pIndex >= 0 && plist.get((int)pIndex).list[0] >= sentence.begin) {
                TData dt = plist.get(pIndex);
                String name = "PRO" + pIndex;
                sb = sb.replace(dt.list[0] - sentence.begin, dt.list[1] - sentence.begin, name);
                --pIndex;
            }
            simplifiedSentences[i] = sb.toString();
        }
        return simplifiedSentences;
    }

    @Deprecated
    public void doSimplify() {
        this.loadPMIDs();
        StringBuilder sb = new StringBuilder();
        String name = "";
        String ptxt = null;
        try {
            this.stmt.executeUpdate("DROP TABLE SIMPLIFY IF EXISTS");
            this.stmt.executeUpdate("CREATE CACHED TABLE SIMPLIFY(PMID VARCHAR(80), TEXT CLOB)");
            this.ps_sen = this.con.prepareStatement("INSERT INTO SIMPLIFY(PMID,TEXT) VALUES(?,?)");
            for (String s : this.idList) {
                sb = new StringBuilder();
                this.plist = this.loadProtein(s);
                String abtxt = this.loadSentence(s);
                sb.append(abtxt);
                for (int i = this.plist.size() - 1; i >= 0; --i) {
                    name = "PRO" + i;
                    TData dt = this.plist.get(i);
                    sb = sb.replace(dt.list[0], dt.list[1], name);
                    ptxt = abtxt.substring(dt.list[0], dt.list[1]);
                }
                this.storeSentence(s, sb.toString());
            }
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            System.out.println("Text " + sb.toString());
            System.out.println("Protein" + name);
            e.printStackTrace();
        }
        log.debug("Miss proteins: {}", (Object)this.pmiss_count);
    }

    public void closeDB() {
        if (this.db != null) {
            this.db.shutdownDB();
        }
    }

    public static void main(String[] args) {
    }

    static {
        String[] mod;
        log = LoggerFactory.getLogger(SenSimplifier.class);
        preps = new String[]{"of", "to", "between", "with", "by", "through", "on", "for", "in", "upon", "after", "via"};
        prepmap = new HashSet<String>();
        modifiers = new HashMap<String, String>();
        none_rel = new HashMap<String, String>();
        trigger_type = new String[]{"Gene_expression", "Transcription", "Protein_catabolism", "Phosphorylation", "Localization", "Binding", "Positive_regulation", "Regulation", "Negative_regulation", "Ubiquitination", "Protein_modification", "Deacetylation", "Acetylation"};
        hashType = new HashMap<String, Integer>();
        prepmap.addAll(Arrays.asList(preps));
        for (int i = 0; i < trigger_type.length; ++i) {
            hashType.put(trigger_type[i], i);
        }
        for (String s : TriggerLearner.none_rel) {
            none_rel.put(s, s);
        }
        for (String s : mod = new String[]{"gene", "genes", "nuclear", "nucleus", "mRNA", "mRNAs", "RNA", "transcripts", "transcript"}) {
            modifiers.put(s, s);
        }
    }
}

