/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import relations.RuleData;

public class RuleSets {
    Set<RuleData>[] rules = new HashSet[8];
    int[] count = new int[8];
    int[][] values = new int[8][4];
    int detected = 0;
    int total = 0;
    Set<String> frontPrep = new HashSet<String>();
    Set<String> prep = new HashSet<String>();
    Map<String, Set<String>> prepPair = new HashMap<String, Set<String>>();
    int dist1 = 0;
    int dist2 = 0;
    int fdist = 0;
    Set<String> order = new HashSet<String>();
    Set<String> causePrep = new HashSet<String>();
    boolean passive_order = true;

    public RuleSets() {
        for (int i = 0; i < 8; ++i) {
            this.rules[i] = new HashSet<RuleData>();
            for (int j = 0; j < 4; ++j) {
                this.values[i][j] = 0;
            }
            this.count[i] = 0;
        }
    }

    public RuleSets createRule(List<RuleData> ls) {
        RuleSets rl = new RuleSets();
        int count1 = 0;
        int count2 = 0;
        for (RuleData dt : ls) {
            int idx = this.getIdx(dt);
            rl.rules[idx].add(dt);
            this.countValues(dt, rl.values[idx]);
            int n = idx;
            rl.count[n] = rl.count[n] + dt.count;
            rl.total += dt.count;
            rl.detected = dt.detected;
            if (dt.theme_pos) {
                if (dt.cause_pos && !dt.prep2.isEmpty() && !dt.prep2.equals(dt.prep1)) {
                    Set<String> set = rl.prepPair.get(dt.prep_order ? dt.prep2 : dt.prep1);
                    if (set == null) {
                        set = new HashSet<String>();
                        if (dt.prep_order) {
                            rl.prepPair.put(dt.prep2, set);
                        } else {
                            rl.prepPair.put(dt.prep1, set);
                        }
                    }
                    if (dt.prep_order) {
                        rl.order.add(dt.prep2 + dt.prep1);
                        set.add(dt.prep1);
                        rl.prep.add(dt.prep2);
                    } else {
                        set.add(dt.prep2);
                        rl.prep.add(dt.prep1);
                    }
                }
                if (!dt.cause_pos && !dt.prep2.isEmpty()) {
                    rl.frontPrep.add(dt.prep2);
                }
                if (!dt.prep1.isEmpty()) {
                    rl.prep.add(dt.prep1);
                }
            } else if (!dt.theme_pos) {
                if (!dt.prep1.isEmpty()) {
                    rl.frontPrep.add(dt.prep1);
                }
                if (dt.cause_pos && !dt.prep2.isEmpty()) {
                    rl.prep.add(dt.prep2);
                }
            }
            if (idx == 1 || idx == 2 || idx == 3 || idx == 6) {
                rl.dist1 = Math.max(rl.dist1, dt.dist1);
                if (idx == 3) {
                    rl.dist2 = Math.max(rl.dist2, dt.dist2);
                }
            } else if (idx == 4 || idx == 5 || idx == 7) {
                rl.fdist = Math.max(rl.fdist, dt.dist1);
                if (idx == 5) {
                    rl.dist1 = Math.max(rl.dist1, dt.dist2);
                }
            }
            if (idx == 5 && !dt.prep2.isEmpty()) {
                rl.causePrep.add(dt.prep2);
            }
            if (!dt.has_cause || dt.verb_type != 1 || !dt.POS.equals("VBN")) continue;
            if (dt.cause_pos) {
                count1 += dt.count;
                continue;
            }
            count2 += dt.count;
        }
        if (count2 > count1) {
            rl.passive_order = false;
        }
        return rl;
    }

    private void countValues(RuleData dt, int[] val) {
        if (dt.event1) {
            val[1] = val[1] + dt.count;
        } else {
            val[0] = val[0] + dt.count;
        }
        if (dt.has_cause) {
            if (dt.event2) {
                val[3] = val[3] + dt.count;
            } else {
                val[2] = val[2] + dt.count;
            }
        }
    }

    private int getIdx(RuleData rule) {
        int idx = rule.in_chunk ? (rule.has_cause ? 1 : 0) : (rule.theme_pos ? (rule.has_cause ? (rule.cause_pos ? 3 : 6) : 2) : (rule.has_cause ? (rule.cause_pos ? 5 : 7) : 4));
        return idx;
    }

    public boolean isSkipped() {
        return (double)((float)this.total * 1.0f / (float)this.detected) < 0.1;
    }

    public boolean isSkipped(int type) {
        double score = (float)this.total * 1.0f / (float)this.detected;
        if (type < 5 && score < 0.1) {
            return true;
        }
        return type >= 5 && score < 0.12;
    }

    public boolean inChunk() {
        return (double)((float)(this.count[0] + this.count[1]) * 1.0f / (float)this.total) >= 0.1;
    }

    public double getInchunkCause() {
        return (float)this.count[1] * 1.0f / (float)(this.count[0] + this.count[1]);
    }

    public double getInChunkEvtScore() {
        return (float)this.values[1][1] * 1.0f / (float)(this.values[1][0] + this.values[1][1]);
    }

    public double getFrontScore() {
        return (float)this.count[4] * 1.0f / (float)this.total;
    }

    public double getBehindScore() {
        return (float)this.count[2] * 1.0f / (float)this.total;
    }

    public double getEvtScore(int idx) {
        int[] value = this.values[idx];
        return (float)value[1] * 1.0f / (float)(value[0] + value[1]);
    }

    public double getProScore(int idx) {
        int[] value = this.values[idx];
        return (float)value[0] * 1.0f / (float)(value[0] + value[1]);
    }

    public double getEvtCause(int idx) {
        int[] value = this.values[idx];
        return (float)value[3] * 1.0f / (float)(value[2] + value[3]);
    }

    public double getProCause(int idx) {
        int[] value = this.values[idx];
        return (float)value[2] * 1.0f / (float)(value[2] + value[3]);
    }

    public double getCauseScore() {
        return (float)(this.count[3] + this.count[5] + this.count[6] + this.count[7]) * 1.0f / (float)(this.total - this.count[0] - this.count[1]);
    }
}

