/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import parser.Parser;
import relations.Chunk;
import relations.ChunkAnalyzer;
import relations.Counter;
import relations.EData;
import relations.EventExtraction;
import relations.KeyData;
import relations.PData;
import relations.RuleData;
import relations.RuleSet;
import relations.Rules;
import relations.SenSimplifier;
import relations.TData;
import relations.Word;
import utils.DBUtils;

public class Eval {
    SenSimplifier sim;
    FileWriter writer;
    List<Word>[] allTrgs = new ArrayList[9];
    Map<String, String> proIDMap = new HashMap<String, String>();
    Map<String, TData> mprotein = new HashMap<String, TData>();
    Map<String, TData> mtrigger = new HashMap<String, TData>();
    Map<String, EData> mevent = new HashMap<String, EData>();
    List<TData> plist;
    List<TData> tlist;
    List<EData> elist;
    String simp;
    String[] simpsen;
    String pname;
    String tg_name;
    String[] longsen;
    TData tgr;
    TData prt;
    int[] full_pos;
    int trg_id = 0;
    int ev_id = 0;
    public Map<PData, String> evtMap = new HashMap<PData, String>();
    public Map<Word, PData> proMap = new HashMap<Word, PData>();
    public Map<Word, String> trgIDMap = new HashMap<Word, String>();
    int event_count = 0;
    List<EData>[] events;
    Map<String, String> compMap = new HashMap<String, String>();
    boolean run_1 = false;
    StringBuilder sbtxt = new StringBuilder();
    String[] trigger_type = new String[]{"Gene_expression", "Transcription", "Protein_catabolism", "Phosphorylation", "Localization", "Binding", "Positive_regulation", "Regulation", "Negative_regulation"};
    Map<String, Integer> hashType = new HashMap<String, Integer>();
    String senText;

    public Eval() {
        int i = 0;
        for (String s : this.trigger_type) {
            this.hashType.put(s, new Integer(i));
            this.allTrgs[i] = new ArrayList<Word>();
            ++i;
        }
    }

    public Eval(SenSimplifier simp) {
        this.sim = simp;
        int i = 0;
        for (String s : this.trigger_type) {
            this.hashType.put(s, new Integer(i));
            this.allTrgs[i] = new ArrayList<Word>();
            ++i;
        }
    }

    public int findPos(int[] loc, Word[] w) {
        for (int i = 0; i < w.length; ++i) {
            if (loc[0] != w[i].loc && loc[1] != w[i].loc + w[i].word.length()) continue;
            return w[i].pos;
        }
        return -1;
    }

    public void printEvents(String id) {
        this.sim.loadDict(null);
        this.initAbstract(id);
        List<EData>[] levents = this.splitEvents(this.elist);
        Parser analyzer = new Parser();
        try {
            for (int i = 0; i < levents.length; ++i) {
                List<EData> list = levents[i];
                System.out.println(this.simpsen[i]);
                analyzer.printChunk(this.simpsen[i]);
                for (EData eData : list) {
                    System.out.println(eData.getTxt(0));
                }
                System.out.println("");
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getCause());
        }
    }

    public void countLevel() {
        DBUtils db = new DBUtils();
        HashMap<Integer, Counter> map = new HashMap<Integer, Counter>();
        this.sim.loadDict(db);
        List<String> pmids = this.sim.loadPMIDs();
        for (String st : pmids) {
            this.initAbstract(st);
            for (EData edt : this.elist) {
                int k = edt.getLevel(0);
                if (k >= 4) {
                    System.out.println(edt.getTxt(0));
                }
                if (map.containsKey(k)) {
                    ((Counter)map.get(k)).inc();
                    continue;
                }
                Counter ct = new Counter();
                map.put(k, ct);
            }
        }
        for (Integer i : map.keySet()) {
            System.out.println("Level: " + i + "  " + ((Counter)map.get((Object)i)).count);
        }
    }

    public void printEventbyType(int type, String trg) {
        DBUtils db = new DBUtils();
        String dbpaht = "D:/DataNLP/Dev2011/Data";
        db.openDB(dbpaht);
        this.sim = new SenSimplifier(db);
        int total = 0;
        boolean match = false;
        boolean detected = false;
        boolean count = false;
        List<String> pmids = this.sim.loadPMIDs();
        boolean print = false;
        try {
            for (String id : pmids) {
                if (!this.initAbstract(id)) continue;
                List<EData>[] levents = this.splitEvents(this.elist);
                int loop = this.simpsen.length;
                for (int i = 0; i < loop; ++i) {
                    print = false;
                    for (EData ed : levents[i]) {
                        int ev_type = SenSimplifier.hashType.get(ed.type);
                        if (ev_type != type) continue;
                        TData tg = ed.trgdata;
                        if (!tg.name.toLowerCase().contains(trg)) continue;
                        if (!print) {
                            System.out.println(id + " " + i + " " + this.simpsen[i]);
                            print = true;
                        }
                        System.out.println(ed.getTxt(0));
                        ++total;
                    }
                    if (!print) continue;
                    System.out.println("");
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
        System.out.println("Total event found: " + total);
    }

    public void printEventType(int type) {
        DBUtils db = new DBUtils();
        String dbpaht = "D:/DataNLP/Dev2011/Data";
        db.openDB(dbpaht);
        this.sim = new SenSimplifier(db);
        int total = 0;
        boolean match = false;
        boolean detected = false;
        boolean count = false;
        List<String> pmids = this.sim.loadPMIDs();
        boolean print = false;
        String key = " dependent";
        String key2 = " ";
        int sen_count = 0;
        try {
            for (String id : pmids) {
                if (!this.initAbstract(id)) continue;
                List<EData>[] levents = this.splitEvents(this.elist);
                int loop = this.simpsen.length;
                for (int i = 0; i < loop; ++i) {
                    if (!this.simpsen[i].contains(key) || !this.simpsen[i].contains(key2)) continue;
                    ++sen_count;
                    int begin = this.full_pos[i];
                    int end = begin + this.longsen[i].length();
                    print = false;
                    for (EData ed : levents[i]) {
                        int ev_type = SenSimplifier.hashType.get(ed.type);
                        if (ev_type != type) {
                            // empty if block
                        }
                        TData tg = ed.trgdata;
                        if (!this.inSentence(begin, end, ed) || !tg.name.toLowerCase().equals("dependent")) continue;
                        if (!print) {
                            System.out.println(id + " " + i + " " + this.simpsen[i]);
                            print = true;
                        }
                        System.out.println(ed.getTxt(0));
                        ++total;
                    }
                    if (!print) continue;
                    System.out.println("");
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
        System.out.println("Total event found: " + total + " number of sentences: " + sen_count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printFile(String path, String dest) {
        File file = new File(path);
        BufferedReader reader = null;
        try {
            String text;
            reader = new BufferedReader(new FileReader(file));
            FileWriter fw = new FileWriter(dest);
            while ((text = reader.readLine()) != null) {
                if (!text.contains("verexpression")) continue;
                fw.append(text);
                fw.append("\n");
            }
            fw.close();
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getCause());
        }
        catch (IOException e) {
            System.out.println(e.getCause());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getCause());
            }
        }
    }

    public void evalSimple() {
        TData tg = null;
        boolean total = false;
        String sr_path = "D:/DataNLP/Mix2011/Data";
        String dest_path = "D:/DataNLP/Dev2011/Data";
        DBUtils db_sr = new DBUtils();
        db_sr.openDB(sr_path);
        DBUtils dbdest = new DBUtils();
        dbdest.openDB(dest_path);
        boolean smiss = false;
        ArrayList emiss = new ArrayList();
        EventExtraction ex = new EventExtraction(db_sr, dbdest);
        this.sim = ex.simp;
        List<String> pmids = this.sim.loadPMIDs();
        System.out.println("Loading done: " + pmids.size());
        Word trg = null;
        int[] match = new int[9];
        int[] detected = new int[9];
        int[] totals = new int[9];
        HashSet<EData> miss_list = new HashSet<EData>();
        HashSet<PData> dlist = new HashSet<PData>();
        HashSet<PData> allpair = new HashSet<PData>();
        int ttype = 0;
        String tgname = "binds";
        try {
            ex.init();
            for (String id : pmids) {
                this.initAbstract(id);
                ex.initSentence(id);
                List<EData>[] elists = this.splitEvents(this.elist);
                for (int i = 0; i < this.simpsen.length; ++i) {
                    ex.extractedSet.clear();
                    ex.extractedMap.clear();
                    ex.extractSentence(i);
                    int start = this.full_pos[i];
                    int end = start + this.longsen[i].length();
                    miss_list.clear();
                    dlist.clear();
                    allpair.clear();
                    for (EData edt : elists[i]) {
                        int etype = SenSimplifier.hashType.get(edt.type);
                        if (etype != ttype) continue;
                        int n = etype;
                        totals[n] = totals[n] + 1;
                        if (!this.inSentence(start, end, edt)) continue;
                        boolean check = edt.trgdata.name.toLowerCase().equals(tgname) ? true : true;
                        if (!edt.trgdata.equals(tg)) {
                            tg = edt.trgdata;
                            trg = null;
                            for (Word w : ex.extractedMap.keySet()) {
                                if (w.locs[0] != tg.list[0] && w.locs[1] != tg.list[1]) continue;
                                trg = w;
                                break;
                            }
                        }
                        if (check && trg != null) {
                            List<PData> list = ex.extractedMap.get(trg);
                            boolean found = false;
                            for (PData pdt : list) {
                                found = this.compareEvent(pdt, edt);
                                if (!found) continue;
                                int n2 = ttype;
                                match[n2] = match[n2] + 1;
                                dlist.add(pdt);
                                break;
                            }
                            if (found) continue;
                            miss_list.add(edt);
                            continue;
                        }
                        if (!ex.dic.containsKey(tg.name.toLowerCase()) || !check) continue;
                        miss_list.add(edt);
                    }
                    for (PData pdt : ex.extractedSet) {
                        if (SenSimplifier.hashType.get(pdt.evt_type) != ttype) continue;
                        if (!pdt.trg.word.equals(tgname)) {
                            // empty if block
                        }
                        allpair.add(pdt);
                        int n = ttype;
                        detected[n] = detected[n] + 1;
                    }
                    allpair.removeAll(dlist);
                    if (miss_list.size() <= 0 && allpair.size() <= 0) continue;
                    System.out.println(id + " " + i + ": " + this.simpsen[i]);
                    ex.printChunkList();
                    if (miss_list.size() > 0) {
                        System.out.println("----miss-------> ");
                        for (EData edt : miss_list) {
                            System.out.println(edt.getTxt(0));
                        }
                    }
                    if (allpair.size() > 0) {
                        System.out.println("--------------------- false positive --------");
                        for (PData pdt : allpair) {
                            System.out.println(" --> " + pdt.getText());
                        }
                    }
                    System.out.println("");
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
        for (int i = ttype; i <= ttype; ++i) {
            System.out.println("match: " + match[i] + " | Detected: " + detected[i]);
            double rc = 1.0f * (float)match[i] / (float)totals[i];
            double pc = 1.0f * (float)match[i] / (float)detected[i];
            double fc = rc * pc * 2.0 / (rc + pc);
            System.out.println("Type: " + i + " PC: " + pc + "   RC: " + rc + "  FSCORE: " + fc);
        }
        db_sr.closeDB();
    }

    private boolean inSentence(int begin, int end, EData ev) {
        boolean theme = false;
        boolean cause = false;
        TData tg = ev.trgdata;
        if (tg.list[0] >= begin && tg.list[1] <= end) {
            TData pr2;
            if (ev.data1 instanceof TData) {
                TData pr1 = (TData)ev.data1;
                if (pr1.list[0] >= begin && pr1.list[1] <= end) {
                    theme = true;
                }
            } else {
                EData ev1 = (EData)ev.data1;
                theme = this.inSentence(begin, end, ev1);
            }
            if (ev.ecause != null) {
                if (ev.ecause instanceof EData) {
                    cause = this.inSentence(begin, end, (EData)ev.ecause);
                } else {
                    pr2 = (TData)ev.ecause;
                    if (pr2.list[0] >= begin && pr2.list[1] <= end) {
                        cause = true;
                    }
                }
            } else if (ev.data2 != null) {
                pr2 = ev.data2;
                if (pr2.list[0] >= begin && pr2.list[1] <= end) {
                    cause = true;
                }
            } else {
                cause = true;
            }
            if (theme && cause) {
                return true;
            }
        }
        return false;
    }

    public void evalReg() {
        TData tg = null;
        boolean total = false;
        String sr_path = "D:/DataNLP/Train2011/Data";
        String dest_path = "D:/DataNLP/Dev2011/Data";
        DBUtils db_sr = new DBUtils();
        db_sr.openDB(sr_path);
        DBUtils dbdest = new DBUtils();
        dbdest.openDB(dest_path);
        int skip_count = 0;
        ArrayList emiss = new ArrayList();
        EventExtraction ex = new EventExtraction(db_sr, dbdest);
        this.sim = ex.simp;
        List<String> pmids = this.sim.loadPMIDs();
        System.out.println("Loading done: " + pmids.size());
        Word trg = null;
        int[] match = new int[9];
        int[] detected = new int[9];
        int[] totals = new int[9];
        HashSet<EData> miss_list = new HashSet<EData>();
        HashSet<PData> dlist = new HashSet<PData>();
        HashSet<PData> allpair = new HashSet<PData>();
        int ttype = 7;
        int level_2 = 0;
        int tg_all = 0;
        int tgcount = 0;
        HashMap<String, Counter> counter = new HashMap<String, Counter>();
        String tgname = "effect";
        try {
            ex.init();
            for (String id : pmids) {
                this.initAbstract(id);
                ex.initSentence(id);
                List<EData>[] elists = this.splitEvents(this.elist);
                for (int i = 0; i < this.simpsen.length; ++i) {
                    ex.extractedSet.clear();
                    ex.extractedMap.clear();
                    ex.extractSentence(i);
                    int start = this.full_pos[i];
                    int end = start + this.longsen[i].length();
                    miss_list.clear();
                    dlist.clear();
                    allpair.clear();
                    boolean print = false;
                    for (EData edt : elists[i]) {
                        int etype = SenSimplifier.hashType.get(edt.type);
                        if (!this.inSentence(start, end, edt) || etype != ttype) continue;
                        int n = etype;
                        totals[n] = totals[n] + 1;
                        int level = edt.getLevel(0);
                        if (level > 2) {
                            ++level_2;
                            continue;
                        }
                        if (!edt.trgdata.equals(tg)) {
                            tg = edt.trgdata;
                            ++tg_all;
                            trg = null;
                            for (Word w : ex.extractedMap.keySet()) {
                                if (w.locs[0] != tg.list[0] && w.locs[1] != tg.list[1]) continue;
                                trg = w;
                                ++tgcount;
                                break;
                            }
                        }
                        String trgkey = tg.name.toLowerCase();
                        boolean found = false;
                        if (trg != null) {
                            List<PData> list = ex.extractedMap.get(trg);
                            for (PData pdt : list) {
                                found = this.compareRegEvent(pdt, edt);
                                if (!found) continue;
                                int n2 = etype;
                                match[n2] = match[n2] + 1;
                                dlist.add(pdt);
                                break;
                            }
                            if (!found && trgkey.equals(tgname)) {
                                miss_list.add(edt);
                            }
                        } else if (ex.dic.containsKey(trgkey) && trgkey.equals(tgname)) {
                            miss_list.add(edt);
                        }
                        if (!ex.dic.containsKey(trgkey) || found && trg != null) continue;
                        Counter ct = (Counter)counter.get(trgkey);
                        if (ct == null) {
                            ct = new Counter(1);
                            counter.put(trgkey, ct);
                            continue;
                        }
                        ct.inc();
                    }
                    for (PData pdt : ex.extractedSet) {
                        if (SenSimplifier.hashType.get(pdt.evt_type) != ttype) continue;
                        allpair.add(pdt);
                        int n = ttype;
                        detected[n] = detected[n] + 1;
                    }
                    allpair.removeAll(dlist);
                    if (miss_list.size() > 0) {
                        if (!print) {
                            System.out.println(id + " " + i + ": " + this.simpsen[i]);
                            ex.printChunkList();
                            print = true;
                        }
                        System.out.println("------------- mis events: ------------------>>");
                        for (EData edt : miss_list) {
                            System.out.println(edt.getTxt(0));
                        }
                    }
                    if (allpair.size() > 0) {
                        for (PData pdt : allpair) {
                            if (dlist.contains(pdt) || !pdt.trg.word.equals(tgname)) continue;
                            if (!print) {
                                System.out.println(id + " " + i + ": " + this.simpsen[i]);
                                ex.printChunkList();
                                System.out.println("---------------------false positive ------------------");
                                print = true;
                            }
                            System.out.println("-->" + pdt.getText());
                        }
                    }
                    if (!print) continue;
                    System.out.println("");
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
        System.out.println("-------------------------------------------------------------");
        int tg_count = 0;
        for (String s : counter.keySet()) {
            Counter ct = (Counter)counter.get(s);
            tg_count += ct.count;
            System.out.println(s + ":" + ct.count);
        }
        System.out.println("Total known tg miss: " + tg_count);
        System.out.println("-------------------------------------------------------------");
        System.out.println("TG recall:" + (float)tgcount * 1.0f / (float)tg_all + " total known tg: " + tg_all);
        System.out.println("Level >=2 " + level_2);
        System.out.println("Skip due to not in the same sentence " + skip_count);
        for (int i = ttype; i <= ttype; ++i) {
            System.out.println("Total:" + totals[i] + "  | match: " + match[i] + " | Detected: " + detected[i]);
            double rc = 1.0f * (float)match[i] / (float)totals[i];
            double pc = 1.0f * (float)match[i] / (float)detected[i];
            double fc = rc * pc * 2.0 / (rc + pc);
            System.out.println("Type: " + i + " PC: " + pc + "   RC: " + rc + "  FSCORE: " + fc);
        }
        db_sr.closeDB();
    }

    private boolean compareRegEvent(PData pdt, EData ev) {
        boolean theme = false;
        boolean cause = false;
        if (ev.type.equals(pdt.evt_type)) {
            TData tg = ev.trgdata;
            Word w = pdt.trg;
            if (w.locs[0] == tg.list[0] || w.locs[1] == tg.list[1]) {
                if (ev.data1 instanceof TData) {
                    TData pr1 = (TData)ev.data1;
                    if (pdt.pro1 != null && pdt.pro1.TID.equals(pr1.tid)) {
                        theme = true;
                    }
                } else if (pdt.pdata1 != null) {
                    EData ev1 = (EData)ev.data1;
                    theme = this.compareRegEvent(pdt.pdata1, ev1);
                }
                if (ev.ecause != null) {
                    if (ev.ecause instanceof EData) {
                        if (pdt.pdata2 != null) {
                            cause = this.compareRegEvent(pdt.pdata2, (EData)ev.ecause);
                        }
                    } else {
                        TData pr2 = (TData)ev.ecause;
                        if (pdt.pro2 != null && pdt.pro2.TID.equals(pr2.tid)) {
                            cause = true;
                        }
                    }
                } else {
                    cause = true;
                }
                if (theme && cause) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean compareEvent(PData pdt, EData ev) {
        boolean theme = false;
        boolean cause = false;
        if (ev.type.equals(pdt.evt_type)) {
            TData tg = ev.trgdata;
            Word w = pdt.trg;
            if (w.locs[0] == tg.list[0] || w.locs[1] == tg.list[1]) {
                TData pr1 = (TData)ev.data1;
                if (pdt.pro1 != null && pdt.pro1.TID.equals(pr1.tid)) {
                    theme = true;
                }
                if (ev.data2 != null) {
                    TData pr2 = ev.data2;
                    if (pdt.pro2 != null && pdt.pro2.TID.equals(pr2.tid)) {
                        cause = true;
                    }
                } else {
                    cause = true;
                }
                if (theme && cause) {
                    return true;
                }
            }
        }
        return false;
    }

    public void DictEval() {
        List<String> pmids = this.sim.loadPMIDs();
        this.sim.loadDict(null);
        Map<String, KeyData> dic = this.sim.sharedDic;
        int[] load = new int[9];
        int[] found = new int[9];
        try {
            for (String id : pmids) {
                if (!this.initAbstract(id)) continue;
                for (EData ev : this.elist) {
                    int idx = SenSimplifier.hashType.get(ev.type);
                    if (dic.containsKey(ev.trgdata.name.toLowerCase())) {
                        int n = idx;
                        found[n] = found[n] + 1;
                    }
                    int n = idx;
                    load[n] = load[n] + 1;
                }
            }
            for (int i = 0; i < 9; ++i) {
                System.out.println("Type: " + this.trigger_type[i] + " Recall: " + 1.0f * (float)found[i] / (float)load[i]);
            }
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
    }

    public void printAllSentence(int type) {
        List<String> pmids = this.sim.loadPMIDs();
        Parser analyzer = new Parser();
        ChunkAnalyzer operator = new ChunkAnalyzer();
        int count = 0;
        int total = 0;
        HashMap map = new HashMap();
        try {
            for (String id : pmids) {
                String txt = this.sim.loadSimplified(id);
                this.simpsen = this.sim.abs2Sen(txt, "\n");
                int loop = this.simpsen.length;
                block3: for (int i = 0; i < loop; ++i) {
                    analyzer.id = id;
                    analyzer.senid = i;
                    String[] tokens = analyzer.splitWord(this.simpsen[i]);
                    List<Chunk> ls = analyzer.parse(tokens);
                    ++total;
                    for (int j = 1; j < ls.size() - 1; ++j) {
                        Chunk prev = ls.get(j);
                        if (!prev.type.equals("VP")) continue;
                        Chunk c = ls.get(j - 1);
                        if (!c.txt.equals(",")) continue;
                        System.out.println("--> " + prev.getValues());
                        this.printChunk(ls);
                        ++count;
                        continue block3;
                    }
                }
                if (count <= 1000) continue;
                break;
            }
            System.out.println("--total sentences found-- " + count + "  over " + total);
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
    }

    private void printChunk(List<Chunk> ls) {
        for (Chunk c : ls) {
            System.out.print("[" + c.type + " " + c.txt + "] ");
        }
        System.out.println("");
    }

    public void printCompoundEvent(int type) {
        int scount = 0;
        int ecount = 0;
        List<String> pmids = this.sim.loadPMIDs();
        boolean print = false;
        try {
            for (String id : pmids) {
                if (!this.initAbstract(id)) continue;
                List<EData>[] levents = this.splitEvents(this.elist);
                int loop = this.simpsen.length;
                for (int i = 0; i < loop; ++i) {
                    print = false;
                    for (EData ed : levents[i]) {
                        TData pro = ed.getPro();
                        if (this.simpsen[i].contains(pro.new_name + "/")) {
                            if (!print) {
                                print = true;
                                System.out.println(this.simpsen[i]);
                            }
                            ++scount;
                            System.out.println(ed.getTxt(0));
                            continue;
                        }
                        if (!this.simpsen[i].contains("/" + pro.new_name)) continue;
                        if (!print) {
                            print = true;
                            System.out.println(this.simpsen[i]);
                        }
                        ++ecount;
                        System.out.println(ed.getTxt(0));
                    }
                    if (!print) continue;
                    System.out.println("");
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getCause());
        }
        System.out.println("Found: " + scount + " total: " + ecount);
        if (this.compMap.size() > 0) {
            for (String s : this.compMap.keySet()) {
                System.out.println(s);
            }
        }
    }

    private Word findTrigger(int[] loc, List<Word> relWord) {
        for (Word w : relWord) {
            if (w.locs[0] < loc[0] || w.locs[1] > loc[1]) continue;
            return w;
        }
        return null;
    }

    public boolean initAbstract(String pid) {
        this.senText = this.sim.loadSentence(pid);
        if (this.senText == null) {
            System.out.println("PMID: " + pid + " -> no text");
            return false;
        }
        this.plist = this.sim.loadProtein(pid);
        this.tlist = this.sim.loadTrigger(pid);
        this.elist = this.sim.loadEvent(pid);
        this.simp = this.sim.loadSimplified(pid);
        this.simpsen = this.sim.abs2Sen(this.simp, "\n");
        this.longsen = this.sim.abs2Sen(this.senText, "\n");
        this.full_pos = new int[this.longsen.length];
        if (this.simpsen.length != this.longsen.length) {
            System.out.println("Skip ---> " + pid);
            return false;
        }
        this.sbtxt = new StringBuilder(this.senText);
        for (int i = 1; i < this.simpsen.length; ++i) {
            this.full_pos[i] = this.senText.indexOf(this.longsen[i], this.full_pos[i - 1]);
        }
        this.mprotein.clear();
        for (TData dt : this.plist) {
            this.mprotein.put(dt.tid, dt);
        }
        this.mtrigger.clear();
        for (TData dt : this.tlist) {
            this.mtrigger.put(dt.tid, dt);
        }
        this.mevent.clear();
        for (EData edt : this.elist) {
            this.mevent.put(edt.eid, edt);
        }
        for (EData ed : this.elist) {
            ed.init(this.mprotein, this.mtrigger, this.mevent);
        }
        return true;
    }

    public void printCompoundTrigger(TData tg, List<Word> ls) {
        int pos = tg.list[0] - 1;
        if (pos >= 0 && this.sbtxt.charAt(pos) == '-') {
            String sub = this.sbtxt.substring(tg.list[0], tg.list[1]);
            for (Word w : ls) {
                if (!w.compound || !w.word.equals(sub) || tg.list[0] > w.locs[0] || tg.list[1] < w.locs[1]) continue;
                System.out.println("TG: " + sub + " pos: " + tg.list[0] + "-" + tg.list[1] + "  Detected: " + w.fullword + "  pos: " + w.locs[0] + " " + w.locs[1]);
            }
            ++this.event_count;
        }
    }

    public List<EData>[] splitEvents(List<EData> list) {
        List[] dlist = new List[this.simpsen.length];
        for (int i = 0; i < this.simpsen.length; ++i) {
            dlist[i] = new ArrayList();
        }
        for (EData dt : list) {
            TData tg = this.mtrigger.get(dt.trigID);
            int pos = tg.list[0];
            int idx = this.pos2sen(this.full_pos, pos);
            dlist[idx].add(dt);
        }
        return dlist;
    }

    public List<TData>[] splitData(List<TData> list) {
        List[] dlist = new List[this.simpsen.length];
        for (int i = 0; i < this.simpsen.length; ++i) {
            dlist[i] = new ArrayList();
        }
        for (TData dt : list) {
            int pos = dt.list[0];
            int idx = this.pos2sen(this.full_pos, pos);
            dlist[idx].add(dt);
        }
        return dlist;
    }

    public List<Word>[] splitTrg(List<Word> list) {
        List[] dlist = new List[this.simpsen.length];
        for (int i = 0; i < this.simpsen.length; ++i) {
            dlist[i] = new ArrayList();
        }
        for (Word dt : list) {
            int pos = dt.locs[0];
            int idx = this.pos2sen(this.full_pos, pos);
            dlist[idx].add(dt);
        }
        return dlist;
    }

    public void test() {
        String sr_path = "D:/DataNLP/Mix2011/Data";
        DBUtils sr = new DBUtils();
        sr.openDB(sr_path);
        Map<String, Rules>[] rule1 = this.sim.loadPatterns(sr);
        this.sim.loadDict(sr);
        KeyData kdt = this.sim.sharedDic.get("induction");
        kdt = kdt.getDefault();
        Rules rules = rule1[6].get("induction");
        List<RuleData> ls = rules.getEvalRules("NNNP");
        int count = 0;
        int miss = 0;
        if (ls != null) {
            for (RuleData dt : ls) {
                for (String s : dt.childMap) {
                    if (!kdt.child.contains(s)) {
                        System.out.println("Miss: " + s);
                        ++miss;
                        continue;
                    }
                    ++count;
                }
            }
        }
        System.out.println("Found: " + count + "  miss: " + miss);
        sr.closeDB();
    }

    public static void main(String[] args) {
        Eval xt = new Eval();
        xt.evalReg();
    }

    public void comparePatterns() {
        String sr_path = "D:/DataNLP/Mix2011/Data";
        DBUtils sr = new DBUtils();
        sr.openDB(sr_path);
        Map<String, RuleSet> rules = this.sim.loadRuleSet(sr);
        System.out.println("Number of rules: " + rules.size());
        sr.closeDB();
    }

    private int pos2sen(int[] senpos, int pos) {
        for (int i = senpos.length - 1; i > 0; --i) {
            if (pos < senpos[i]) continue;
            return i;
        }
        return 0;
    }

    private int toType(String type) {
        return this.hashType.get(type);
    }
}

