/*
 * Decompiled with CFR 0.152.
 */
package relations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import parser.Parser;
import relations.BasicChunk;
import relations.Chunk;
import relations.VerbChunk;
import relations.Word;

public class ChunkAnalyzer {
    List<BasicChunk> bsList = new ArrayList<BasicChunk>();
    List<VerbChunk> verbList = new ArrayList<VerbChunk>();
    boolean has_stop = false;
    boolean shared_sub = false;
    boolean reduced_clause = false;
    boolean has_breaker = false;
    boolean next_clause = false;
    boolean has_comma = false;
    boolean use_prev_obj = false;
    String[] pos_tags;
    String[] stokens;
    public String curr_text;
    int sub_count = 0;
    boolean print = false;
    int next_pos = 0;
    public boolean print_chunk = false;
    public int count_chunk = 0;
    boolean debug = false;
    public Set<String> prepMap = new HashSet<String>(15);
    public Set<String> appoMap = new HashSet<String>(5);
    public Set<String> breakMap = new HashSet<String>(25);
    public Set<String> skipMap = new HashSet<String>(10);
    public Set<String> is_a_Map = new HashSet<String>(10);
    public Set<String> extraMap = new HashSet<String>(10);
    public Set<String> ccMap = new HashSet<String>(10);
    public Set<String> beMap = new HashSet<String>(10);
    public Set<String> allMap = new HashSet<String>(50);
    String[] prepList = new String[]{"to", "with", "from", "of", "on", "in", "upon", "by", "for", "after", "through", "between", "via"};
    String[] skipList = new String[]{"not", "neither", "-", "\"", "'", "both", "also", "nor", "(", "]", "[", ")"};
    String[] breakList = new String[]{"while", "when", "whereas", "although", "if", "because", "even though", "whether", "since", "that", "whenever", "whatever", "before", "how", "which", ";", "."};
    String[] ccList = new String[]{"and", "or", "but", "as well as", "but not"};
    String[] appoList = new String[]{"like", "such as", "including", "includes", "containing"};
    String[] to_be = new String[]{"be", "is", "are", "was", "were", "been"};
    String[] is_a = new String[]{"had", "have", "has"};

    public ChunkAnalyzer() {
        this.prepMap.addAll(Arrays.asList(this.prepList));
        this.breakMap.addAll(Arrays.asList(this.breakList));
        this.skipMap.addAll(Arrays.asList(this.skipList));
        this.ccMap.addAll(Arrays.asList(this.ccList));
        this.appoMap.addAll(Arrays.asList(this.appoList));
        this.beMap.addAll(Arrays.asList(this.to_be));
        this.allMap.addAll(this.ccMap);
        this.allMap.addAll(this.breakMap);
    }

    public void cleanChunk(List<Chunk> ls, String[] tags, String[] tokens) {
        this.pos_tags = tags;
        this.stokens = tokens;
        this.dropChunks(ls);
        this.groupVerbPhrase(ls);
        this.printChunk(ls);
    }

    public void analyzeChunk(List<Chunk> ls, String[] tags, String[] tokens) {
        HashSet shared = new HashSet();
        this.bsList.clear();
        this.verbList.clear();
        this.pos_tags = tags;
        this.stokens = tokens;
        this.debug = false;
        int i = 0;
        Chunk br = null;
        Chunk c = ls.get(ls.size() - 1);
        if (!c.txt.equals(".")) {
            Chunk o_c = new Chunk("O");
            o_c.txt = ".";
            o_c.begin = c.end + 1;
            o_c.end = c.end + 2;
            ls.add(o_c);
        }
        this.dropChunks(ls);
        this.groupVerbPhrase(ls);
        this.dropChunks(ls);
        List<Chunk> vbs = this.findVerbChunk(ls);
        List<Chunk> breaker = this.findBreaker(ls);
        int br_idx = 0;
        BasicChunk prev_sub = null;
        BasicChunk prev_obj = null;
        int start = 0;
        int end = 0;
        int next_start = 0;
        this.next_pos = 0;
        this.has_stop = false;
        this.shared_sub = false;
        this.has_breaker = false;
        while (i < vbs.size()) {
            BasicChunk object;
            BasicChunk sub;
            Chunk cur_vb = vbs.get(i);
            int vbidx = ls.indexOf(cur_vb);
            boolean merged = false;
            int vb_type = this.getVerbChunkType(cur_vb);
            if (!this.shared_sub) {
                start = this.skipPhrase(ls, start, vbidx);
                if (vb_type == 2 && start == vbidx) {
                    merged = true;
                }
            }
            this.use_prev_obj = false;
            if (br_idx < breaker.size() || br != null) {
                int k;
                BasicChunk bs;
                if (br_idx < breaker.size() && br == null) {
                    br = breaker.get(br_idx);
                    ++br_idx;
                }
                int pos = ls.indexOf(br);
                if (((br.txt.equals("whether") || br.txt.equals("that")) && br.type.equals("PP") || br.type.equals("SBAR")) && pos > 0 && br.begin < cur_vb.begin) {
                    if (start < pos) {
                        bs = new BasicChunk();
                        for (k = start; k < pos; ++k) {
                            bs.addChunk(ls.get(k));
                        }
                        this.bsList.add(bs);
                        start = pos + 1;
                    }
                    br = breaker.get(br_idx);
                    ++br_idx;
                    pos = ls.indexOf(br);
                }
                if (br.begin < cur_vb.begin) {
                    if (br.type.equals("NP") && vbidx - pos <= 2 && (br.txt.equals("which") || br.txt.equals("that"))) {
                        if (!this.hasNounChunk(pos + 1, ls, vbidx)) {
                            this.use_prev_obj = true;
                            this.has_breaker = true;
                        } else if (start < pos) {
                            bs = new BasicChunk();
                            for (k = start; k < pos; ++k) {
                                bs.addChunk(ls.get(k));
                            }
                            this.bsList.add(bs);
                            start = pos + 1;
                        }
                    } else {
                        if (start < pos) {
                            bs = new BasicChunk();
                            for (k = start; k < pos; ++k) {
                                bs.addChunk(ls.get(k));
                            }
                            this.bsList.add(bs);
                            start = pos + 1;
                        }
                        this.has_breaker = true;
                    }
                    while (br_idx < breaker.size() && br.begin < cur_vb.begin) {
                        br = breaker.get(br_idx);
                        ++br_idx;
                    }
                }
                if (this.reduced_clause) {
                    this.use_prev_obj = true;
                    this.reduced_clause = false;
                    merged = true;
                }
                if (i + 1 < vbs.size()) {
                    Chunk temp = vbs.get(i + 1);
                    int next_vb_type = this.getVerbChunkType(temp);
                    int next_vb = ls.indexOf(temp);
                    if (next_vb > (pos = ls.indexOf(br)) && (br.txt.equals("that") || br.txt.contains("whether")) && (br.type.equals("PP") || br.type.equals("SBAR"))) {
                        next_start = pos + 1;
                        this.has_stop = true;
                        end = pos - 1;
                        br = null;
                    } else if (br.txt.startsWith(";") && pos < next_vb && pos > vbidx) {
                        this.has_stop = true;
                        next_start = pos + 1;
                        end = pos - 1;
                        br = null;
                    } else if (pos > vbidx && pos < next_vb) {
                        if (!br.type.equals("NP") || next_vb - pos > 2 || !br.txt.equals("which") && !br.txt.equals("that")) {
                            this.has_stop = true;
                        } else {
                            this.next_clause = true;
                        }
                        end = pos - 1;
                        next_start = pos + 1;
                    } else {
                        List<Chunk> comlist = this.getCommaList(vbidx + 1, ls, next_vb);
                        List<Chunk> conjlist = this.getConjList(vbidx + 1, ls, next_vb);
                        if (next_vb_type == 2 && next_vb_type != vb_type && comlist.isEmpty() && conjlist.isEmpty() && !this.has_breaker) {
                            this.reduced_clause = true;
                            next_start = next_vb;
                        } else {
                            this.has_stop = false;
                        }
                        end = next_vb - 1;
                    }
                } else {
                    if (br.txt.equals(".")) {
                        this.next_pos = end = ls.size() - 1;
                    } else {
                        int br_pos = ls.indexOf(br);
                        end = br_pos - 1;
                        this.next_pos = br_pos + 1;
                    }
                    this.has_stop = true;
                }
            } else {
                System.out.println("ChunkAnalyzer: analyze >>--------------NO BREAKER --------> NERVER HAPPEND----------");
                System.exit(1);
            }
            int sub_type = 0;
            if (this.use_prev_obj) {
                if (prev_obj == null) {
                    sub = this.findSubject(start, ls, vbidx - 1);
                } else {
                    sub = this.findPreviousNP(prev_obj);
                    sub_type = 1;
                }
            } else if (this.shared_sub) {
                if (prev_sub != null) {
                    sub = prev_sub;
                    sub_type = 1;
                } else {
                    System.out.println("Chunk Analyzer: Analyze: ----> BUG---------> shared subject --> null");
                    System.out.println(cur_vb.getText() + " ");
                    this.printChunk(ls);
                    sub = this.findSubject(start, ls, vbidx - 1);
                }
            } else if (start < vbidx) {
                sub = this.findSubject(start, ls, vbidx - 1);
            } else {
                sub = new BasicChunk();
                this.debug = true;
                ++this.sub_count;
            }
            if (this.has_stop || this.reduced_clause) {
                object = new BasicChunk();
                for (int k = vbidx + 1; k < end; ++k) {
                    object.addChunk(ls.get(k));
                }
                if (!(ls.get((int)end).type.equals("O") || vbidx + 1 > end || ls.get((int)end).txt.equals(",") || ls.get((int)(end - 1)).txt.equals(",") && this.ccMap.contains(ls.get((int)end).txt) || this.ccMap.contains(ls.get((int)end).txt))) {
                    object.addChunk(ls.get(end));
                }
            } else {
                object = this.findObject(vbidx + 1, ls, end);
            }
            VerbChunk verb = new VerbChunk();
            verb.verb = cur_vb;
            verb.subject = sub;
            verb.object = object;
            verb.subject_type = sub_type;
            if ((sub == null || sub.isEmpty()) && vb_type == 0 && !this.pos_tags[cur_vb.begin].equals("VBN") && prev_obj != null) {
                verb.subject = this.findPreviousNP(prev_obj);
                verb.subject_type = 1;
            }
            verb.verb_type = vb_type;
            if (!verb.isQualify() && (verb.subject_type == 1 || verb.subject.isEmpty())) {
                merged = true;
            }
            if (!merged || this.verbList.isEmpty()) {
                this.verbList.add(verb);
            } else {
                VerbChunk verb1 = this.verbList.get(this.verbList.size() - 1);
                verb1.object.addChunk(cur_vb);
                verb1.object.addChunk(object);
            }
            if (prev_sub == null || !this.use_prev_obj) {
                prev_sub = sub;
            }
            prev_obj = object;
            if (this.has_stop) {
                start = next_start;
                this.has_stop = false;
                this.has_breaker = false;
                prev_obj = null;
                prev_sub = null;
                this.shared_sub = false;
            } else if (this.reduced_clause) {
                start = next_start;
            } else {
                start = this.next_pos;
                next_start = 0;
            }
            ++i;
        }
        if (this.next_pos < ls.size() - 1 || vbs.isEmpty()) {
            BasicChunk bsc = new BasicChunk();
            for (i = this.next_pos; i < ls.size(); ++i) {
                bsc.addChunk(ls.get(i));
            }
            if (bsc.proCount() > 0 && bsc.trgCount() > 0) {
                this.bsList.add(bsc);
            }
        }
        ArrayList<VerbChunk> rlist = new ArrayList<VerbChunk>();
        for (VerbChunk vc : this.verbList) {
            if (!vc.isQualify() || !vc.verb.trigs.isEmpty() || vc.subject.isQualify() || vc.object.isQualify() || vc.subject_type == 1) continue;
            rlist.add(vc);
        }
        if (rlist.size() > 0) {
            for (VerbChunk vc : rlist) {
                this.verbList.remove(vc);
                this.bsList.add(vc.merge());
            }
        }
    }

    private boolean hasNounChunk(int start, List<Chunk> ls, int stop) {
        for (int i = start; i <= stop; ++i) {
            Chunk c = ls.get(i);
            if (!c.type.equals("NP") || c.txt.equals("that") || c.txt.equals("which")) continue;
            return true;
        }
        return false;
    }

    public int getVerbChunkType(Chunk vb) {
        boolean has_be = false;
        boolean VBN = false;
        if (vb.txt.toLowerCase().startsWith("to ") && vb.end > vb.begin) {
            return 4;
        }
        for (int i = vb.begin; i <= vb.end; ++i) {
            if (this.beMap.contains(this.stokens[i])) {
                has_be = true;
            }
            if (!this.pos_tags[i].equals("VBN")) continue;
            VBN = true;
        }
        if (this.pos_tags[vb.end].equals("VBG") && !has_be) {
            return 3;
        }
        if (vb.end > vb.begin && has_be && VBN) {
            return 1;
        }
        if (VBN) {
            return 2;
        }
        return 0;
    }

    public int skipPhrase(List<Chunk> ls, int start, int end) {
        if (start == end) {
            return start;
        }
        int begin = start;
        if (ls.get((int)begin).txt.equals(",")) {
            ++begin;
        }
        if (this.ccMap.contains(ls.get((int)begin).txt)) {
            ++begin;
        }
        if (end - begin > 2 && end < ls.size() - 3 && begin >= 0) {
            if (ls.get((int)begin).type.equals("ADVP") && ls.get((int)(begin + 1)).txt.equals(",")) {
                begin += 2;
            }
            Chunk c = ls.get(begin);
            if (c.type.equals("PP") || c.type.equals("VP") && c.txt.toLowerCase().startsWith("to ") || c.type.equals("SBAR")) {
                Chunk com;
                int pos;
                List<Chunk> comma = this.getCommaList(start, ls, end);
                List<Chunk> conj = this.getConjList(start, ls, end);
                BasicChunk bs = new BasicChunk();
                if (comma.size() == 1) {
                    Chunk com2 = comma.get(0);
                    int com_pos = ls.indexOf(com2);
                    if (!this.hasNounChunk(com_pos, ls, end)) {
                        return begin;
                    }
                    end = com_pos - 1;
                    for (int i = begin; i <= end; ++i) {
                        bs.addChunk(ls.get(i));
                    }
                    this.bsList.add(bs);
                    return com_pos + 1;
                }
                if (comma.isEmpty()) {
                    return begin;
                }
                if (conj.size() > 0) {
                    Chunk and = conj.get(conj.size() - 1);
                    Chunk com3 = comma.get(comma.size() - 1);
                    if (and.begin == com3.begin + 1) {
                        int pos2 = ls.indexOf(and);
                        if (ls.get((int)(pos2 + 1)).type.equals("NP")) {
                            int i;
                            int idx = 0;
                            for (i = pos2 - 1; i > begin; --i) {
                                c = ls.get(i);
                                if (c.txt.equals(",") || c.type.equals("NP")) continue;
                                idx = c.begin;
                                break;
                            }
                            for (i = comma.size() - 1; i >= 0; --i) {
                                c = comma.get(i);
                                if (c.begin >= idx) continue;
                                pos2 = ls.indexOf(c);
                                for (int j = begin; j <= pos2; ++j) {
                                    bs.addChunk(ls.get(j));
                                }
                                this.bsList.add(bs);
                                return pos2 + 1;
                            }
                        }
                    }
                }
                if (this.hasNounChunk(pos = ls.indexOf(com = comma.get(0)), ls, end)) {
                    end = pos - 1;
                    for (int i = begin; i <= end; ++i) {
                        bs.addChunk(ls.get(i));
                    }
                    this.bsList.add(bs);
                    return pos + 1;
                }
            }
        }
        return begin;
    }

    private void dropChunks(List<Chunk> ls) {
        ArrayList<Chunk> list = new ArrayList<Chunk>();
        Chunk prev = null;
        int begin = 0;
        int end = ls.size() - 1;
        if (ls.get((int)begin).type.equals("VP")) {
            boolean remove = true;
            Chunk c1 = ls.get(begin);
            if (c1.trigs.isEmpty()) {
                int pos;
                List<Chunk> comma = this.getCommaList(begin, ls, end);
                int n = pos = comma.isEmpty() ? -1 : ls.indexOf(comma.get(0));
                if (pos > 0) {
                    for (int i = begin; i < pos; ++i) {
                        c1 = ls.get(i);
                        if (c1.pros.size() <= 0 && c1.trigs.size() <= 0) continue;
                        remove = false;
                        break;
                    }
                }
                if (pos > 0 && remove) {
                    while (pos >= 0) {
                        ls.remove(0);
                        --pos;
                    }
                } else {
                    c1 = ls.get(1);
                    if ((c1.type.equals("PP") || c1.type.equals("SBAR")) && (c1.txt.equals("that") || c1.txt.equals("whether"))) {
                        ls.remove(0);
                        ls.remove(0);
                    }
                }
            }
        }
        for (int i = 0; i < ls.size(); ++i) {
            Chunk c = ls.get(i);
            if (this.skipMap.contains(c.txt) && c.type.equals("O")) {
                list.add(c);
            } else if (c.type.equals("ADVP") && !this.allMap.contains(c.txt) && c.pros.isEmpty() && c.trigs.isEmpty() && i + 1 < ls.size()) {
                Chunk next = ls.get(i + 1);
                if (!(prev == null || prev.txt.equals(",") && next.txt.equals(","))) {
                    list.add(c);
                }
            }
            prev = c;
        }
        for (Chunk ch : list) {
            ls.remove(ch);
        }
    }

    public BasicChunk findPreviousNP(BasicChunk obj) {
        BasicChunk bs = new BasicChunk();
        return obj;
    }

    private BasicChunk cloneChunk(BasicChunk bc) {
        BasicChunk chunk = new BasicChunk();
        for (int i = 0; i < bc.chunkList.size(); ++i) {
            chunk.addChunk(bc.chunkList.get(i));
        }
        return chunk;
    }

    public BasicChunk findSubject(int start, List<Chunk> chunk, int stop) {
        BasicChunk sub = new BasicChunk();
        if (stop < 0) {
            if (start < stop) {
                System.out.println("ChunkAnalyzer: ---> BUG in findSubject, start< stop");
                System.exit(0);
            }
            return sub;
        }
        Chunk next = chunk.get(stop);
        if (next.txt.equals("that") || next.txt.equals("which")) {
            if (stop - start >= 2) {
                Chunk c = chunk.get(stop - 1);
                stop = c.txt.equals(",") ? (stop -= 2) : --stop;
            }
        } else if (next.txt.equals(",") || this.ccMap.contains(next.txt)) {
            --stop;
        }
        for (int i = start; i <= stop; ++i) {
            sub.addChunk(chunk.get(i));
        }
        return sub;
    }

    public void printChunk(List<Chunk> chunk) {
        for (Chunk c : chunk) {
            System.out.print("[" + c.type + " " + c.txt + "]");
        }
        System.out.println("");
    }

    private void printChunk(int start, List<Chunk> chunk, int stop) {
        for (int t = start; t <= stop; ++t) {
            System.out.print("[" + chunk.get((int)t).type + " " + chunk.get((int)t).txt + "] ");
        }
        System.out.println("");
    }

    private List<Chunk> getConjList(int start, List<Chunk> ls, int end) {
        ArrayList<Chunk> conj = new ArrayList<Chunk>();
        for (int i = start; i <= end; ++i) {
            if (!this.ccMap.contains(ls.get((int)i).txt)) continue;
            conj.add(ls.get(i));
        }
        return conj;
    }

    private List<Chunk> findVerbChunk(List<Chunk> chunk) {
        ArrayList<Chunk> ls = new ArrayList<Chunk>();
        Chunk prev = null;
        for (int i = 0; i < chunk.size(); ++i) {
            Chunk c = chunk.get(i);
            if (c.type.equals("VP") && this.getVerbChunkType(c) < 3 && !c.txt.startsWith("as ")) {
                ls.add(c);
            }
            prev = c;
        }
        return ls;
    }

    public BasicChunk findObject(int start, List<Chunk> ls, int end) {
        BasicChunk obj = new BasicChunk();
        List<Chunk> comma = this.getCommaList(start, ls, end);
        List<Chunk> conj = this.getConjList(start, ls, end);
        this.shared_sub = false;
        if (this.next_clause) {
            this.next_pos = end + 1;
            this.next_clause = false;
        } else if (this.has_breaker) {
            if (comma.size() > 0) {
                Chunk com = comma.get(comma.size() - 1);
                int com_pos = ls.indexOf(com);
                if (!this.hasNounChunk(com_pos, ls, end)) {
                    this.shared_sub = true;
                } else {
                    this.next_pos = com_pos + 1;
                    end = com_pos - 1;
                }
            } else {
                this.shared_sub = conj.isEmpty() || this.isShare(start, end, ls) ? true : true;
            }
        } else if (this.isShare(start, end, ls)) {
            this.shared_sub = true;
            if (ls.get((int)(end - 1)).txt.equals(",")) {
                end -= 2;
            }
        } else if (comma.size() == 1) {
            if (conj.size() > 0) {
                Chunk and = conj.get(conj.size() - 1);
                int conj_pos = ls.indexOf(and);
                if (!this.hasNounChunk(conj_pos, ls, end)) {
                    this.shared_sub = true;
                } else {
                    Chunk com = comma.get(0);
                    int com_pos = ls.indexOf(com);
                    if (com.begin < and.begin && conj_pos - com_pos == 1) {
                        end = com_pos - 1;
                        this.next_pos = conj_pos + 1;
                    } else if (!this.hasNounChunk(com_pos, ls, end)) {
                        this.shared_sub = true;
                    } else {
                        this.next_pos = com_pos + 1;
                        end = com_pos - 1;
                    }
                }
            } else {
                Chunk com = comma.get(0);
                int com_pos = ls.indexOf(com);
                if (!this.hasNounChunk(com_pos, ls, end)) {
                    this.shared_sub = true;
                } else {
                    this.next_pos = com_pos + 1;
                    end = com_pos - 1;
                }
            }
        } else if (comma.isEmpty()) {
            if (conj.size() > 0) {
                Chunk and = conj.get(conj.size() - 1);
                int conj_pos = ls.indexOf(and);
                if (!this.hasNounChunk(conj_pos, ls, end)) {
                    this.shared_sub = true;
                } else {
                    this.next_pos = conj_pos + 1;
                }
                end = conj_pos - 1;
            } else {
                this.next_pos = end + 1;
            }
        } else {
            boolean set = false;
            if (conj.size() > 0) {
                Chunk and = conj.get(conj.size() - 1);
                Chunk com = comma.get(comma.size() - 1);
                if (and.begin > com.begin) {
                    int pos = ls.indexOf(and);
                    if (this.hasNounChunk(pos, ls, end)) {
                        if (this.checkCoord(start, ls, pos)) {
                            this.next_pos = pos + 1;
                            end = pos - 1;
                        } else {
                            this.next_pos = end + 1;
                        }
                    } else {
                        this.shared_sub = true;
                    }
                    set = true;
                }
            }
            if (!set) {
                Chunk com = comma.get(comma.size() - 1);
                int pos = ls.indexOf(com);
                if (this.hasNounChunk(pos, ls, end)) {
                    this.next_pos = pos + 1;
                    end = pos - 1;
                } else {
                    this.shared_sub = true;
                }
            }
        }
        if (this.shared_sub) {
            this.next_pos = end + 2;
        }
        this.has_breaker = false;
        for (int i = start; i < end; ++i) {
            obj.addChunk(ls.get(i));
        }
        if (!(end <= 0 || end >= ls.size() || ls.get((int)end).txt.equals(",") || ls.get((int)(end - 1)).txt.equals(",") && this.ccMap.contains(ls.get((int)end).txt) || this.ccMap.contains(ls.get((int)end).txt))) {
            obj.addChunk(ls.get(end));
        }
        return obj;
    }

    private List<Chunk> findBreaker(List<Chunk> ls) {
        ArrayList<Chunk> list = new ArrayList<Chunk>();
        for (Chunk c : ls) {
            if (this.breakMap.contains(c.txt)) {
                list.add(c);
                continue;
            }
            if (!c.txt.startsWith(";") && (!c.type.equals("SBAR") || c.txt.equals("as"))) continue;
            list.add(c);
        }
        return list;
    }

    public boolean is_a_phrase(Chunk verb) {
        return this.beMap.contains(this.stokens[verb.end]);
    }

    private boolean isShare(int start, int end, List<Chunk> ls) {
        if (end - start >= 1) {
            Chunk c1 = ls.get(end);
            if (this.ccMap.contains(c1.txt)) {
                return true;
            }
        }
        return false;
    }

    public boolean is_passive(Chunk verb) {
        boolean has_be = false;
        int count = 0;
        for (int i = verb.begin; i <= verb.end; ++i) {
            if (this.beMap.contains(this.stokens[i])) {
                has_be = true;
            }
            if (!this.pos_tags[i].equals("VBN")) continue;
            ++count;
        }
        if (verb.trigs.size() == 1) {
            Word w = verb.trigs.get(0);
            if (w.pos_tag.equals("VBN") && has_be) {
                return true;
            }
        }
        return false;
    }

    private List<Chunk> getCommaList(int start, List<Chunk> chunk, int end) {
        ArrayList<Chunk> comma = new ArrayList<Chunk>();
        Chunk c = null;
        for (int i = start; i <= end; ++i) {
            c = chunk.get(i);
            if (!c.txt.equals(",") && !c.txt.equals(":")) continue;
            comma.add(c);
        }
        return comma;
    }

    private void groupVerbPhrase(List<Chunk> ls) {
        Chunk prev = null;
        ArrayList<Chunk> remove = new ArrayList<Chunk>();
        for (int i = 0; i < ls.size(); ++i) {
            Chunk next;
            Chunk c = ls.get(i);
            if (c.type.equals("VP") && c.begin == c.end) {
                if (!this.pos_tags[c.begin].startsWith("VB")) {
                    if (prev != null && prev.type.equals("NP")) {
                        prev.merge(c);
                        remove.add(c);
                        if (++i < ls.size()) {
                            c = ls.get(i);
                            if (c.type.equals("NP")) {
                                prev.merge(c);
                                remove.add(c);
                            }
                            if (++i < ls.size()) {
                                c = ls.get(i);
                            }
                        }
                    } else if (i + 1 < ls.size()) {
                        next = ls.get(i + 1);
                        if (next.type.equals("NP")) {
                            c.merge(next);
                            c.type = "NP";
                            remove.add(next);
                            if (++i < ls.size()) {
                                c = ls.get(i + 1);
                            }
                        } else if (this.pos_tags[c.begin].startsWith("NN")) {
                            c.type = "NP";
                        }
                    } else {
                        System.out.println("PARSER: Fixing verb phrase: ----->Unknown case: " + c.getValues());
                    }
                }
            } else if (c.type.equals("NP") && c.begin == c.end && this.pos_tags[c.begin].startsWith("VB")) {
                c.type = this.pos_tags[c.begin];
            }
            if (c.type.equals("VP")) {
                if (prev != null && prev.type.equals("ADVP") && !this.breakMap.contains(prev.txt) && prev.pros.isEmpty() && prev.trigs.isEmpty()) {
                    remove.add(prev);
                }
                if (i < ls.size() - 1) {
                    next = ls.get(i + 1);
                    if (next.type.equals("ADVP") && !this.breakMap.contains(next.txt)) {
                        if (next.pros.isEmpty() && next.trigs.isEmpty()) {
                            remove.add(next);
                            if (++i < ls.size() - 1) {
                                next = ls.get(i + 1);
                            }
                        }
                    } else if (next.type.equals("ADJP")) {
                        c.merge(next);
                        remove.add(next);
                        if (++i < ls.size() - 1) {
                            next = ls.get(i + 1);
                        }
                    } else if (next.type.equals("VP") && next.txt.startsWith("to ")) {
                        c.merge(next);
                        remove.add(next);
                        ++i;
                    } else if (this.prepMap.contains(next.txt) && i + 3 < ls.size()) {
                        Chunk tmp1 = ls.get(i + 2);
                        Chunk tmp2 = ls.get(i + 3);
                        if (this.ccMap.contains(tmp1.txt) && tmp2.type.equals("VP")) {
                            c.merge(next);
                            c.merge(tmp1);
                            c.merge(tmp2);
                            remove.add(next);
                            remove.add(tmp1);
                            remove.add(tmp2);
                            i += 3;
                        }
                    }
                }
            }
            prev = c;
        }
        for (Chunk ch : remove) {
            ls.remove(ch);
        }
    }

    private boolean checkCoord(int start, List<Chunk> ls, int end) {
        int count = 0;
        int conj = 0;
        if (end + 1 < ls.size() && ls.get((int)(end + 1)).type.equals("NP")) {
            for (int i = end - 1; i >= start; --i) {
                Chunk c = ls.get(i);
                if (c.txt.equals(",")) continue;
                if (c.type.equals("NP")) {
                    ++count;
                    continue;
                }
                if (!this.ccMap.contains(c.txt)) break;
                ++conj;
            }
            if (count >= 1 && conj >= 1) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        Parser parser = new Parser();
        String txt = "To investigate whether PRO4 can be expressed by any T cell subset or if expression is restricted to a distinct lineage, PRO5 mRNA expression was analyzed in freshly isolated T cells such as PRO6-depleted PRO7+ cells, PRO8+ naive or PRO9+ memory T cells (Figure 1A), as well as T cells driven in vitro toward Th1, Th2, or iTreg phenotypes (Figure 1B; phenotype on Figure S1).";
        String[] tokens = parser.splitWord(txt);
        String[] tags = parser.POSTag(tokens);
        List<Chunk> ls = parser.parse(tokens, tags);
        ChunkAnalyzer analyzer = new ChunkAnalyzer();
        analyzer.printChunk(ls);
        System.out.println("");
        analyzer.analyzeChunk(ls, tags, tokens);
        for (BasicChunk bs : analyzer.bsList) {
            bs.printChunk();
            System.out.println("");
        }
        BasicChunk bc = new BasicChunk();
        for (VerbChunk vbc : analyzer.verbList) {
            vbc.print();
            System.out.println("");
        }
    }
}

