/*
 * Decompiled with CFR 0.152.
 */
package corpora;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import relations.SenSimplifier;
import utils.DBUtils;

public class DataSaver {
    Statement stmt;
    ResultSet rs;
    PreparedStatement ps_pro;
    PreparedStatement ps_event;
    PreparedStatement ps_trigger;
    PreparedStatement ps_modify;
    PreparedStatement ps_equiv;
    PreparedStatement ps_abstract;
    Connection con;
    SenSimplifier simp;

    public DataSaver(DBUtils db) {
        try {
            this.simp = new SenSimplifier(db);
            this.con = db.getConnection();
            this.stmt = this.con.createStatement();
            this.stmt.executeUpdate("DROP TABLE PROTEIN IF EXISTS");
            this.stmt.executeUpdate("DROP TABLE TRIGGERS IF EXISTS");
            this.stmt.executeUpdate("DROP TABLE EVENT IF EXISTS");
            this.stmt.executeUpdate("DROP TABLE MODIFY IF EXISTS");
            this.stmt.executeUpdate("DROP TABLE EQUIV IF EXISTS");
            this.stmt.executeUpdate("DROP TABLE ABSTRACT IF EXISTS");
            this.stmt.executeUpdate("create cached table PROTEIN(PMID VARCHAR(80), TID VARCHAR(15), POS1 INT, POS2 INT, TXT VARCHAR(120))");
            this.stmt.executeUpdate("create cached table TRIGGERS(PMID VARCHAR(80), TID VARCHAR(15), T_TYPE VARCHAR(30), POS1 INT, POS2 INT, TXT VARCHAR(80))");
            this.stmt.executeUpdate("create cached table EVENT(PMID VARCHAR(80), EID VARCHAR(15), T_TYPE VARCHAR(30), TRIG_ID VARCHAR(5), THEME1 VARCHAR(5),THEME2 VARCHAR(5) ,CAUSE VARCHAR(5))");
            this.stmt.executeUpdate("create cached table MODIFY(PMID VARCHAR(80), MID VARCHAR(15), T_TYPE VARCHAR(30), THEME VARCHAR(5))");
            this.stmt.executeUpdate("create cached table EQUIV(PMID VARCHAR(80), TID1 VARCHAR(15),  TID2 VARCHAR(50))");
            this.stmt.executeUpdate("create cached table ABSTRACT(PMID VARCHAR(80), TEXT CLOB)");
            this.stmt.executeUpdate("DROP index PRO_idx  IF EXISTS");
            this.stmt.executeUpdate("DROP index TRIG_idx  IF EXISTS");
            this.stmt.executeUpdate("DROP index EVENT_idx  IF EXISTS");
            this.stmt.executeUpdate("DROP index MODIFY_idx  IF EXISTS");
            this.stmt.executeUpdate("DROP index ABSTRACT_idx  IF EXISTS");
            this.stmt.executeUpdate("DROP index EQUIV_idx  IF EXISTS");
            this.stmt.executeUpdate("create index PRO_idx on Protein (pmid,tid)");
            this.stmt.executeUpdate("create index TRIG_idx on Triggers (pmid,tid)");
            this.stmt.executeUpdate("create index EVENT_idx on Event (pmid,eid)");
            this.stmt.executeUpdate("create index MODIFY_idx on Modify (pmid,mid)");
            this.stmt.executeUpdate("create index EQUIV_idx on EQUIV (pmid,tid1)");
            this.stmt.executeUpdate("create index ABSTRACT_idx on ABSTRACT (pmid)");
            this.ps_pro = this.con.prepareStatement("Insert into PROTEIN(PMID, TID, POS1, POS2,TXT) VALUES(?,?,?,?,?)");
            this.ps_trigger = this.con.prepareStatement("Insert into TRIGGERS(PMID, TID, T_TYPE, POS1, POS2,TXT) VALUES(?,?,?,?,?,?)");
            this.ps_event = this.con.prepareStatement("Insert into EVENT(PMID,EID,T_TYPE,TRIG_ID,THEME1,THEME2,CAUSE) VALUES(?,?,?,?,?,?,?)");
            this.ps_modify = this.con.prepareStatement("Insert into MODIFY(PMID, MID, T_TYPE, THEME) VALUES(?,?,?,?)");
            this.ps_equiv = this.con.prepareStatement("Insert into EQUIV(PMID, TID1, TID2) VALUES(?,?,?)");
            this.ps_abstract = this.con.prepareStatement("Insert into ABSTRACT(PMID, TEXT) VALUES(?,?)");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void saveProtein(String pmid, String tid, int p1, int p2, String value) {
        try {
            this.ps_pro.setString(1, pmid);
            this.ps_pro.setString(2, tid);
            this.ps_pro.setInt(3, p1);
            this.ps_pro.setInt(4, p2);
            this.ps_pro.setString(5, value);
            this.ps_pro.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveAbstract(String pmid, String txt) {
        try {
            this.ps_abstract.setString(1, pmid);
            this.ps_abstract.setString(2, txt);
            this.ps_abstract.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveTrigger(String pmid, String tid, String type, int p1, int p2, String value) {
        try {
            this.ps_trigger.setString(1, pmid);
            this.ps_trigger.setString(2, tid);
            this.ps_trigger.setString(3, type);
            this.ps_trigger.setInt(4, p1);
            this.ps_trigger.setInt(5, p2);
            this.ps_trigger.setString(6, value);
            this.ps_trigger.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveEvent(String pmid, String eid, String type1, String trig_id, String theme1, String theme2, String cause) {
        try {
            this.ps_event.setString(1, pmid);
            this.ps_event.setString(2, eid);
            this.ps_event.setString(3, type1);
            this.ps_event.setString(4, trig_id);
            this.ps_event.setString(5, theme1);
            this.ps_event.setString(6, theme2);
            this.ps_event.setString(7, cause);
            this.ps_event.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveModify(String pmid, String mid, String type, String theme) {
        try {
            this.ps_modify.setString(1, pmid);
            this.ps_modify.setString(2, mid);
            this.ps_modify.setString(3, type);
            this.ps_modify.setString(4, theme);
            this.ps_modify.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveEquiv(String pmid, String tid, String tid2) {
        try {
            this.ps_equiv.setString(1, pmid);
            this.ps_equiv.setString(2, tid);
            this.ps_equiv.setString(3, tid2);
            this.ps_equiv.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

