/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.xml;

import com.aliasi.xml.SAXFilterHandler;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.helpers.DefaultHandler;

public class ElementStackFilter
extends SAXFilterHandler {
    private final Stack<String> mElementStack = new Stack();
    private final Stack<Attributes> mAttributesStack = new Stack();

    public ElementStackFilter(DefaultHandler handler) {
        super(handler);
    }

    public ElementStackFilter() {
    }

    public List<String> getElementStack() {
        return Collections.unmodifiableList(this.mElementStack);
    }

    public List<Attributes> getAttributesStack() {
        return Collections.unmodifiableList(this.mAttributesStack);
    }

    @Override
    public void startDocument() throws SAXException {
        this.mElementStack.clear();
        super.startDocument();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.mElementStack.push(qName);
        this.mAttributesStack.push(ElementStackFilter.copy(atts));
        super.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.mElementStack.pop();
        this.mAttributesStack.pop();
        super.endElement(namespaceURI, localName, qName);
    }

    public boolean noElement() {
        return this.mElementStack.isEmpty();
    }

    public String currentElement() {
        return this.mElementStack.peek();
    }

    public Attributes currentAttributes() {
        return this.mAttributesStack.peek();
    }

    static Attributes copy(Attributes atts) {
        return new Attributes2Impl(atts);
    }
}

