/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Iterators;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ObjectToSet<K, M>
extends HashMap<K, Set<M>> {
    static final long serialVersionUID = -5758024598554958671L;

    public void addMember(K key, M member) {
        if (this.containsKey(key)) {
            ((Set)this.get(key)).add(member);
        } else {
            HashSet<M> val = new HashSet<M>();
            val.add(member);
            this.put(key, val);
        }
    }

    public boolean removeMember(K key, M member) {
        if (!this.containsKey(key)) {
            return false;
        }
        boolean result = ((Set)this.get(key)).remove(member);
        if (((Set)this.get(key)).size() == 0) {
            this.remove(key);
        }
        return result;
    }

    public void addMembers(K key, Set<? extends M> values) {
        Set memberSet = (Set)this.get(key);
        if (memberSet == null) {
            this.put(key, new HashSet<M>(values));
        } else {
            memberSet.addAll(values);
        }
    }

    public Set<M> memberValues() {
        HashSet set = new HashSet();
        for (Set members : this.values()) {
            set.addAll(members);
        }
        return set;
    }

    public Set<M> getSet(K key) {
        Set result = (Set)this.get(key);
        return result != null ? result : new HashSet(0);
    }

    public Iterator<M> memberIterator() {
        return new MemberIterator(this);
    }

    static class MemberIterator<N>
    extends Iterators.Buffered<N> {
        final Iterator<? extends Set<N>> mTopIterator;
        Iterator<N> mMemberSetIterator = null;

        MemberIterator(ObjectToSet<?, N> ots) {
            this.mTopIterator = ots.values().iterator();
        }

        @Override
        protected N bufferNext() {
            while (this.mMemberSetIterator == null || !this.mMemberSetIterator.hasNext()) {
                if (!this.mTopIterator.hasNext()) {
                    return null;
                }
                this.mMemberSetIterator = this.mTopIterator.next().iterator();
            }
            return this.mMemberSetIterator.next();
        }
    }
}

