/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class MinMaxHeap<E extends Scored>
extends AbstractCollection<E> {
    private final E[] mHeap;
    private final int mHeapLength;
    private final boolean[] mLevelTypes;
    private int mNextFreeIndex = 1;
    static final boolean MIN_LEVEL = true;
    static final boolean MAX_LEVEL = false;

    public MinMaxHeap(int maxSize) {
        if (maxSize < 1) {
            String msg = "Heaps must be at least one element. Found maxSize=" + maxSize;
            throw new IllegalArgumentException(msg);
        }
        Scored[] tempHeap = new Scored[maxSize + 1];
        this.mHeap = tempHeap;
        this.mHeapLength = this.mHeap.length;
        this.mLevelTypes = new boolean[maxSize + 1];
        MinMaxHeap.fillLevelTypes(this.mLevelTypes);
    }

    @Override
    public int size() {
        return this.mNextFreeIndex - 1;
    }

    @Override
    public Iterator<E> iterator() {
        ArrayList<E> list = new ArrayList<E>();
        int i = 0;
        while (i < this.mNextFreeIndex) {
            list.add(this.mHeap[i]);
            ++i;
        }
        Collections.sort(list, ScoredObject.reverseComparator());
        return list.iterator();
    }

    @Override
    public boolean add(E s) {
        if (this.mNextFreeIndex < this.mHeapLength) {
            this.mHeap[this.mNextFreeIndex++] = s;
            this.bubbleUp(this.mNextFreeIndex - 1);
            return true;
        }
        if (s.score() <= this.peekMin().score()) {
            return false;
        }
        this.popMin();
        this.mHeap[this.mNextFreeIndex++] = s;
        this.bubbleUp(this.mNextFreeIndex - 1);
        return true;
    }

    public E peekMax() {
        return this.mNextFreeIndex == 1 ? null : (this.mNextFreeIndex == 2 ? (E)this.mHeap[1] : (this.mNextFreeIndex == 3 ? (E)this.mHeap[2] : (this.mHeap[2].score() > this.mHeap[3].score() ? (E)this.mHeap[2] : (E)this.mHeap[3])));
    }

    public E peekMin() {
        return this.mNextFreeIndex == 1 ? null : (E)this.mHeap[1];
    }

    public E popMax() {
        if (this.mNextFreeIndex == 1) {
            return null;
        }
        if (this.mNextFreeIndex == 2) {
            --this.mNextFreeIndex;
            return this.mHeap[1];
        }
        if (this.mNextFreeIndex == 3) {
            --this.mNextFreeIndex;
            return this.mHeap[2];
        }
        if (this.mHeap[2].score() > this.mHeap[3].score()) {
            E max = this.mHeap[2];
            this.mHeap[2] = this.mHeap[--this.mNextFreeIndex];
            this.trickleDownMax(2);
            return max;
        }
        E max = this.mHeap[3];
        this.mHeap[3] = this.mHeap[--this.mNextFreeIndex];
        this.trickleDownMax(3);
        return max;
    }

    public E popMin() {
        if (this.mNextFreeIndex == 1) {
            return null;
        }
        if (this.mNextFreeIndex == 2) {
            this.mNextFreeIndex = 1;
            return this.mHeap[1];
        }
        E min = this.mHeap[1];
        this.mHeap[1] = this.mHeap[--this.mNextFreeIndex];
        this.trickleDownMin(1);
        return min;
    }

    @Override
    public String toString() {
        if (this.mNextFreeIndex == 1) {
            return "EMPTY HEAP";
        }
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i < this.mNextFreeIndex) {
            if (i > 1) {
                sb.append("\n");
            }
            sb.append(String.valueOf(i) + "=" + this.mHeap[i]);
            ++i;
        }
        return sb.toString();
    }

    void bubbleUp(int nodeIndex) {
        if (!this.hasParent(nodeIndex)) {
            return;
        }
        int parentIndex = MinMaxHeap.parentIndex(nodeIndex);
        if (this.onMinLevel(nodeIndex)) {
            if (this.mHeap[nodeIndex].score() > this.mHeap[parentIndex].score()) {
                this.swap(nodeIndex, parentIndex);
                this.bubbleUpMax(parentIndex);
            } else {
                this.bubbleUpMin(nodeIndex);
            }
        } else if (this.mHeap[nodeIndex].score() < this.mHeap[parentIndex].score()) {
            this.swap(nodeIndex, parentIndex);
            this.bubbleUpMin(parentIndex);
        } else {
            this.bubbleUpMax(nodeIndex);
        }
    }

    void bubbleUpMin(int nodeIndex) {
        while (this.hasParent(nodeIndex)) {
            int parentIndex = MinMaxHeap.parentIndex(nodeIndex);
            if (!this.hasParent(parentIndex)) {
                return;
            }
            int grandparentIndex = MinMaxHeap.parentIndex(parentIndex);
            if (this.mHeap[nodeIndex].score() >= this.mHeap[grandparentIndex].score()) {
                return;
            }
            this.swap(nodeIndex, grandparentIndex);
            nodeIndex = grandparentIndex;
        }
        return;
    }

    void bubbleUpMax(int nodeIndex) {
        while (this.hasParent(nodeIndex)) {
            int parentIndex = MinMaxHeap.parentIndex(nodeIndex);
            if (!this.hasParent(parentIndex)) {
                return;
            }
            int grandparentIndex = MinMaxHeap.parentIndex(parentIndex);
            if (this.mHeap[nodeIndex].score() <= this.mHeap[grandparentIndex].score()) {
                return;
            }
            this.swap(nodeIndex, grandparentIndex);
            nodeIndex = grandparentIndex;
        }
        return;
    }

    boolean onMinLevel(int nodeIndex) {
        return this.mLevelTypes[nodeIndex];
    }

    void trickleDown(int nodeIndex) {
        if (this.noChildren(nodeIndex)) {
            return;
        }
        if (this.onMinLevel(nodeIndex)) {
            this.trickleDownMin(nodeIndex);
        } else {
            this.trickleDownMax(nodeIndex);
        }
    }

    void trickleDownMin(int nodeIndex) {
        while (MinMaxHeap.leftDaughterIndex(nodeIndex) < this.mNextFreeIndex) {
            int minDescIndex = this.minDtrOrGrandDtrIndex(nodeIndex);
            if (this.isDaughter(nodeIndex, minDescIndex)) {
                if (this.mHeap[minDescIndex].score() < this.mHeap[nodeIndex].score()) {
                    this.swap(minDescIndex, nodeIndex);
                }
                return;
            }
            if (this.mHeap[minDescIndex].score() >= this.mHeap[nodeIndex].score()) {
                return;
            }
            this.swap(minDescIndex, nodeIndex);
            int parentIndex = MinMaxHeap.parentIndex(minDescIndex);
            if (this.mHeap[minDescIndex].score() > this.mHeap[parentIndex].score()) {
                this.swap(minDescIndex, parentIndex);
            }
            nodeIndex = minDescIndex;
        }
    }

    void trickleDownMax(int nodeIndex) {
        while (MinMaxHeap.leftDaughterIndex(nodeIndex) < this.mNextFreeIndex) {
            int maxDescIndex = this.maxDtrOrGrandDtrIndex(nodeIndex);
            if (this.isDaughter(nodeIndex, maxDescIndex)) {
                if (this.mHeap[maxDescIndex].score() > this.mHeap[nodeIndex].score()) {
                    this.swap(maxDescIndex, nodeIndex);
                }
                return;
            }
            if (this.mHeap[maxDescIndex].score() <= this.mHeap[nodeIndex].score()) {
                return;
            }
            this.swap(maxDescIndex, nodeIndex);
            int parentIndex = MinMaxHeap.parentIndex(maxDescIndex);
            if (this.mHeap[maxDescIndex].score() < this.mHeap[parentIndex].score()) {
                this.swap(maxDescIndex, parentIndex);
            }
            nodeIndex = maxDescIndex;
        }
    }

    int minDtrOrGrandDtrIndex(int nodeIndex) {
        int grandDtr4Index;
        int grandDtr3Index;
        int grandDtr2Index;
        int grandDtr1Index;
        int leftDtrIndex;
        int minIndex = leftDtrIndex = MinMaxHeap.leftDaughterIndex(nodeIndex);
        double minScore = this.mHeap[leftDtrIndex].score();
        int rightDtrIndex = MinMaxHeap.rightDaughterIndex(nodeIndex);
        if (rightDtrIndex >= this.mNextFreeIndex) {
            return minIndex;
        }
        double rightDtrScore = this.mHeap[rightDtrIndex].score();
        if (rightDtrScore < minScore) {
            minIndex = rightDtrIndex;
            minScore = rightDtrScore;
        }
        if ((grandDtr1Index = MinMaxHeap.leftDaughterIndex(leftDtrIndex)) >= this.mNextFreeIndex) {
            return minIndex;
        }
        double grandDtr1Score = this.mHeap[grandDtr1Index].score();
        if (grandDtr1Score < minScore) {
            minIndex = grandDtr1Index;
            minScore = grandDtr1Score;
        }
        if ((grandDtr2Index = MinMaxHeap.rightDaughterIndex(leftDtrIndex)) >= this.mNextFreeIndex) {
            return minIndex;
        }
        double grandDtr2Score = this.mHeap[grandDtr2Index].score();
        if (grandDtr2Score < minScore) {
            minIndex = grandDtr2Index;
            minScore = grandDtr2Score;
        }
        if ((grandDtr3Index = MinMaxHeap.leftDaughterIndex(rightDtrIndex)) >= this.mNextFreeIndex) {
            return minIndex;
        }
        double grandDtr3Score = this.mHeap[grandDtr3Index].score();
        if (grandDtr3Score < minScore) {
            minIndex = grandDtr3Index;
            minScore = grandDtr3Score;
        }
        if ((grandDtr4Index = MinMaxHeap.rightDaughterIndex(rightDtrIndex)) >= this.mNextFreeIndex) {
            return minIndex;
        }
        double grandDtr4Score = this.mHeap[grandDtr4Index].score();
        return grandDtr4Score < minScore ? grandDtr4Index : minIndex;
    }

    int maxDtrOrGrandDtrIndex(int nodeIndex) {
        int grandDtr4Index;
        int grandDtr3Index;
        int grandDtr2Index;
        int grandDtr1Index;
        int leftDtrIndex;
        int maxIndex = leftDtrIndex = MinMaxHeap.leftDaughterIndex(nodeIndex);
        double maxScore = this.mHeap[leftDtrIndex].score();
        int rightDtrIndex = MinMaxHeap.rightDaughterIndex(nodeIndex);
        if (rightDtrIndex >= this.mNextFreeIndex) {
            return maxIndex;
        }
        double rightDtrScore = this.mHeap[rightDtrIndex].score();
        if (rightDtrScore > maxScore) {
            maxIndex = rightDtrIndex;
            maxScore = rightDtrScore;
        }
        if ((grandDtr1Index = MinMaxHeap.leftDaughterIndex(leftDtrIndex)) >= this.mNextFreeIndex) {
            return maxIndex;
        }
        double grandDtr1Score = this.mHeap[grandDtr1Index].score();
        if (grandDtr1Score > maxScore) {
            maxIndex = grandDtr1Index;
            maxScore = grandDtr1Score;
        }
        if ((grandDtr2Index = MinMaxHeap.rightDaughterIndex(leftDtrIndex)) >= this.mNextFreeIndex) {
            return maxIndex;
        }
        double grandDtr2Score = this.mHeap[grandDtr2Index].score();
        if (grandDtr2Score > maxScore) {
            maxIndex = grandDtr2Index;
            maxScore = grandDtr2Score;
        }
        if ((grandDtr3Index = MinMaxHeap.leftDaughterIndex(rightDtrIndex)) >= this.mNextFreeIndex) {
            return maxIndex;
        }
        double grandDtr3Score = this.mHeap[grandDtr3Index].score();
        if (grandDtr3Score > maxScore) {
            maxIndex = grandDtr3Index;
            maxScore = grandDtr3Score;
        }
        if ((grandDtr4Index = MinMaxHeap.rightDaughterIndex(rightDtrIndex)) >= this.mNextFreeIndex) {
            return maxIndex;
        }
        double grandDtr4Score = this.mHeap[grandDtr4Index].score();
        return grandDtr4Score > maxScore ? grandDtr4Index : maxIndex;
    }

    boolean hasParent(int nodeIndex) {
        return nodeIndex > 1;
    }

    boolean noChildren(int nodeIndex) {
        return MinMaxHeap.leftDaughterIndex(nodeIndex) >= this.mHeapLength;
    }

    boolean isDaughter(int nodeIndexParent, int nodeIndexDescendant) {
        return nodeIndexDescendant <= MinMaxHeap.rightDaughterIndex(nodeIndexParent);
    }

    void swap(int index1, int index2) {
        E temp = this.mHeap[index1];
        this.mHeap[index1] = this.mHeap[index2];
        this.mHeap[index2] = temp;
    }

    static int parentIndex(int nodeIndex) {
        return nodeIndex / 2;
    }

    static int leftDaughterIndex(int nodeIndex) {
        return 2 * nodeIndex;
    }

    static int rightDaughterIndex(int nodeIndex) {
        return 2 * nodeIndex + 1;
    }

    static void fillLevelTypes(boolean[] levelTypes) {
        boolean type = false;
        int index = 1;
        int numEltsOfType = 1;
        while (true) {
            type = !type;
            int j = 0;
            while (j < numEltsOfType) {
                if (index >= levelTypes.length) {
                    return;
                }
                levelTypes[index++] = type;
                ++j;
            }
            numEltsOfType *= 2;
        }
    }
}

