/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Compilable;
import com.aliasi.util.Streams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class AbstractExternalizable
implements Externalizable {
    static final long serialVersionUID = -3880451086025138660L;
    private Object mObjectRead;

    protected AbstractExternalizable() {
    }

    protected abstract Object read(ObjectInput var1) throws ClassNotFoundException, IOException;

    @Override
    public abstract void writeExternal(ObjectOutput var1) throws IOException;

    @Override
    public final void readExternal(ObjectInput objIn) throws ClassNotFoundException, IOException {
        this.mObjectRead = this.read(objIn);
    }

    protected Object readResolve() {
        return this.mObjectRead;
    }

    public static void compileTo(Compilable compilable, File file) throws IOException {
        FileOutputStream fileOut = null;
        BufferedOutputStream bufOut = null;
        ObjectOutputStream objOut = null;
        try {
            fileOut = new FileOutputStream(file);
            bufOut = new BufferedOutputStream(fileOut);
            objOut = new ObjectOutputStream(bufOut);
            compilable.compileTo(objOut);
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(objOut);
            Streams.closeQuietly(bufOut);
            Streams.closeQuietly(fileOut);
            throw throwable;
        }
        Streams.closeQuietly(objOut);
        Streams.closeQuietly(bufOut);
        Streams.closeQuietly(fileOut);
    }

    public static void serializeTo(Serializable serializable, File file) throws IOException {
        FileOutputStream fileOut = null;
        BufferedOutputStream bufOut = null;
        ObjectOutputStream objOut = null;
        try {
            fileOut = new FileOutputStream(file);
            bufOut = new BufferedOutputStream(fileOut);
            objOut = new ObjectOutputStream(bufOut);
            objOut.writeObject(serializable);
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(objOut);
            Streams.closeQuietly(bufOut);
            Streams.closeQuietly(fileOut);
            throw throwable;
        }
        Streams.closeQuietly(objOut);
        Streams.closeQuietly(bufOut);
        Streams.closeQuietly(fileOut);
    }

    public static void serializeOrCompile(Object obj, ObjectOutput out) throws IOException {
        if (obj instanceof Serializable) {
            out.writeObject(obj);
        } else if (obj instanceof Compilable) {
            ((Compilable)obj).compileTo(out);
        } else {
            String msg = "Object must be compilable or serializable. Found object with class=" + obj.getClass();
            throw new IllegalArgumentException(msg);
        }
    }

    public static void compileOrSerialize(Object obj, ObjectOutput out) throws IOException {
        if (obj instanceof Compilable) {
            ((Compilable)obj).compileTo(out);
        } else if (obj instanceof Serializable) {
            out.writeObject(obj);
        } else {
            String msg = "Object must be compilable or serializable. Found object with class=" + obj.getClass();
            throw new NotSerializableException(msg);
        }
    }

    public static Object readObject(File file) throws IOException, ClassNotFoundException {
        Object object;
        FileInputStream fileIn = null;
        BufferedInputStream bufIn = null;
        ObjectInputStream objIn = null;
        try {
            fileIn = new FileInputStream(file);
            bufIn = new BufferedInputStream(fileIn);
            objIn = new ObjectInputStream(bufIn);
            object = objIn.readObject();
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(objIn);
            Streams.closeQuietly(bufIn);
            Streams.closeQuietly(fileIn);
            throw throwable;
        }
        Streams.closeQuietly(objIn);
        Streams.closeQuietly(bufIn);
        Streams.closeQuietly(fileIn);
        return object;
    }

    public static Object readResourceObject(Class<?> clazz, String resourcePathName) throws IOException, ClassNotFoundException {
        Object object;
        InputStream in = null;
        ObjectInputStream objIn = null;
        try {
            in = clazz.getResourceAsStream(resourcePathName);
            objIn = new ObjectInputStream(in);
            object = objIn.readObject();
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(objIn);
            Streams.closeQuietly(in);
            throw throwable;
        }
        Streams.closeQuietly(objIn);
        Streams.closeQuietly(in);
        return object;
    }

    public static Object readResourceObject(String resourceAbsolutePathName) throws IOException, ClassNotFoundException {
        if (!resourceAbsolutePathName.startsWith("/")) {
            String msg = "This method requires an absolute resource name starting with a forward slash (/) Found resourcePathName=" + resourceAbsolutePathName;
            throw new IllegalArgumentException(msg);
        }
        return AbstractExternalizable.readResourceObject(AbstractExternalizable.class, resourceAbsolutePathName);
    }

    public static Object compile(Compilable c) throws ClassNotFoundException, IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        c.compileTo(objOut);
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
        try {
            return objIn.readObject();
        }
        catch (ClassNotFoundException e) {
            String msg = "Compile i/o class not found exception=" + e;
            throw new IOException(msg);
        }
    }

    public static Object serializeDeserialize(Serializable s) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        objOut.writeObject(s);
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
        try {
            return objIn.readObject();
        }
        catch (ClassNotFoundException e) {
            String msg = "Compile i/o class not found exception=" + e;
            throw new IOException(msg);
        }
    }

    public static void writeInts(int[] xs, ObjectOutput objOut) throws IOException {
        objOut.writeInt(xs.length);
        int i = 0;
        while (i < xs.length) {
            objOut.writeInt(xs[i]);
            ++i;
        }
    }

    public static int[] readInts(ObjectInput objIn) throws IOException {
        int[] xs = new int[objIn.readInt()];
        int i = 0;
        while (i < xs.length) {
            xs[i] = objIn.readInt();
            ++i;
        }
        return xs;
    }

    public static void writeFloats(float[] xs, ObjectOutput objOut) throws IOException {
        objOut.writeInt(xs.length);
        int i = 0;
        while (i < xs.length) {
            objOut.writeFloat(xs[i]);
            ++i;
        }
    }

    public static void writeDoubles(double[] xs, ObjectOutput objOut) throws IOException {
        objOut.writeInt(xs.length);
        int i = 0;
        while (i < xs.length) {
            objOut.writeDouble(xs[i]);
            ++i;
        }
    }

    public static float[] readFloats(ObjectInput objIn) throws IOException {
        float[] xs = new float[objIn.readInt()];
        int i = 0;
        while (i < xs.length) {
            xs[i] = objIn.readFloat();
            ++i;
        }
        return xs;
    }

    public static double[] readDoubles(ObjectInput objIn) throws IOException {
        double[] xs = new double[objIn.readInt()];
        int i = 0;
        while (i < xs.length) {
            xs[i] = objIn.readDouble();
            ++i;
        }
        return xs;
    }

    public static void writeUTFs(String[] xs, ObjectOutput objOut) throws IOException {
        objOut.writeInt(xs.length);
        int i = 0;
        while (i < xs.length) {
            objOut.writeUTF(xs[i]);
            ++i;
        }
    }

    public static String[] readUTFs(ObjectInput objIn) throws IOException {
        String[] xs = new String[objIn.readInt()];
        int i = 0;
        while (i < xs.length) {
            xs[i] = objIn.readUTF();
            ++i;
        }
        return xs;
    }
}

