/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.util.Iterators;
import com.aliasi.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Tokenizer
implements Iterable<String> {
    @Override
    public Iterator<String> iterator() {
        return new TokenIterator();
    }

    public abstract String nextToken();

    public String nextWhitespace() {
        return " ";
    }

    public int lastTokenStartPosition() {
        throw new UnsupportedOperationException();
    }

    public int lastTokenEndPosition() {
        throw new UnsupportedOperationException();
    }

    public void tokenize(List<? super String> tokens, List<? super String> whitespaces) {
        String token;
        whitespaces.add(this.nextWhitespace());
        while ((token = this.nextToken()) != null) {
            tokens.add(token.toString());
            whitespaces.add(this.nextWhitespace().toString());
        }
    }

    public String[] tokenize() {
        String token;
        ArrayList<String> tokenList = new ArrayList<String>();
        while ((token = this.nextToken()) != null) {
            tokenList.add(token);
        }
        return tokenList.toArray(Strings.EMPTY_STRING_ARRAY);
    }

    class TokenIterator
    extends Iterators.Buffered<String> {
        TokenIterator() {
        }

        @Override
        public String bufferNext() {
            return Tokenizer.this.nextToken();
        }
    }
}

