/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.xml;

import com.aliasi.test.unit.MockObjectHelper;
import com.aliasi.test.unit.xml.MockDefaultHandler;
import com.aliasi.xml.SimpleElementHandler;
import com.aliasi.xml.TextContentFilter;
import junit.framework.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TextContentFilterTest {
    @Test
    public void test1() throws SAXException {
        MockDefaultHandler handler = new MockDefaultHandler();
        MockObjectHelper helper = new MockObjectHelper();
        TestTextFilter filter = new TestTextFilter(handler);
        filter.filterElement("a");
        filter.startDocument();
        helper.add("startDocument");
        filter.endDocument();
        helper.add("endDocument");
        Assert.assertEquals((Object)helper.getCalls(), (Object)handler.getCalls());
    }

    @Test
    public void test2() throws SAXException {
        MockDefaultHandler handler = new MockDefaultHandler();
        MockObjectHelper helper = new MockObjectHelper();
        TestTextFilter filter = new TestTextFilter(handler);
        filter.filterElement("foo");
        filter.startDocument();
        helper.add("startDocument");
        filter.startElement(null, "foo", "foo", SimpleElementHandler.EMPTY_ATTS);
        helper.add("startElement", null, "foo", "foo", MockDefaultHandler.EMPTY_ATTS_STRING);
        filter.characters("abc");
        helper.add("characters", "ABC");
        filter.startElement(null, "bar", "bar", SimpleElementHandler.EMPTY_ATTS);
        helper.add("startElement", null, "bar", "bar", MockDefaultHandler.EMPTY_ATTS_STRING);
        filter.characters("xyz");
        helper.add("characters", "xyz");
        filter.endElement(null, "bar", "bar");
        helper.add("endElement", null, "bar", "bar");
        filter.characters("mno");
        helper.add("characters", "MNO");
        filter.endElement(null, "foo", "foo");
        helper.add("endElement", null, "foo", "foo");
        filter.endDocument();
        helper.add("endDocument");
        Assert.assertEquals((Object)helper.getCalls(), (Object)handler.getCalls());
    }

    private static class TestTextFilter
    extends TextContentFilter {
        public TestTextFilter() {
        }

        public TestTextFilter(DefaultHandler handler) {
            super(handler);
        }

        @Override
        public void filteredCharacters(char[] cs, int start, int length) throws SAXException {
            char[] newChars = new String(cs, start, length).toUpperCase().toCharArray();
            this.mHandler.characters(newChars, 0, newChars.length);
        }
    }
}

