/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.xml;

import com.aliasi.xml.SAXWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXWriterTest {
    @Test
    public void testCharsets() throws IOException, SAXException {
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"UTF-8\"?><a/>", "UTF-8");
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"ASCII\"?><a/>", "ASCII");
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><a/>", "ISO-8859-1");
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"UTF-16\"?><a/>", "UTF-16");
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><a/>", "ISO-8859-1");
    }

    @Test
    public void testIgnorableWhitespace() throws IOException, SAXException {
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"UTF-8\"?> <a/> ", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><a/>", "UTF-8");
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"UTF-8\"?> <a></a> ", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><a/>", "UTF-8");
    }

    @Test
    public void testIllegalChars() throws IOException, SAXException {
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"UTF-16\"?><a>\u2297</a>", "UTF-16");
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><a>\u2297</a>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><a>&#x2297;</a>", "ISO-8859-1");
    }

    @Test
    public void testNamespaces() throws IOException, SAXException {
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><foo:a xmlns:foo=\"http://bar\">Hello World.</foo:a>", "ISO-8859-1");
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><a xmlns=\"http://bar\">Hello World.</a>", "ISO-8859-1");
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><a xmlns=\"http://bar\">Hello World.</a>", "ISO-8859-1");
    }

    @Test
    public void testXHTML() throws IOException, SAXException {
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><html><a name=\"foo\"/><br/></html>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><html><a name=\"foo\"></a><br /></html>", "ISO-8859-1", true);
        this.assertReadWrite("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><html><a name=\"foo\"/><br/></html>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><html><a name=\"foo\"></a><br /></html>", "ISO-8859-1", true);
    }

    private void assertReadWrite(String sourceString, String charset) throws IOException, SAXException {
        this.assertReadWrite(sourceString, charset, false);
    }

    private void assertReadWrite(String sourceString, String charset, boolean xhtmlMode) throws IOException, SAXException {
        this.assertReadWrite(sourceString, sourceString, charset, xhtmlMode);
    }

    private void assertReadWrite(String sourceString, String targetString, String charset) throws IOException, SAXException {
        this.assertReadWrite(sourceString, targetString, charset, false);
    }

    private void assertReadWrite(String sourceString, String targetString, String charset, boolean xhtmlMode) throws IOException, SAXException {
        CharArrayReader reader = new CharArrayReader(sourceString.toCharArray());
        InputSource in = new InputSource(reader);
        in.setEncoding(charset);
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        SAXWriter writer = new SAXWriter(bytesOut, charset, xhtmlMode);
        xmlReader.setContentHandler(writer);
        xmlReader.setDTDHandler(writer);
        xmlReader.parse(in);
        byte[] bytes = bytesOut.toByteArray();
        String s = new String(bytes, 0, bytes.length, charset);
        Assert.assertEquals((String)("\n" + targetString + " \n!=\n" + s + "\n"), (String)targetString, (String)s);
    }
}

