/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.ShortPriorityQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class ShortPriorityQueueTest {
    @Test
    public void testRemove() {
        ShortPriorityQueue<Integer> queue = new ShortPriorityQueue<Integer>(new IntComparator(), 4);
        queue.offer(1);
        queue.offer(55);
        queue.offer(233);
        Assert.assertEquals((int)3, (int)queue.size());
        Assert.assertTrue((boolean)queue.remove(55));
        Assert.assertFalse((boolean)queue.remove(10001));
        Assert.assertEquals((int)2, (int)queue.size());
        Assert.assertTrue((boolean)queue.contains(1));
        Assert.assertTrue((boolean)queue.contains(233));
        Assert.assertFalse((boolean)queue.contains(55));
    }

    @Test
    public void testClear() {
        ShortPriorityQueue<Integer> queue = new ShortPriorityQueue<Integer>(new IntComparator(), 4);
        Assert.assertEquals((int)0, (int)queue.size());
        queue.clear();
        Assert.assertEquals((int)0, (int)queue.size());
        queue.offer(42);
        Assert.assertEquals((int)1, (int)queue.size());
        queue.offer(42);
        Assert.assertEquals((int)2, (int)queue.size());
        queue.offer(43);
        Assert.assertEquals((int)3, (int)queue.size());
        queue.clear();
        Assert.assertEquals((int)0, (int)queue.size());
    }

    @Test
    public void testOne() {
        ShortPriorityQueue<Integer> queue = new ShortPriorityQueue<Integer>(new IntComparator(), 4);
        Assert.assertEquals((int)0, (int)queue.size());
        Iterator it = queue.iterator();
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertNull(queue.peek());
        Assert.assertNull(queue.peekLast());
        Assert.assertNull(queue.poll());
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertTrue((boolean)queue.offer(1));
        Assert.assertTrue((boolean)queue.offer(3));
        Assert.assertEquals((int)2, (int)queue.size());
        it = queue.iterator();
        Assert.assertEquals((Object)3, it.next());
        Assert.assertEquals((Object)1, it.next());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((Object)3, queue.peek());
        Assert.assertEquals((Object)1, queue.peekLast());
        Assert.assertTrue((boolean)queue.offer(50));
        Assert.assertTrue((boolean)queue.offer(20));
        Assert.assertTrue((boolean)queue.offer(7));
        Assert.assertFalse((boolean)queue.offer(0));
        Assert.assertTrue((boolean)queue.offer(4));
        Assert.assertTrue((boolean)queue.offer(50));
        Assert.assertEquals((int)4, (int)queue.size());
        it = queue.iterator();
        Assert.assertEquals((Object)50, it.next());
        Assert.assertEquals((Object)50, it.next());
        Assert.assertEquals((Object)20, it.next());
        Assert.assertEquals((Object)7, it.next());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertTrue((boolean)queue.offer(8));
        Assert.assertEquals((Object)50, queue.poll());
        Assert.assertEquals((Object)50, queue.peek());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupported() {
        ShortPriorityQueue<Integer> queue = new ShortPriorityQueue<Integer>(new IntComparator(), 10);
        queue.add(42);
    }

    @Test
    public void testRandom() {
        int[] xs = new int[1000];
        int i = 0;
        while (i < 100) {
            Random random = new Random();
            ShortPriorityQueue<Integer> queue = new ShortPriorityQueue<Integer>(new IntComparator(), 10);
            int j = 0;
            while (j < xs.length) {
                int z = random.nextInt(10000);
                queue.offer(z);
                xs[j] = z;
                ++j;
            }
            Iterator it = queue.iterator();
            Arrays.sort(xs);
            int k = 0;
            while (k < 10) {
                Assert.assertEquals((int)xs[1000 - k - 1], (int)((Integer)it.next()));
                ++k;
            }
            ++i;
        }
    }

    static class IntComparator
    implements Comparator {
        IntComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Integer int1 = (Integer)obj1;
            Integer int2 = (Integer)obj2;
            return int1.compareTo(int2);
        }
    }
}

