/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.ObjectToCounterMap;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class ObjectToCounterMapTest {
    @Test
    public void testConstructor() {
        ObjectToCounterMap map = new ObjectToCounterMap();
        Assert.assertNotNull(map);
    }

    @Test
    public void testIncrement() {
        ObjectToCounterMap<String> map = new ObjectToCounterMap<String>();
        Assert.assertEquals((int)0, (int)map.getCount("a"));
        map.increment("a");
        Assert.assertEquals((int)1, (int)map.getCount("a"));
        map.increment("a");
        Assert.assertEquals((int)2, (int)map.getCount("a"));
        map.increment("a", 5);
        Assert.assertEquals((int)7, (int)map.getCount("a"));
        Assert.assertTrue((boolean)map.containsKey("a"));
        map.increment("a", -7);
        Assert.assertFalse((boolean)map.containsKey("a"));
    }

    @Test
    public void testSet() {
        ObjectToCounterMap<String> map = new ObjectToCounterMap<String>();
        map.set("a", 3);
        Assert.assertEquals((int)3, (int)map.getCount("a"));
        Assert.assertTrue((boolean)map.containsKey("a"));
        map.set("a", 0);
        Assert.assertEquals((int)0, (int)map.getCount("a"));
        Assert.assertFalse((boolean)map.containsKey("a"));
        map.set("a", 3);
        map.set("a", 4);
        Assert.assertEquals((int)4, (int)map.getCount("a"));
        map.set("b", 17);
        Assert.assertEquals((int)17, (int)map.getCount("b"));
    }

    @Test
    public void testKeysOrderedByCount() {
        ObjectToCounterMap<String> map = new ObjectToCounterMap<String>();
        map.set("e", 1);
        map.set("c", 3);
        map.set("d", 2);
        map.set("a", 5);
        List keysOrderedByCount = map.keysOrderedByCountList();
        Assert.assertEquals(Arrays.asList("a", "c", "d", "e"), keysOrderedByCount);
    }

    @Test
    public void testCountComparator() {
        ObjectToCounterMap<Object> map = new ObjectToCounterMap<Object>();
        Object o1 = new Object();
        Object o2 = new Object();
        map.set(o1, 2);
        map.set(o2, 2);
        Assert.assertEquals((int)0, (int)map.countComparator().compare(o1, o2));
        map.set(o1, 3);
        Assert.assertEquals((int)-1, (int)map.countComparator().compare(o1, o2));
        map.set(o1, 1);
        Assert.assertEquals((int)1, (int)map.countComparator().compare(o1, o2));
        String s1 = "a";
        String s2 = "b";
        map.set(s1, 2);
        map.set(s2, 2);
        Assert.assertEquals((int)-1, (int)map.countComparator().compare(s1, s2));
        map.set(s1, 3);
        Assert.assertEquals((int)-1, (int)map.countComparator().compare(s1, s2));
        map.set(s1, 1);
        Assert.assertEquals((int)1, (int)map.countComparator().compare(s1, s2));
        map.set(o1, 1);
        map.set(s1, 1);
        Assert.assertEquals((int)0, (int)map.countComparator().compare(o1, s1));
    }

    @Test
    public void testPrune() {
        ObjectToCounterMap<Integer> map = new ObjectToCounterMap<Integer>();
        Integer o1 = 1;
        Integer o2 = 2;
        Integer o3 = 3;
        map.set(o1, 1);
        map.set(o2, 1);
        map.set(o3, 3);
        Assert.assertEquals((int)3, (int)map.size());
        Assert.assertEquals((int)3, (int)map.getCount(o3));
        Assert.assertEquals((int)1, (int)map.getCount(o1));
        Assert.assertEquals((int)0, (int)map.getCount(10));
        map.prune(1);
        Assert.assertEquals((int)3, (int)map.size());
        map.prune(2);
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertEquals((int)3, (int)map.getCount(o3));
        Assert.assertEquals((int)0, (int)map.getCount(o1));
    }
}

