/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.test.unit.Asserts;
import com.aliasi.util.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import org.junit.Test;

public class IteratorsTest {
    @Test
    public void testOne() {
        List<String> xs = Arrays.asList(new String[0]);
        Asserts.assertEqualsIterations(xs.iterator(), new TrueIterator(xs.iterator()));
        Asserts.assertEqualsIterations(xs.iterator(), new FalseIterator(xs.iterator()));
        List<String> ys = Arrays.asList("a", "b", "c");
        Asserts.assertEqualsIterations(ys.iterator(), new TrueIterator(ys.iterator()));
        Asserts.assertEqualsIterations(xs.iterator(), new FalseIterator(ys.iterator()));
        List<String> zs1 = Arrays.asList("a", "b", "c");
        List<String> zs1a = Arrays.asList("b", "c");
        Asserts.assertEqualsIterations(zs1a.iterator(), new RemoveIterator(zs1.iterator(), "a"));
        List<String> zs1b = Arrays.asList("a", "c");
        Asserts.assertEqualsIterations(zs1b.iterator(), new RemoveIterator(zs1.iterator(), "b"));
        List<String> zs1c = Arrays.asList("a", "b");
        Asserts.assertEqualsIterations(zs1c.iterator(), new RemoveIterator(zs1.iterator(), "c"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testTwo() {
        List<String> xs = Arrays.asList("a", "b");
        TrueIterator it = new TrueIterator(xs.iterator());
        Assert.assertNotNull(it.next());
        it.remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void testExcThreeA() {
        List<String> xs = Arrays.asList(new String[0]);
        TrueIterator it = new TrueIterator(xs.iterator());
        Assert.assertFalse((boolean)it.hasNext());
        it.next();
    }

    @Test(expected=NoSuchElementException.class)
    public void testExcThreeB() {
        List<String> ys = Arrays.asList("a", "b");
        TrueIterator it2 = new TrueIterator(ys.iterator());
        Assert.assertNotNull(it2.next());
        Assert.assertNotNull(it2.next());
        Assert.assertFalse((boolean)it2.hasNext());
        it2.next();
    }

    @Test
    public void testBufferedOne() {
        List<String> xs = Arrays.asList(new String[0]);
        ListBufferedIterator it = new ListBufferedIterator(xs.iterator());
        Asserts.assertEqualsIterations(xs.iterator(), it);
        List<String> ys = Arrays.asList("a");
        ListBufferedIterator it2 = new ListBufferedIterator(ys.iterator());
        Asserts.assertEqualsIterations(ys.iterator(), it2);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testBufferedTwo() {
        List<String> xs = Arrays.asList(new String[0]);
        ListBufferedIterator it = new ListBufferedIterator(xs.iterator());
        it.remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void testBufferedThreeExcA() {
        List<String> xs = Arrays.asList(new String[0]);
        ListBufferedIterator it = new ListBufferedIterator(xs.iterator());
        it.next();
    }

    @Test(expected=NoSuchElementException.class)
    public void testBufferedThreeExcB() {
        List<String> ys = Arrays.asList("a", "b", "c");
        ListBufferedIterator it2 = new ListBufferedIterator(ys.iterator());
        Assert.assertNotNull(it2.next());
        Assert.assertNotNull(it2.next());
        Assert.assertNotNull(it2.next());
        it2.next();
    }

    @Test(expected=IllegalStateException.class)
    public void testSIOne() {
        HashSet s1 = new HashSet();
        List<Iterator> its = Arrays.asList(s1.iterator());
        Iterator it = Iterators.sequence(its);
        this.assertIteration(it, new Object[0]);
        it.remove();
    }

    @Test(expected=IllegalStateException.class)
    public void testSIOneB() {
        HashSet s1 = new HashSet();
        HashSet s2 = new HashSet();
        Iterator it2 = Iterators.sequence(Arrays.asList(s1.iterator(), s2.iterator()));
        this.assertIteration(it2, new Object[0]);
        it2.remove();
    }

    @Test(expected=IllegalStateException.class)
    public void testSIOneC() {
        HashSet s1 = new HashSet();
        HashSet s2 = new HashSet();
        Iterator it3 = Iterators.sequence(Arrays.asList(s1.iterator(), s2.iterator()));
        this.assertIteration(it3, new Object[0]);
        it3.remove();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() {
        List<String> xs = Arrays.asList("a", "b");
        List<String> ixs = Collections.unmodifiableList(xs);
        Iterator it2 = Iterators.sequence(Arrays.asList(ixs.iterator()));
        it2.next();
        it2.remove();
    }

    @Test(expected=IllegalStateException.class)
    public void testSITwo() {
        HashSet<String> s1 = new HashSet<String>();
        s1.add("a");
        Iterator it = Iterators.sequence(Arrays.asList(s1.iterator()));
        this.assertIteration(it, new Object[]{"a"});
        it.remove();
        Assert.assertEquals((Object)Collections.EMPTY_SET, s1);
        it.remove();
    }

    @Test
    public void testSITwoB() {
        List<String> xs = Arrays.asList("a", "b");
        List<String> ixs = Collections.unmodifiableList(xs);
        Iterator it2 = Iterators.sequence(Arrays.asList(ixs.iterator()));
        this.assertIteration(it2, new Object[]{"a", "b"});
        ArrayList<String> xs2 = new ArrayList<String>();
        xs2.add("a");
        xs2.add("b");
        Iterator it3 = Iterators.sequence(Arrays.asList(xs2.iterator()));
        this.assertIteration(it3, new Object[]{"a", "b"});
        it3.remove();
        ArrayList<String> xs2expected = new ArrayList<String>();
        xs2expected.add("a");
        Assert.assertEquals(xs2expected, xs2);
        ArrayList<String> xs3 = new ArrayList<String>();
        xs3.add("a");
        xs3.add("b");
        Iterator it4 = Iterators.sequence(Arrays.asList(xs3.iterator()));
        it4.next();
        it4.remove();
        ArrayList<String> xs3expected = new ArrayList<String>();
        xs3expected.add("b");
        Assert.assertEquals(xs3expected, xs3);
    }

    @Test
    public void testSIThree() {
        ArrayList<String> ab = new ArrayList<String>();
        ab.add("a");
        ab.add("b");
        ArrayList<String> c = new ArrayList<String>();
        c.add("c");
        ArrayList<String> de = new ArrayList<String>();
        de.add("d");
        de.add("e");
        Iterator it = Iterators.sequence(Arrays.asList(ab.iterator(), c.iterator(), de.iterator()));
        this.assertIteration(it, new Object[]{"a", "b", "c", "d", "e"});
    }

    @Test
    public void testSIFour() {
        ArrayList<String> ab = new ArrayList<String>();
        ab.add("a");
        ab.add("b");
        ArrayList empty = new ArrayList();
        ArrayList<String> cde = new ArrayList<String>();
        cde.add("c");
        cde.add("d");
        cde.add("e");
        this.assertIteration(Iterators.sequence(Arrays.asList(empty.iterator(), ab.iterator(), cde.iterator())), new Object[]{"a", "b", "c", "d", "e"});
        this.assertIteration(Iterators.sequence(Arrays.asList(ab.iterator(), empty.iterator(), cde.iterator())), new Object[]{"a", "b", "c", "d", "e"});
        this.assertIteration(Iterators.sequence(Arrays.asList(ab.iterator(), cde.iterator(), empty.iterator())), new Object[]{"a", "b", "c", "d", "e"});
        this.assertIteration(Iterators.sequence(Arrays.asList(empty.iterator(), empty.iterator(), ab.iterator(), empty.iterator(), empty.iterator(), cde.iterator(), empty.iterator(), empty.iterator())), new Object[]{"a", "b", "c", "d", "e"});
    }

    @Test
    public void testSIFive() {
        ArrayList<String> ab = new ArrayList<String>();
        ab.add("a");
        ab.add("b");
        ArrayList<String> cd = new ArrayList<String>();
        cd.add("c");
        cd.add("d");
        Iterator it = Iterators.sequence(Arrays.asList(ab.iterator(), cd.iterator()));
        it.next();
        it.next();
        it.remove();
        ArrayList<String> a = new ArrayList<String>();
        a.add("a");
        Assert.assertEquals(a, ab);
        it.next();
        it.remove();
        ArrayList<String> d = new ArrayList<String>();
        d.add("d");
        Assert.assertEquals(d, cd);
    }

    @Test
    public void testSISix() {
        ArrayList empty = new ArrayList();
        ArrayList<String> ab = new ArrayList<String>();
        ab.add("a");
        ab.add("b");
        ArrayList<String> cd = new ArrayList<String>();
        cd.add("c");
        cd.add("d");
        Iterator it = Iterators.sequence(Arrays.asList(ab.iterator(), empty.iterator(), empty.iterator(), cd.iterator()));
        it.next();
        it.next();
        it.remove();
        ArrayList<String> a = new ArrayList<String>();
        a.add("a");
        Assert.assertEquals(a, ab);
        it.next();
        it.remove();
        ArrayList<String> d = new ArrayList<String>();
        d.add("d");
        Assert.assertEquals(d, cd);
    }

    public void assertIteration(Iterator<?> it, Object[] values) {
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object val = objectArray[n2];
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertEquals((Object)val, it.next());
            ++n2;
        }
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testArrayIterators() {
        this.assertIteration(new Integer[0]);
        this.assertIteration(new Integer[]{0});
        this.assertIteration(new Integer[]{0, 1});
        this.assertIteration(new Integer[]{0, 1, 2});
        this.assertIteration(new Integer[]{0, 1, 2, 3});
        Object[] xs = new Object[]{"a", "b", "c"};
        Assert.assertNotNull((Object)xs[1]);
        Iterator<Object> it = Iterators.array(xs);
        it.next();
        it.next();
        it.remove();
        Assert.assertNull((Object)xs[1]);
        Object[] ys = new Object[]{"a"};
        Assert.assertNotNull((Object)ys[0]);
        it = Iterators.array(ys);
        boolean threw = false;
        try {
            it.remove();
        }
        catch (IllegalStateException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
        threw = false;
        it.next();
        it.remove();
        try {
            it.remove();
        }
        catch (IllegalStateException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
    }

    public void assertIteration(Object[] objs) {
        Iterator<Object> it = Iterators.array(objs);
        int i = 0;
        while (i < objs.length) {
            Assert.assertEquals((Object)objs[i], (Object)it.next());
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        boolean threw = false;
        try {
            it.next();
        }
        catch (NoSuchElementException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
    }

    @Test(expected=NoSuchElementException.class)
    public void testSliceIteratorA() {
        Object[] xs = new Object[]{};
        this.assertSliceIterator(xs, 0, 0);
    }

    @Test(expected=NoSuchElementException.class)
    public void testSliceIteratorB() {
        Object[] ys = new Object[]{"A"};
        this.assertSliceIterator(ys, 0, 1);
    }

    @Test(expected=NoSuchElementException.class)
    public void testSliceIteratorC() {
        Object[] zs = new Object[]{"A", "B", "C", "D"};
        this.assertSliceIterator(zs, 0, 4);
    }

    @Test(expected=NoSuchElementException.class)
    public void testSliceIteratorD() {
        Object[] zs = new Object[]{"A", "B", "C", "D"};
        this.assertSliceIterator(zs, 2, 2);
    }

    @Test(expected=NoSuchElementException.class)
    public void testSliceIteratorE() {
        Object[] zs = new Object[]{"A", "B", "C", "D"};
        this.assertSliceIterator(zs, 0, 2);
    }

    @Test(expected=NoSuchElementException.class)
    public void testSliceIteratorF() {
        Object[] zs = new Object[]{"A", "B", "C", "D"};
        this.assertSliceIterator(zs, 2, 1);
    }

    public void assertSliceIterator(Object[] objs, int start, int length) {
        Iterator<Object> it = Iterators.arraySlice(objs, start, length);
        int i = 0;
        while (i < length) {
            Assert.assertEquals((Object)it.next(), (Object)objs[start + i]);
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        it.next();
    }

    static class FalseIterator
    extends Iterators.Filter {
        public FalseIterator(Iterator it) {
            super(it);
        }

        public boolean accept(Object x) {
            return false;
        }
    }

    public static class ListBufferedIterator
    extends Iterators.Buffered {
        private final Iterator mIterator;

        public ListBufferedIterator(Iterator iterator) {
            this.mIterator = iterator;
        }

        /*
         * Unable to fully structure code
         */
        public Object bufferNext() {
            if (this.mIterator.hasNext()) ** GOTO lbl6
            return null;
lbl-1000:
            // 1 sources

            {
                next = this.mIterator.next();
                if (next == null) continue;
                return next;
lbl6:
                // 2 sources

                ** while (this.mIterator.hasNext())
            }
lbl7:
            // 1 sources

            return null;
        }
    }

    static class RemoveIterator
    extends Iterators.Filter {
        private final String mX;

        public RemoveIterator(Iterator it, String x) {
            super(it);
            this.mX = x;
        }

        public boolean accept(Object x) {
            return !x.equals(this.mX);
        }
    }

    static class TrueIterator
    extends Iterators.Filter {
        public TrueIterator(Iterator it) {
            super(it);
        }

        public boolean accept(Object x) {
            return true;
        }
    }
}

