/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.FastCache;
import com.aliasi.util.Strings;
import java.util.Map;
import java.util.Random;

public class HammerFastCache {
    static final Random RANDOM = new Random();
    static final long NUM_TESTS = 100000000000L;
    static final int DIMENSIONS = 40;
    static double sNextVal = 0.0;
    static long sElapsedSum = 0L;
    static long sStartTime;

    public static void main(String[] args) {
        sStartTime = System.currentTimeMillis();
        System.out.println("\nFastCache");
        HammerFastCache.hammer(new FastCache<String, double[]>(100000));
    }

    static void hammer(Map<String, double[]> cache) {
        long start = System.currentTimeMillis();
        long i = 1L;
        while (i <= 100000000000L) {
            String s = HammerFastCache.nextString();
            double[] a = HammerFastCache.nextArray();
            cache.put(s, a);
            long current = System.currentTimeMillis();
            long elapsed = current - start;
            start = current;
            double avg = (double)(sElapsedSum += elapsed) / (double)i;
            if (elapsed > 100L || i % 10000000L == 0L) {
                System.out.println(String.valueOf(i) + " t=" + elapsed + "ms" + " avg=" + avg + "ms" + " total time=" + Strings.msToString(current - sStartTime));
            }
            ++i;
        }
    }

    static String nextString() {
        char[] cs = new char[RANDOM.nextBoolean() ? 1 : (RANDOM.nextBoolean() ? 2 : (RANDOM.nextBoolean() ? 3 : (RANDOM.nextBoolean() ? 4 : (RANDOM.nextBoolean() ? 5 : 6))))];
        int i = 0;
        while (i < cs.length) {
            cs[i] = (char)RANDOM.nextInt(128);
            ++i;
        }
        return new String(cs);
    }

    static double[] nextArray() {
        double[] result = new double[40];
        int i = 0;
        while (i < result.length) {
            result[i] = sNextVal;
            sNextVal += 1.0E-4;
            ++i;
        }
        return result;
    }
}

