/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class ArraysTest {
    @Test
    public void testAdd() {
        this.testAdd("", 'a', "a");
        this.testAdd("b", 'a', "ab");
        this.testAdd("b", 'b', "b");
        this.testAdd("b", 'c', "bc");
        this.testAdd("dg", 'a', "adg");
        this.testAdd("dg", 'd', "dg");
        this.testAdd("dg", 'e', "deg");
        this.testAdd("dg", 'g', "dg");
        this.testAdd("dg", 'h', "dgh");
        this.testAdd("dgj", 'd', "dgj");
        this.testAdd("dgj", 'g', "dgj");
        this.testAdd("dgj", 'j', "dgj");
        this.testAdd("dgj", 'a', "adgj");
        this.testAdd("dgj", 'e', "degj");
        this.testAdd("dgj", 'h', "dghj");
        this.testAdd("dgj", 'k', "dgjk");
    }

    void testAdd(String csIn, char c, String csOut) {
        char[] cs = csIn.toCharArray();
        char[] cs2 = Arrays.add(c, cs);
        junit.framework.Assert.assertEquals((String)csOut, (String)new String(cs2));
    }

    @Test
    public void testPermute() {
        Integer[] xs = new Integer[]{};
        Arrays.permute(xs);
        xs = new Integer[]{5};
        Arrays.permute(xs);
        junit.framework.Assert.assertEquals((Object)5, (Object)xs[0]);
        xs = new Integer[]{0, 1};
        Arrays.permute(xs);
        junit.framework.Assert.assertTrue((xs[0].equals(0) && xs[1].equals(1) || xs[0].equals(1) && xs[1].equals(0) ? 1 : 0) != 0);
        xs = new Integer[100];
        int i = 0;
        while (i < 100) {
            xs[i] = i;
            ++i;
        }
        Arrays.permute(xs);
        HashSet<Integer> resultSet = new HashSet<Integer>(200);
        int i2 = 0;
        while (i2 < xs.length) {
            int val = xs[i2];
            junit.framework.Assert.assertTrue((val >= 0 && val < 100 ? 1 : 0) != 0);
            resultSet.add(xs[i2]);
            ++i2;
        }
        junit.framework.Assert.assertEquals((int)100, (int)resultSet.size());
    }

    @Test
    public void testReallocate() {
        int[] xs = new int[]{1, 2, 3};
        this.assertReallocate(xs, 5);
        this.assertReallocate(xs, 3);
        this.assertReallocate(xs, 1);
        this.assertReallocate(xs, 0);
        int[] zs = new int[]{};
        this.assertReallocate(zs, 0);
        this.assertReallocate(zs, 3);
    }

    void assertReallocate(int[] xs, int len) {
        int[] ys = Arrays.reallocate(xs, len);
        junit.framework.Assert.assertEquals((int)len, (int)ys.length);
        int i = 0;
        while (i < xs.length && i < len) {
            junit.framework.Assert.assertEquals((int)xs[i], (int)ys[i]);
            ++i;
        }
        i = xs.length;
        while (i < ys.length) {
            junit.framework.Assert.assertEquals((int)0, (int)ys[i]);
            ++i;
        }
    }

    @Test
    public void testEquals() {
        Object[] xs1 = new String[]{"a", "b", "c"};
        Object[] xs2 = new String[]{"a", "b", "c"};
        Object[] xs3 = new String[]{"a", "b"};
        junit.framework.Assert.assertTrue((boolean)Arrays.equals(xs1, xs2));
        junit.framework.Assert.assertFalse((boolean)Arrays.equals(xs2, xs3));
        junit.framework.Assert.assertTrue((boolean)Arrays.equals(new Object[0], new Object[0]));
    }

    @Test
    public void testMemberObject() {
        junit.framework.Assert.assertFalse((boolean)Arrays.member("a", null));
        Object[] objectArray = new Object[2];
        objectArray[0] = "b";
        junit.framework.Assert.assertFalse((boolean)Arrays.member("a", objectArray));
        junit.framework.Assert.assertFalse((boolean)Arrays.member("a", new Object[0]));
        junit.framework.Assert.assertTrue((boolean)Arrays.member("a", new Object[]{"a"}));
        Object[] objectArray2 = new Object[2];
        objectArray2[1] = "a";
        junit.framework.Assert.assertTrue((boolean)Arrays.member("a", objectArray2));
    }

    @Test
    public void testMemberChar() {
        junit.framework.Assert.assertFalse((boolean)Arrays.member('a', null));
        junit.framework.Assert.assertFalse((boolean)Arrays.member('a', new char[0]));
        junit.framework.Assert.assertFalse((boolean)Arrays.member('a', new char[]{'b', 'c'}));
        junit.framework.Assert.assertTrue((boolean)Arrays.member('a', new char[]{'a'}));
        junit.framework.Assert.assertTrue((boolean)Arrays.member('a', new char[]{'b', 'a'}));
    }

    @Test
    public void testArrayToString() {
        junit.framework.Assert.assertEquals((String)"[]", (String)Arrays.arrayToString(new Object[0]));
        junit.framework.Assert.assertEquals((String)"[a]", (String)Arrays.arrayToString(new Object[]{"a"}));
        junit.framework.Assert.assertEquals((String)"[a,b]", (String)Arrays.arrayToString(new Object[]{"a", "b"}));
    }

    @Test
    public void testArrayToStringBuilder() {
        StringBuilder sb = new StringBuilder();
        Arrays.arrayToStringBuilder(sb, new Object[0]);
        junit.framework.Assert.assertEquals((String)"[]", (String)sb.toString());
        sb = new StringBuilder();
        Arrays.arrayToStringBuilder(sb, new Object[]{"a"});
        junit.framework.Assert.assertEquals((String)"[a]", (String)sb.toString());
        sb = new StringBuilder();
        Arrays.arrayToStringBuilder(sb, new Object[]{"a", "b"});
        junit.framework.Assert.assertEquals((String)"[a,b]", (String)sb.toString());
    }

    @Test
    public void testConcatenate() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])Arrays.concatenate(new String[0], new String[0]));
        Assert.assertArrayEquals((Object[])new String[]{"a"}, (Object[])Arrays.concatenate(new String[]{"a"}, new String[0]));
        Assert.assertArrayEquals((Object[])new String[]{"b"}, (Object[])Arrays.concatenate(new String[0], new String[]{"b"}));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])Arrays.concatenate(new String[]{"a", "b"}, new String[]{"c", "d"}));
    }
}

