/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import junit.framework.Assert;
import org.junit.Test;

public class AbstractExternalizableTest {
    @Test
    public void testCompile() throws IOException, ClassNotFoundException {
        CompilableInteger ci = new CompilableInteger(5);
        Assert.assertEquals((Object)5, (Object)AbstractExternalizable.compile(ci));
    }

    @Test
    public void testExternalizable() throws IOException, ClassNotFoundException {
        ECompilableInteger ci = new ECompilableInteger(5);
        Assert.assertEquals((Object)5, (Object)AbstractExternalizable.compile(ci));
    }

    @Test
    public void testEitherOr() throws IOException, ClassNotFoundException {
        TestBoth t1 = new TestBoth();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        AbstractExternalizable.serializeOrCompile(t1, objOut);
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
        Object x = objIn.readObject();
        Assert.assertEquals((Object)5, (Object)x);
        bytesOut = new ByteArrayOutputStream();
        objOut = new ObjectOutputStream(bytesOut);
        AbstractExternalizable.compileOrSerialize(t1, objOut);
        bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
        objIn = new ObjectInputStream(bytesIn);
        x = objIn.readObject();
        Assert.assertEquals((Object)10, (Object)x);
    }

    private static class CompilableInteger
    implements Compilable {
        private final int mVal;

        public CompilableInteger(int val) {
            this.mVal = val;
        }

        @Override
        public void compileTo(ObjectOutput out) throws IOException {
            out.writeObject(this.mVal);
        }
    }

    private static class ECompilableInteger
    implements Compilable {
        private final int mVal;

        public ECompilableInteger(int val) {
            this.mVal = val;
        }

        @Override
        public void compileTo(ObjectOutput out) throws IOException {
            out.writeObject(new Externalizer(this));
        }

        private static class Externalizer
        extends AbstractExternalizable {
            private static final long serialVersionUID = -8136168142449855303L;
            private final ECompilableInteger mCI;

            public Externalizer() {
                this(null);
            }

            public Externalizer(ECompilableInteger ci) {
                this.mCI = ci;
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                out.writeInt(this.mCI.mVal);
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readInt();
            }
        }
    }

    static class TestBoth
    implements Compilable,
    Serializable {
        TestBoth() {
        }

        @Override
        public void compileTo(ObjectOutput out) throws IOException {
            out.writeObject(10);
        }

        public Object writeReplace() {
            return 5;
        }
    }
}

