/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.tokenizer.EnglishStopTokenizerFactory;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.LowerCaseTokenizerFactory;
import com.aliasi.tokenizer.PorterStemmerTokenizerFactory;
import com.aliasi.tokenizer.TokenChunker;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Test;

public class TokenChunkerTest {
    @Test
    public void testChunker() throws IOException {
        IndoEuropeanTokenizerFactory tf = IndoEuropeanTokenizerFactory.INSTANCE;
        TokenChunker chunker = new TokenChunker(tf);
        String s = "";
        this.assertChunking(chunker, "", new String[0], new int[0], new int[0]);
        this.assertChunking(chunker, "     ", new String[0], new int[0], new int[0]);
        int[] nArray = new int[3];
        nArray[1] = 5;
        nArray[2] = 8;
        this.assertChunking(chunker, "John ran.", new String[]{"John", "ran", "."}, nArray, new int[]{4, 8, 9});
        this.assertChunking(chunker, " John    ran.", new String[]{"John", "ran", "."}, new int[]{1, 9, 12}, new int[]{5, 12, 13});
    }

    @Test
    public void testCompoundChunkers() throws IOException {
        TokenizerFactory tf = IndoEuropeanTokenizerFactory.INSTANCE;
        tf = new LowerCaseTokenizerFactory(tf);
        tf = new EnglishStopTokenizerFactory(tf);
        tf = new PorterStemmerTokenizerFactory(tf);
        TokenChunker chunker = new TokenChunker(tf);
        this.assertChunking(chunker, "", new String[0], new int[0], new int[0]);
        this.assertChunking(chunker, " John  is running ", new String[]{PorterStemmerTokenizerFactory.stem("john"), PorterStemmerTokenizerFactory.stem("running")}, new int[]{1, 10}, new int[]{5, 17});
    }

    void assertChunking(TokenChunker chunker, String in, String[] types, int[] starts, int[] ends) throws IOException {
        this.assertChunkingResult(chunker, in, types, starts, ends);
        Chunker chunker2 = (Chunker)AbstractExternalizable.serializeDeserialize(chunker);
    }

    void assertChunkingResult(Chunker chunker, String in, String[] types, int[] starts, int[] ends) throws IOException {
        Chunking chunking = chunker.chunk(in);
        Chunk[] chunks = chunking.chunkSet().toArray(new Chunk[0]);
        Arrays.sort(chunks, Chunk.TEXT_ORDER_COMPARATOR);
        Assert.assertEquals((int)types.length, (int)starts.length);
        Assert.assertEquals((int)starts.length, (int)ends.length);
        Assert.assertEquals((int)chunks.length, (int)types.length);
        int i = 0;
        while (i < chunks.length) {
            Assert.assertEquals((String)types[i], (String)chunks[i].type());
            Assert.assertEquals((int)starts[i], (int)chunks[i].start());
            Assert.assertEquals((int)ends[i], (int)chunks[i].end());
            ++i;
        }
    }
}

