/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.test.unit.Asserts;
import com.aliasi.test.unit.tokenizer.TokenizerTest;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.StopTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Test;

public class StopTokenizerFactoryTest {
    static final Set<String> TEST_STOP_SET = new HashSet<String>(Arrays.asList("a", "the", "it"));

    @Test
    public void testFactory() {
        IndoEuropeanTokenizerFactory ieFactory = IndoEuropeanTokenizerFactory.INSTANCE;
        StopTokenizerFactory factory = new StopTokenizerFactory(ieFactory, TEST_STOP_SET);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "a", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "a the", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "The starling is flying it", "The", "starling", "is", "flying");
        TokenizerTest.assertFactory((TokenizerFactory)factory, "a AA A BBB", "AA", "A", "BBB");
    }

    @Test
    public void testNotSerializable() {
        StopTokenizerFactory unserializable = new StopTokenizerFactory(TokenizerTest.UNSERIALIZABLE_FACTORY, TEST_STOP_SET);
        Asserts.assertNotSerializable(unserializable);
    }
}

